/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account.message;

import com.twilio.base.Deleter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.api.v2010.account.message.Media;

public class MediaDeleter
extends Deleter<Media> {
    private String accountSid;
    private final String messageSid;
    private final String sid;

    public MediaDeleter(String messageSid, String sid) {
        this.messageSid = messageSid;
        this.sid = sid;
    }

    public MediaDeleter(String accountSid, String messageSid, String sid) {
        this.accountSid = accountSid;
        this.messageSid = messageSid;
        this.sid = sid;
    }

    @Override
    public boolean delete(TwilioRestClient client) {
        this.accountSid = this.accountSid == null ? client.getAccountSid() : this.accountSid;
        Request request = new Request(HttpMethod.DELETE, Domains.API.toString(), "/2010-04-01/Accounts/" + this.accountSid + "/Messages/" + this.messageSid + "/Media/" + this.sid + ".json", client.getRegion());
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Media delete failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return response.getStatusCode() == 204;
    }
}

