/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account.message;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.api.v2010.account.message.FeedbackCreator;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Feedback
extends Resource {
    private static final long serialVersionUID = 255348385418437L;
    private final String accountSid;
    private final String messageSid;
    private final Outcome outcome;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final String uri;

    public static FeedbackCreator creator(String accountSid, String messageSid) {
        return new FeedbackCreator(accountSid, messageSid);
    }

    public static FeedbackCreator creator(String messageSid) {
        return new FeedbackCreator(messageSid);
    }

    public static Feedback fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Feedback.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Feedback fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Feedback.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Feedback(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="message_sid") String messageSid, @JsonProperty(value="outcome") Outcome outcome, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="uri") String uri) {
        this.accountSid = accountSid;
        this.messageSid = messageSid;
        this.outcome = outcome;
        this.dateCreated = DateConverter.rfc2822DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.rfc2822DateTimeFromString(dateUpdated);
        this.uri = uri;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getMessageSid() {
        return this.messageSid;
    }

    public final Outcome getOutcome() {
        return this.outcome;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getUri() {
        return this.uri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Feedback other = (Feedback)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.messageSid, other.messageSid) && Objects.equals((Object)this.outcome, (Object)other.outcome) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.uri, other.uri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountSid, this.messageSid, this.outcome, this.dateCreated, this.dateUpdated, this.uri});
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("accountSid", this.accountSid).add("messageSid", this.messageSid).add("outcome", (Object)this.outcome).add("dateCreated", this.dateCreated).add("dateUpdated", this.dateUpdated).add("uri", this.uri).toString();
    }

    public static enum Outcome {
        CONFIRMED("confirmed"),
        UMCONFIRMED("umconfirmed");

        private final String value;

        private Outcome(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Outcome forValue(String value) {
            String normalized = value.replace("-", "_").toUpperCase();
            try {
                return Outcome.valueOf(normalized);
            }
            catch (RuntimeException e) {
                return null;
            }
        }
    }
}

