/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account.incomingphonenumber;

import com.twilio.base.Creator;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.api.v2010.account.incomingphonenumber.Mobile;
import com.twilio.type.PhoneNumber;
import java.net.URI;

public class MobileCreator
extends Creator<Mobile> {
    private String ownerAccountSid;
    private final PhoneNumber phoneNumber;
    private String apiVersion;
    private String friendlyName;
    private String smsApplicationSid;
    private HttpMethod smsFallbackMethod;
    private URI smsFallbackUrl;
    private HttpMethod smsMethod;
    private URI smsUrl;
    private URI statusCallback;
    private HttpMethod statusCallbackMethod;
    private String voiceApplicationSid;
    private Boolean voiceCallerIdLookup;
    private HttpMethod voiceFallbackMethod;
    private URI voiceFallbackUrl;
    private HttpMethod voiceMethod;
    private URI voiceUrl;

    public MobileCreator(PhoneNumber phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public MobileCreator(String ownerAccountSid, PhoneNumber phoneNumber) {
        this.ownerAccountSid = ownerAccountSid;
        this.phoneNumber = phoneNumber;
    }

    public MobileCreator setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    public MobileCreator setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public MobileCreator setSmsApplicationSid(String smsApplicationSid) {
        this.smsApplicationSid = smsApplicationSid;
        return this;
    }

    public MobileCreator setSmsFallbackMethod(HttpMethod smsFallbackMethod) {
        this.smsFallbackMethod = smsFallbackMethod;
        return this;
    }

    public MobileCreator setSmsFallbackUrl(URI smsFallbackUrl) {
        this.smsFallbackUrl = smsFallbackUrl;
        return this;
    }

    public MobileCreator setSmsFallbackUrl(String smsFallbackUrl) {
        return this.setSmsFallbackUrl(Promoter.uriFromString(smsFallbackUrl));
    }

    public MobileCreator setSmsMethod(HttpMethod smsMethod) {
        this.smsMethod = smsMethod;
        return this;
    }

    public MobileCreator setSmsUrl(URI smsUrl) {
        this.smsUrl = smsUrl;
        return this;
    }

    public MobileCreator setSmsUrl(String smsUrl) {
        return this.setSmsUrl(Promoter.uriFromString(smsUrl));
    }

    public MobileCreator setStatusCallback(URI statusCallback) {
        this.statusCallback = statusCallback;
        return this;
    }

    public MobileCreator setStatusCallback(String statusCallback) {
        return this.setStatusCallback(Promoter.uriFromString(statusCallback));
    }

    public MobileCreator setStatusCallbackMethod(HttpMethod statusCallbackMethod) {
        this.statusCallbackMethod = statusCallbackMethod;
        return this;
    }

    public MobileCreator setVoiceApplicationSid(String voiceApplicationSid) {
        this.voiceApplicationSid = voiceApplicationSid;
        return this;
    }

    public MobileCreator setVoiceCallerIdLookup(Boolean voiceCallerIdLookup) {
        this.voiceCallerIdLookup = voiceCallerIdLookup;
        return this;
    }

    public MobileCreator setVoiceFallbackMethod(HttpMethod voiceFallbackMethod) {
        this.voiceFallbackMethod = voiceFallbackMethod;
        return this;
    }

    public MobileCreator setVoiceFallbackUrl(URI voiceFallbackUrl) {
        this.voiceFallbackUrl = voiceFallbackUrl;
        return this;
    }

    public MobileCreator setVoiceFallbackUrl(String voiceFallbackUrl) {
        return this.setVoiceFallbackUrl(Promoter.uriFromString(voiceFallbackUrl));
    }

    public MobileCreator setVoiceMethod(HttpMethod voiceMethod) {
        this.voiceMethod = voiceMethod;
        return this;
    }

    public MobileCreator setVoiceUrl(URI voiceUrl) {
        this.voiceUrl = voiceUrl;
        return this;
    }

    public MobileCreator setVoiceUrl(String voiceUrl) {
        return this.setVoiceUrl(Promoter.uriFromString(voiceUrl));
    }

    @Override
    public Mobile create(TwilioRestClient client) {
        this.ownerAccountSid = this.ownerAccountSid == null ? client.getAccountSid() : this.ownerAccountSid;
        Request request = new Request(HttpMethod.POST, Domains.API.toString(), "/2010-04-01/Accounts/" + this.ownerAccountSid + "/IncomingPhoneNumbers/Mobile.json", client.getRegion());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Mobile creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Mobile.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.phoneNumber != null) {
            request.addPostParam("PhoneNumber", this.phoneNumber.toString());
        }
        if (this.apiVersion != null) {
            request.addPostParam("ApiVersion", this.apiVersion);
        }
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.smsApplicationSid != null) {
            request.addPostParam("SmsApplicationSid", this.smsApplicationSid);
        }
        if (this.smsFallbackMethod != null) {
            request.addPostParam("SmsFallbackMethod", this.smsFallbackMethod.toString());
        }
        if (this.smsFallbackUrl != null) {
            request.addPostParam("SmsFallbackUrl", this.smsFallbackUrl.toString());
        }
        if (this.smsMethod != null) {
            request.addPostParam("SmsMethod", this.smsMethod.toString());
        }
        if (this.smsUrl != null) {
            request.addPostParam("SmsUrl", this.smsUrl.toString());
        }
        if (this.statusCallback != null) {
            request.addPostParam("StatusCallback", this.statusCallback.toString());
        }
        if (this.statusCallbackMethod != null) {
            request.addPostParam("StatusCallbackMethod", this.statusCallbackMethod.toString());
        }
        if (this.voiceApplicationSid != null) {
            request.addPostParam("VoiceApplicationSid", this.voiceApplicationSid);
        }
        if (this.voiceCallerIdLookup != null) {
            request.addPostParam("VoiceCallerIdLookup", this.voiceCallerIdLookup.toString());
        }
        if (this.voiceFallbackMethod != null) {
            request.addPostParam("VoiceFallbackMethod", this.voiceFallbackMethod.toString());
        }
        if (this.voiceFallbackUrl != null) {
            request.addPostParam("VoiceFallbackUrl", this.voiceFallbackUrl.toString());
        }
        if (this.voiceMethod != null) {
            request.addPostParam("VoiceMethod", this.voiceMethod.toString());
        }
        if (this.voiceUrl != null) {
            request.addPostParam("VoiceUrl", this.voiceUrl.toString());
        }
    }
}

