/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account.conference;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.api.v2010.account.conference.Participant;

public class ParticipantReader
extends Reader<Participant> {
    private String accountSid;
    private final String conferenceSid;
    private Boolean muted;
    private Boolean hold;

    public ParticipantReader(String conferenceSid) {
        this.conferenceSid = conferenceSid;
    }

    public ParticipantReader(String accountSid, String conferenceSid) {
        this.accountSid = accountSid;
        this.conferenceSid = conferenceSid;
    }

    public ParticipantReader setMuted(Boolean muted) {
        this.muted = muted;
        return this;
    }

    public ParticipantReader setHold(Boolean hold) {
        this.hold = hold;
        return this;
    }

    @Override
    public ResourceSet<Participant> read(TwilioRestClient client) {
        return new ResourceSet<Participant>(this, client, this.firstPage(client));
    }

    @Override
    public Page<Participant> firstPage(TwilioRestClient client) {
        this.accountSid = this.accountSid == null ? client.getAccountSid() : this.accountSid;
        Request request = new Request(HttpMethod.GET, Domains.API.toString(), "/2010-04-01/Accounts/" + this.accountSid + "/Conferences/" + this.conferenceSid + "/Participants.json", client.getRegion());
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Participant> nextPage(Page<Participant> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.API.toString(), client.getRegion()));
        return this.pageForRequest(client, request);
    }

    private Page<Participant> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Participant read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Page.fromJson("participants", response.getContent(), Participant.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.muted != null) {
            request.addQueryParam("Muted", this.muted.toString());
        }
        if (this.hold != null) {
            request.addQueryParam("Hold", this.hold.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

