/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account.availablephonenumbercountry;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.api.v2010.account.availablephonenumbercountry.LocalReader;
import com.twilio.type.PhoneNumber;
import com.twilio.type.PhoneNumberCapabilities;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Local
extends Resource {
    private static final long serialVersionUID = 250162359733040L;
    private final PhoneNumber friendlyName;
    private final PhoneNumber phoneNumber;
    private final String lata;
    private final String rateCenter;
    private final BigDecimal latitude;
    private final BigDecimal longitude;
    private final String region;
    private final String postalCode;
    private final String isoCountry;
    private final String addressRequirements;
    private final Boolean beta;
    private final PhoneNumberCapabilities capabilities;

    public static LocalReader reader(String accountSid, String countryCode) {
        return new LocalReader(accountSid, countryCode);
    }

    public static LocalReader reader(String countryCode) {
        return new LocalReader(countryCode);
    }

    public static Local fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Local.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Local fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Local.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Local(@JsonProperty(value="friendly_name") PhoneNumber friendlyName, @JsonProperty(value="phone_number") PhoneNumber phoneNumber, @JsonProperty(value="lata") String lata, @JsonProperty(value="rate_center") String rateCenter, @JsonProperty(value="latitude") BigDecimal latitude, @JsonProperty(value="longitude") BigDecimal longitude, @JsonProperty(value="region") String region, @JsonProperty(value="postal_code") String postalCode, @JsonProperty(value="iso_country") String isoCountry, @JsonProperty(value="address_requirements") String addressRequirements, @JsonProperty(value="beta") Boolean beta, @JsonProperty(value="capabilities") PhoneNumberCapabilities capabilities) {
        this.friendlyName = friendlyName;
        this.phoneNumber = phoneNumber;
        this.lata = lata;
        this.rateCenter = rateCenter;
        this.latitude = latitude;
        this.longitude = longitude;
        this.region = region;
        this.postalCode = postalCode;
        this.isoCountry = isoCountry;
        this.addressRequirements = addressRequirements;
        this.beta = beta;
        this.capabilities = capabilities;
    }

    public final PhoneNumber getFriendlyName() {
        return this.friendlyName;
    }

    public final PhoneNumber getPhoneNumber() {
        return this.phoneNumber;
    }

    public final String getLata() {
        return this.lata;
    }

    public final String getRateCenter() {
        return this.rateCenter;
    }

    public final BigDecimal getLatitude() {
        return this.latitude;
    }

    public final BigDecimal getLongitude() {
        return this.longitude;
    }

    public final String getRegion() {
        return this.region;
    }

    public final String getPostalCode() {
        return this.postalCode;
    }

    public final String getIsoCountry() {
        return this.isoCountry;
    }

    public final String getAddressRequirements() {
        return this.addressRequirements;
    }

    public final Boolean getBeta() {
        return this.beta;
    }

    public final PhoneNumberCapabilities getCapabilities() {
        return this.capabilities;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Local other = (Local)o;
        return Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.phoneNumber, other.phoneNumber) && Objects.equals(this.lata, other.lata) && Objects.equals(this.rateCenter, other.rateCenter) && Objects.equals(this.latitude, other.latitude) && Objects.equals(this.longitude, other.longitude) && Objects.equals(this.region, other.region) && Objects.equals(this.postalCode, other.postalCode) && Objects.equals(this.isoCountry, other.isoCountry) && Objects.equals(this.addressRequirements, other.addressRequirements) && Objects.equals(this.beta, other.beta) && Objects.equals(this.capabilities, other.capabilities);
    }

    public int hashCode() {
        return Objects.hash(this.friendlyName, this.phoneNumber, this.lata, this.rateCenter, this.latitude, this.longitude, this.region, this.postalCode, this.isoCountry, this.addressRequirements, this.beta, this.capabilities);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("friendlyName", this.friendlyName).add("phoneNumber", this.phoneNumber).add("lata", this.lata).add("rateCenter", this.rateCenter).add("latitude", this.latitude).add("longitude", this.longitude).add("region", this.region).add("postalCode", this.postalCode).add("isoCountry", this.isoCountry).add("addressRequirements", this.addressRequirements).add("beta", this.beta).add("capabilities", this.capabilities).toString();
    }
}

