/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.api.v2010.account.ValidationRequestCreator;
import com.twilio.type.PhoneNumber;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ValidationRequest
extends Resource {
    private static final long serialVersionUID = 227253393242231L;
    private final String accountSid;
    private final PhoneNumber phoneNumber;
    private final String friendlyName;
    private final Integer validationCode;
    private final String callSid;

    public static ValidationRequestCreator creator(String accountSid, PhoneNumber phoneNumber) {
        return new ValidationRequestCreator(accountSid, phoneNumber);
    }

    public static ValidationRequestCreator creator(PhoneNumber phoneNumber) {
        return new ValidationRequestCreator(phoneNumber);
    }

    public static ValidationRequest fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, ValidationRequest.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static ValidationRequest fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, ValidationRequest.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private ValidationRequest(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="phone_number") PhoneNumber phoneNumber, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="validation_code") Integer validationCode, @JsonProperty(value="call_sid") String callSid) {
        this.accountSid = accountSid;
        this.phoneNumber = phoneNumber;
        this.friendlyName = friendlyName;
        this.validationCode = validationCode;
        this.callSid = callSid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final PhoneNumber getPhoneNumber() {
        return this.phoneNumber;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final Integer getValidationCode() {
        return this.validationCode;
    }

    public final String getCallSid() {
        return this.callSid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValidationRequest other = (ValidationRequest)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.phoneNumber, other.phoneNumber) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.validationCode, other.validationCode) && Objects.equals(this.callSid, other.callSid);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.phoneNumber, this.friendlyName, this.validationCode, this.callSid);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("accountSid", this.accountSid).add("phoneNumber", this.phoneNumber).add("friendlyName", this.friendlyName).add("validationCode", this.validationCode).add("callSid", this.callSid).toString();
    }
}

