/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.api.v2010.account.IncomingPhoneNumber;

public class IncomingPhoneNumberFetcher
extends Fetcher<IncomingPhoneNumber> {
    private String ownerAccountSid;
    private final String sid;

    public IncomingPhoneNumberFetcher(String sid) {
        this.sid = sid;
    }

    public IncomingPhoneNumberFetcher(String ownerAccountSid, String sid) {
        this.ownerAccountSid = ownerAccountSid;
        this.sid = sid;
    }

    @Override
    public IncomingPhoneNumber fetch(TwilioRestClient client) {
        this.ownerAccountSid = this.ownerAccountSid == null ? client.getAccountSid() : this.ownerAccountSid;
        Request request = new Request(HttpMethod.GET, Domains.API.toString(), "/2010-04-01/Accounts/" + this.ownerAccountSid + "/IncomingPhoneNumbers/" + this.sid + ".json", client.getRegion());
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("IncomingPhoneNumber fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return IncomingPhoneNumber.fromJson(response.getStream(), client.getObjectMapper());
    }
}

