/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account;

import com.twilio.base.Updater;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.api.v2010.account.Call;
import java.net.URI;

public class CallUpdater
extends Updater<Call> {
    private String accountSid;
    private final String sid;
    private URI url;
    private HttpMethod method;
    private Call.UpdateStatus status;
    private URI fallbackUrl;
    private HttpMethod fallbackMethod;
    private URI statusCallback;
    private HttpMethod statusCallbackMethod;

    public CallUpdater(String sid) {
        this.sid = sid;
    }

    public CallUpdater(String accountSid, String sid) {
        this.accountSid = accountSid;
        this.sid = sid;
    }

    public CallUpdater setUrl(URI url) {
        this.url = url;
        return this;
    }

    public CallUpdater setUrl(String url) {
        return this.setUrl(Promoter.uriFromString(url));
    }

    public CallUpdater setMethod(HttpMethod method) {
        this.method = method;
        return this;
    }

    public CallUpdater setStatus(Call.UpdateStatus status) {
        this.status = status;
        return this;
    }

    public CallUpdater setFallbackUrl(URI fallbackUrl) {
        this.fallbackUrl = fallbackUrl;
        return this;
    }

    public CallUpdater setFallbackUrl(String fallbackUrl) {
        return this.setFallbackUrl(Promoter.uriFromString(fallbackUrl));
    }

    public CallUpdater setFallbackMethod(HttpMethod fallbackMethod) {
        this.fallbackMethod = fallbackMethod;
        return this;
    }

    public CallUpdater setStatusCallback(URI statusCallback) {
        this.statusCallback = statusCallback;
        return this;
    }

    public CallUpdater setStatusCallback(String statusCallback) {
        return this.setStatusCallback(Promoter.uriFromString(statusCallback));
    }

    public CallUpdater setStatusCallbackMethod(HttpMethod statusCallbackMethod) {
        this.statusCallbackMethod = statusCallbackMethod;
        return this;
    }

    @Override
    public Call update(TwilioRestClient client) {
        this.accountSid = this.accountSid == null ? client.getAccountSid() : this.accountSid;
        Request request = new Request(HttpMethod.POST, Domains.API.toString(), "/2010-04-01/Accounts/" + this.accountSid + "/Calls/" + this.sid + ".json", client.getRegion());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Call update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Call.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.url != null) {
            request.addPostParam("Url", this.url.toString());
        }
        if (this.method != null) {
            request.addPostParam("Method", this.method.toString());
        }
        if (this.status != null) {
            request.addPostParam("Status", this.status.toString());
        }
        if (this.fallbackUrl != null) {
            request.addPostParam("FallbackUrl", this.fallbackUrl.toString());
        }
        if (this.fallbackMethod != null) {
            request.addPostParam("FallbackMethod", this.fallbackMethod.toString());
        }
        if (this.statusCallback != null) {
            request.addPostParam("StatusCallback", this.statusCallback.toString());
        }
        if (this.statusCallbackMethod != null) {
            request.addPostParam("StatusCallbackMethod", this.statusCallbackMethod.toString());
        }
    }
}

