/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account;

import com.google.common.collect.Range;
import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.api.v2010.account.Call;
import com.twilio.type.PhoneNumber;
import org.joda.time.DateTime;

public class CallReader
extends Reader<Call> {
    private String accountSid;
    private PhoneNumber to;
    private PhoneNumber from;
    private String parentCallSid;
    private Call.Status status;
    private DateTime absoluteStartTime;
    private Range<DateTime> rangeStartTime;
    private DateTime absoluteEndTime;
    private Range<DateTime> rangeEndTime;

    public CallReader() {
    }

    public CallReader(String accountSid) {
        this.accountSid = accountSid;
    }

    public CallReader setTo(PhoneNumber to) {
        this.to = to;
        return this;
    }

    public CallReader setFrom(PhoneNumber from) {
        this.from = from;
        return this;
    }

    public CallReader setParentCallSid(String parentCallSid) {
        this.parentCallSid = parentCallSid;
        return this;
    }

    public CallReader setStatus(Call.Status status) {
        this.status = status;
        return this;
    }

    public CallReader setStartTime(DateTime absoluteStartTime) {
        this.rangeStartTime = null;
        this.absoluteStartTime = absoluteStartTime;
        return this;
    }

    public CallReader setStartTime(Range<DateTime> rangeStartTime) {
        this.absoluteStartTime = null;
        this.rangeStartTime = rangeStartTime;
        return this;
    }

    public CallReader setEndTime(DateTime absoluteEndTime) {
        this.rangeEndTime = null;
        this.absoluteEndTime = absoluteEndTime;
        return this;
    }

    public CallReader setEndTime(Range<DateTime> rangeEndTime) {
        this.absoluteEndTime = null;
        this.rangeEndTime = rangeEndTime;
        return this;
    }

    @Override
    public ResourceSet<Call> read(TwilioRestClient client) {
        return new ResourceSet<Call>(this, client, this.firstPage(client));
    }

    @Override
    public Page<Call> firstPage(TwilioRestClient client) {
        this.accountSid = this.accountSid == null ? client.getAccountSid() : this.accountSid;
        Request request = new Request(HttpMethod.GET, Domains.API.toString(), "/2010-04-01/Accounts/" + this.accountSid + "/Calls.json", client.getRegion());
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Call> nextPage(Page<Call> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.API.toString(), client.getRegion()));
        return this.pageForRequest(client, request);
    }

    private Page<Call> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Call read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Page.fromJson("calls", response.getContent(), Call.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.to != null) {
            request.addQueryParam("To", this.to.toString());
        }
        if (this.from != null) {
            request.addQueryParam("From", this.from.toString());
        }
        if (this.parentCallSid != null) {
            request.addQueryParam("ParentCallSid", this.parentCallSid);
        }
        if (this.status != null) {
            request.addQueryParam("Status", this.status.toString());
        }
        if (this.absoluteStartTime != null) {
            request.addQueryParam("StartTime", this.absoluteStartTime.toString("yyyy-MM-dd'T'HH:mm:ss"));
        } else if (this.rangeStartTime != null) {
            request.addQueryDateTimeRange("StartTime", this.rangeStartTime);
        }
        if (this.absoluteEndTime != null) {
            request.addQueryParam("EndTime", this.absoluteEndTime.toString("yyyy-MM-dd'T'HH:mm:ss"));
        } else if (this.rangeEndTime != null) {
            request.addQueryDateTimeRange("EndTime", this.rangeEndTime);
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

