/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.jwt.taskrouter;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.twilio.http.HttpMethod;
import com.twilio.jwt.taskrouter.FilterRequirement;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Map;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public class Policy {
    @JsonProperty(value="url")
    private final String url;
    @JsonProperty(value="method")
    private final HttpMethod method;
    @JsonProperty(value="query_filter")
    @JsonSerialize(using=FilterRequirementSerializer.class)
    private final Map<String, FilterRequirement> queryFilter;
    @JsonProperty(value="post_filter")
    @JsonSerialize(using=FilterRequirementSerializer.class)
    private final Map<String, FilterRequirement> postFilter;
    @JsonProperty(value="allow")
    private final boolean allowed;

    private Policy(Builder b) {
        this.url = b.url;
        this.method = b.method;
        this.queryFilter = b.queryFilter;
        this.postFilter = b.postFilter;
        this.allowed = b.allowed;
    }

    public String getUrl() {
        return this.url;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public Map<String, FilterRequirement> getQueryFilter() {
        return this.queryFilter;
    }

    public Map<String, FilterRequirement> getPostFilter() {
        return this.postFilter;
    }

    public boolean isAllowed() {
        return this.allowed;
    }

    public String toJson() throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        mapper.writeValue(out, (Object)this);
        return out.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Policy policy = (Policy)o;
        return this.allowed == policy.allowed && this.method == policy.method && Objects.equal(this.url, policy.url) && Objects.equal(this.queryFilter, policy.queryFilter) && Objects.equal(this.postFilter, policy.postFilter);
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.url, this.method, this.queryFilter, this.postFilter, this.allowed});
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("url", this.url).add("method", (Object)this.method).add("queryFilter", this.queryFilter).add("postFilter", this.postFilter).add("allowed", this.allowed).toString();
    }

    private static class FilterRequirementSerializer
    extends JsonSerializer<Map<String, FilterRequirement>> {
        private FilterRequirementSerializer() {
        }

        @Override
        public void serialize(Map<String, FilterRequirement> stringFilterRequirementMap, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
            for (Map.Entry<String, FilterRequirement> entry : stringFilterRequirementMap.entrySet()) {
                jsonGenerator.writeObjectFieldStart(entry.getKey());
                jsonGenerator.writeBooleanField("required", entry.getValue().value());
                jsonGenerator.writeEndObject();
            }
        }
    }

    public static class Builder {
        private String url;
        private HttpMethod method = HttpMethod.GET;
        private Map<String, FilterRequirement> queryFilter;
        private Map<String, FilterRequirement> postFilter;
        private boolean allowed = true;

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder method(HttpMethod method) {
            this.method = method;
            return this;
        }

        public Builder queryFilter(Map<String, FilterRequirement> queryFilter) {
            this.queryFilter = queryFilter;
            return this;
        }

        public Builder postFilter(Map<String, FilterRequirement> postFilter) {
            this.postFilter = postFilter;
            return this;
        }

        public Builder allowed(boolean allowed) {
            this.allowed = allowed;
            return this;
        }

        public Policy build() {
            return new Policy(this);
        }
    }
}

