---
title: Code Ownership
slug: 01-code-ownership
date: '2019-11-21'
minute2read: 10
description: Code ownership bisa mempengaruhi banyak hal dalam keseharian seorang programmer terutama kode yang dihasilkann serta sikap terhadap kode tersebut
categories: [ghibahprogramnmer]
cover: https://images.pexels.com/photos/1288482/pexels-photo-1288482.jpeg?auto=compress&cs=tinysrgb&dpr=2&h=150
---

Artikel ini merupakan seri dari Ghibah Programmer, pada seri ini kita akan membahas hal yang sebagian besar bukan hal teknikal melainkan berbagai hal-hal aneh bin ajaib yang sehari-hari dikerjakan atau dilakukan seorang programmer.

Code ownership dalam kaitannya sikap seorang programmer bisa diartikan sebagai rasa memiliki terhadap sebuah kode. Code ownership bisa diartikan sebagai hal negatif bisa pula diartikan ke hal yang positif, tergantung dari sudut mana kita mengambil kesimpulannya. Code ownership bisa mempengaruhi banyak hal dalam keseharian seorang programmer terutama kode yang dihasilkan serta sikap terhadap kode tersebut.

<img v-lazyload src="/images/placeholder-1x1.png" data-src="https://images.pexels.com/photos/1288482/pexels-photo-1288482.jpeg?auto=compress&cs=tinysrgb&dpr=2&h=150" alt="Code Ownership Ilustrasi">

<small class="caption">Gambar diambil dari laman <a href="https://images.pexels.com/photos/1288482/pexels-photo-1288482.jpeg" target="_blank" rel="noopener">https://pexels.com</a><small>

Ibarat rumah, saya pribadi sih akan rajin membersihkan dan membenahi apalagi bila sadar kalau rumah tersebut adalah rumah milik pribadi. Lain cerita kalau rumah itu bukan milik pribadi, mungkin kalau ada yang rusak-rusak dikit, gompel-gompel dikit ya biarkan sajalah, toh bukan milik kita juga. Rasanya kok enggan ya untuk membenahi barang yang bukan milik kita atau paling tidak kita merasa ikut memiliki barang tersebut.
Pun begitu dengan kode, ketika kita tidak punya rasa memiliki terhadap kode yang ditulis bersama-sama maka kita tidak akan mengeluarkan ekstra tenaga untuk membersihkan berbagai kekacauan dan memelihara berbagai hal untuk kedepannya.

Terus kenapa artikel ini kok bahas code ownership? Tentu saja idenya berangkat dari kegalauan saya pribadi sebagai penulis yang melihat disekitar saya masih banyak programmer yang tidak memiliki code ownershipyang baik terhadap kode yang ditulisnya. Hmmm, gimana sih ceritanya? Yuk kita ghibahin mereka aja.

Jadi di beberapa projek di kantor saya masih menggunakan satu repositoryuntuk aplikasi yang lumayan besar. Ini yang menjadikan banyaknya orang yang bisa melakukan perubahan, penghapusan dan penambahan kode secara sporadis dan seringkali gagal terkontrol dengan baik. Gagalnya mengontrol perubahan kode salah satunya memang disebabkan banyaknya programmer yang melakukan hit and run pada perubahan kode mereka.

Kenapa ada programmer yang melakukan hit and run? Dari pendapat saya pribadi (tentu ini bagian dari ghibah ya, bisa benar bisa juga salah. gak usah baper) karena masih ada programmer tidak memiliki code ownership yang baik, yang merasa tidak akan ikut memelihara kode tersebut kedepannya. Masih ada programmer yang kalo saya bilang itu seperti “tentara bayaran“, asal fitur mereka selesai maka semua urusan selesai. Padahal ketika bekerja di dalam sebuah tim, semua anggota tim harusnya ikut andil dalam memelihara kode tersebut.

Kabar baiknya, sebagian besar yang belum memiliki code ownershipyang baik memang adalah mereka yang masih di level junior (tentu tidak semuanya — jangan di generalisir), hal ini menjadi beralasan karena mereka mungkin belum mengalami bagaimana susahnya memelihara kode yang sudah terlanjur tercemar dibandingkan menulis kode dengan rasa tanggung jawab yang tinggi sedari awal.

Kabar buruknya, lebih mudah untuk mengajarkan hal-hal teknis dibandingkan non teknis kepada seorang programmer. Pun soal code ownershipini, susah sekali memberitahukan dan menanamkan sikap ini kepada programmer.
Artikel soal code ownership bisa dibaca di [https://martinfowler.com/bliki/CodeOwnership.html ↗️](https://martinfowler.com/bliki/CodeOwnership.html).

----

Terima kasih dan tunggu seri berikutnya. Ikuti juga <a href="https://www.instagram.com/ghibahprogrammer/" target="_blank" rel="noopener">@ghibahprogrammer</a> di Instagram.