#pragma once

#include <iterator>

// This solution comes from
// https://stackoverflow.com/a/28139075

namespace parac {
template<typename T>
struct reversion_wrapper {
  T& iterable;
};

template<typename T>
auto
begin(reversion_wrapper<T> w) {
  return std::rbegin(w.iterable);
}

template<typename T>
auto
end(reversion_wrapper<T> w) {
  return std::rend(w.iterable);
}

template<typename T>
reversion_wrapper<T>
reverse(T&& iterable) {
  return { iterable };
}
}
