<?php

return [
	// Examples from README.md
	[
		'title' => 'basic test without emojis',
		'input' => 'test',
		'containsEmoji' => false,
		'onlyEmoji ignoreWhitespace=true' => false,
		'onlyEmoji ignoreWhitespace=false' => false,
		'removeEmoji' => 'test',
		'allEmojis' => [],
		'startingEmojis ignoreWhitespace=true' => [],
		'startingEmojis ignoreWhitespace=false' => [],
	],
	[
		'title' => 'basic test with emojis',
		'input' => 'test 👍',
		'containsEmoji' => true,
		'onlyEmoji ignoreWhitespace=true' => false,
		'onlyEmoji ignoreWhitespace=false' => false,
		'removeEmoji' => 'test ',
		'allEmojis' => ['👍'],
		'startingEmojis ignoreWhitespace=true' => [],
		'startingEmojis ignoreWhitespace=false' => [],
	],
	[
		'title' => 'only emojis',
		'input' => '👍😘',
		'containsEmoji' => true,
		'onlyEmoji ignoreWhitespace=true' => true,
		'onlyEmoji ignoreWhitespace=false' => true,
		'removeEmoji' => '',
		'allEmojis' => ['👍', '😘'],
		'startingEmojis ignoreWhitespace=true' => ['👍', '😘'],
		'startingEmojis ignoreWhitespace=false' => ['👍', '😘'],
	],
	[
		'title' => 'only emojis and whitespaces',
		'input' => '👍 😘',
		'containsEmoji' => true,
		'onlyEmoji ignoreWhitespace=true' => true,
		'onlyEmoji ignoreWhitespace=false' => false,
		'removeEmoji' => ' ',
		'allEmojis' => ['👍', '😘'],
		'startingEmojis ignoreWhitespace=true' => ['👍', '😘'],
		'startingEmojis ignoreWhitespace=false' => ['👍'],
	],
	[
		'title' => 'starting emojis without spaces',
		'input' => '👍😘 test',
		'containsEmoji' => true,
		'onlyEmoji ignoreWhitespace=true' => false,
		'onlyEmoji ignoreWhitespace=false' => false,
		'removeEmoji' => ' test',
		'allEmojis' => ['👍', '😘'],
		'startingEmojis ignoreWhitespace=true' => ['👍', '😘'],
		'startingEmojis ignoreWhitespace=false' => ['👍', '😘'],
	],
	[
		'title' => 'starting emojis with spaces',
		'input' => '👍 😘 test',
		'containsEmoji' => true,
		'onlyEmoji ignoreWhitespace=true' => false,
		'onlyEmoji ignoreWhitespace=false' => false,
		'removeEmoji' => '  test',
		'allEmojis' => ['👍', '😘'],
		'startingEmojis ignoreWhitespace=true' => ['👍', '😘'],
		'startingEmojis ignoreWhitespace=false' => ['👍'],
	],
	// Other tests
	[
		'title' => 'other Unicode characters',
		'input' => 'тест1 👍 👍 тест2',
		'containsEmoji' => true,
		'onlyEmoji ignoreWhitespace=true' => false,
		'onlyEmoji ignoreWhitespace=false' => false,
		'removeEmoji' => 'тест1   тест2',
		'allEmojis' => ['👍', '👍'],
		'startingEmojis ignoreWhitespace=true' => [],
		'startingEmojis ignoreWhitespace=false' => [],
	],
	[
		'title' => 'starting emojis with spaces and with other Unicode characters',
		'input' => '👍 👍 👍 тест',
		'containsEmoji' => true,
		'onlyEmoji ignoreWhitespace=true' => false,
		'onlyEmoji ignoreWhitespace=false' => false,
		'removeEmoji' => '   тест',
		'allEmojis' => ['👍', '👍', '👍'],
		'startingEmojis ignoreWhitespace=true' => ['👍', '👍', '👍'],
		'startingEmojis ignoreWhitespace=false' => ['👍'],
	],
	[
		'title' => 'starting emojis without spaces and with other Unicode characters',
		'input' => '👍👍👍тест',
		'containsEmoji' => true,
		'onlyEmoji ignoreWhitespace=true' => false,
		'onlyEmoji ignoreWhitespace=false' => false,
		'removeEmoji' => 'тест',
		'allEmojis' => ['👍', '👍', '👍'],
		'startingEmojis ignoreWhitespace=true' => ['👍', '👍', '👍'],
		'startingEmojis ignoreWhitespace=false' => ['👍', '👍', '👍'],
	],
	[
		'title' => 'only emojis with spaces',
		'input' => '😘 😎 🤩',
		'containsEmoji' => true,
		'onlyEmoji ignoreWhitespace=true' => true,
		'onlyEmoji ignoreWhitespace=false' => false,
		'removeEmoji' => '  ',
		'allEmojis' => ['😘', '😎', '🤩'],
		'startingEmojis ignoreWhitespace=true' => ['😘', '😎', '🤩'],
		'startingEmojis ignoreWhitespace=false' => ['😘'],
	],
	[
		'title' => 'only emojis without spaces',
		'input' => '😘😎🤩',
		'containsEmoji' => true,
		'onlyEmoji ignoreWhitespace=true' => true,
		'onlyEmoji ignoreWhitespace=false' => true,
		'removeEmoji' => '',
		'allEmojis' => ['😘', '😎', '🤩'],
		'startingEmojis ignoreWhitespace=true' => ['😘', '😎', '🤩'],
		'startingEmojis ignoreWhitespace=false' => ['😘', '😎', '🤩'],
	],
	[
		'title' => 'only emojis with one space',
		'input' => '😘😎 🤩',
		'containsEmoji' => true,
		'onlyEmoji ignoreWhitespace=true' => true,
		'onlyEmoji ignoreWhitespace=false' => false,
		'removeEmoji' => ' ',
		'allEmojis' => ['😘', '😎', '🤩'],
		'startingEmojis ignoreWhitespace=true' => ['😘', '😎', '🤩'],
		'startingEmojis ignoreWhitespace=false' => ['😘', '😎'],
	],
	[
		'title' => 'no emojis',
		'input' => 'тест test',
		'containsEmoji' => false,
		'onlyEmoji ignoreWhitespace=true' => false,
		'onlyEmoji ignoreWhitespace=false' => false,
		'removeEmoji' => 'тест test',
		'allEmojis' => [],
		'startingEmojis ignoreWhitespace=true' => [],
		'startingEmojis ignoreWhitespace=false' => [],
	],
	[
		'title' => 'one fully-qualified emoji',
		'input' => '❤️',
		'containsEmoji' => true,
		'onlyEmoji ignoreWhitespace=true' => true,
		'onlyEmoji ignoreWhitespace=false' => true,
		'removeEmoji' => '',
		'allEmojis' => ['❤️'],
		'startingEmojis ignoreWhitespace=true' => ['❤️'],
		'startingEmojis ignoreWhitespace=false' => ['❤️'],
	],
	[
		'title' => 'one unqualified emoji',
		'input' => '❤',
		'containsEmoji' => true,
		'onlyEmoji ignoreWhitespace=true' => true,
		'onlyEmoji ignoreWhitespace=false' => true,
		'removeEmoji' => '',
		'allEmojis' => ['❤'],
		'startingEmojis ignoreWhitespace=true' => ['❤'],
		'startingEmojis ignoreWhitespace=false' => ['❤'],
	],
	[
		'title' => 'unqualified (❤) and fully-qualified (❤️) emojis with spaces',
		'input' => '❤ ❤️ ❤️',
		'containsEmoji' => true,
		'onlyEmoji ignoreWhitespace=true' => true,
		'onlyEmoji ignoreWhitespace=false' => false,
		'removeEmoji' => '  ',
		'allEmojis' => ['❤', '❤️', '❤️'],
		'startingEmojis ignoreWhitespace=true' => ['❤', '❤️', '❤️'],
		'startingEmojis ignoreWhitespace=false' => ['❤'],
	],
	[
		'title' => 'unqualified (❤) and fully-qualified (❤️) emojis without spaces',
		'input' => '❤❤️❤',
		'containsEmoji' => true,
		'onlyEmoji ignoreWhitespace=true' => true,
		'onlyEmoji ignoreWhitespace=false' => true,
		'removeEmoji' => '',
		'allEmojis' => ['❤', '❤️', '❤'],
		'startingEmojis ignoreWhitespace=true' => ['❤', '❤️', '❤'],
		'startingEmojis ignoreWhitespace=false' => ['❤', '❤️', '❤'],
	],
];
