from setuptools import setup

setup(
    name="NetbiosSpoof",
    version="1.1.2",
    py_modules=["NetbiosSpoof"],
    install_requires=["scapy"],
    author="Maurice Lambert",
    author_email="mauricelambert434@gmail.com",
    maintainer="Maurice Lambert",
    maintainer_email="mauricelambert434@gmail.com",
    description="This package implements a Hostname Spoofer (Netbios, LLMNR and Local DNS).",
    long_description=open("README.md").read(),
    long_description_content_type="text/markdown",
    url="https://github.com/mauricelambert/NetbiosSpoof",
    project_urls={
        "Documentation": "https://mauricelambert.github.io/info/python/security/NetbiosSpoof.html",
        "Executable": "https://mauricelambert.github.io/info/python/security/NetbiosSpoof.pyz",
    },
    classifiers=[
        "Programming Language :: Python",
        "Development Status :: 5 - Production/Stable",
        "Topic :: System :: Networking",
        "Topic :: Security",
        "Natural Language :: English",
        "Programming Language :: Python :: 3.9",
        "Operating System :: POSIX :: Linux",
        "Operating System :: Microsoft :: Windows",
        "Operating System :: MacOS",
    ],
    python_requires=">=3.6",
    entry_points={
        "console_scripts": ["NetbiosSpoof = NetbiosSpoof:main"],
    },
    keywords=[
        "netbios",
        "spoofer",
        "hostname",
        "network",
        "security",
        "NBNS",
        "LLMNR",
        "MDNS",
        "Local DNS",
    ],
    platforms=["Windows", "Linux", "MacOS"],
    license="GPL-3.0 License",
)
