# Contribution Guidelines

In order to contribute to this repository you need to **fork** it, then you can create a pull request.

The README is generated from **contents.json**, please update the JSON file instead of the README :smile:

- **To add to the list:** Submit a pull request
- **To remove from the list:** Open an issue

To be added to the list, software should meet the following criteria:

- ✅ Actively maintained
- ✅ Performs a useful function
- ✅ Used by the community
- ✅ Well documented
- ✅ Work with the latest SDK
- ✅ README is written in English
- ✅ Have at least 15 🌟 stars on (GitHub project)
- ✅ Support at least `Swift 5` or above
- ✅ It is released under one of those license: `Apache License 2.0, BSD 3, BSD 2, GPL, LGPL, MIT`


If an item on the list no longer meets the above criteria, open an issue to have it be removed.

When adding new items, please adhere to the following guidelines:

- Search previous suggestions before making a new one, as yours may be a duplicate.
- Make an individual pull request for each suggestion.
- Use the existing format in the JSON file

```js
{
		"title": "Commander",
		"category": "command-line",
		"description": "Compose beautiful command line interfaces.",
		"homepage": "https://github.com/kylef/Commander",
		"tags": ["linux"]
}
```

- New categories, or improvements to the existing categorization are welcome (open an issue).
- Keep descriptions short and simple, but descriptive.
- Start the description with a capital and end with a full stop/period.
- The description usually should not include "written in Swift" or "in Swift" as everything on the list would have that.
- Check your spelling and grammar.
- The pull request should include a link to the package and why it should be included.

Thank you for your suggestions!
