#pragma once

#include <boost/lexical_cast.hpp>
#include <string_view>

//#include <stdlib.h>
#include <fcntl.h>

#if defined(_MSC_VER)
#include <io.h>
#endif

//#include <sys/stat.h>
#include <li/http_server/http_ctx.hh>

namespace li {
using namespace li;

struct http_response {
  inline http_response(http_async_impl::http_ctx& ctx) : http_ctx(ctx) {}

  inline void set_header(std::string_view k, std::string_view v) { http_ctx.set_header(k, v); }
  inline void set_cookie(std::string_view k, std::string_view v) { http_ctx.set_cookie(k, v); }

  template <typename O>
  inline void write_json(O&& obj) {     
    http_ctx.set_header("Content-Type", "application/json");
    http_ctx.respond_json(std::forward<O>(obj));
  }

  template <typename A, typename B, typename... O>
  void write_json(assign_exp<A, B>&& w1, O&&... ws) {
    write_json(mmm(std::forward<assign_exp<A, B>>(w1), std::forward<O>(ws)...));
  }

  template <typename F>
  inline void write_json_generator(int N, F generator) {     
    http_ctx.set_header("Content-Type", "application/json");
    http_ctx.respond_json_generator(N, std::forward<F>(generator));
  }

  inline void write() { http_ctx.respond(body); }
   void set_status(int s) { http_ctx.set_status(s); }

  template <typename A1, typename... A> inline void write(A1&& a1, A&&... a) {
    body += boost::lexical_cast<std::string>(std::forward<A1>(a1));
    write(std::forward<A>(a)...);
  }
  template <typename A1, typename... A> inline void write(const char* a1, A&&... a) {
    body.append(a1);
    write(std::forward<A>(a)...);
  }
  
  template <typename A1, typename... A> inline void write(std::string_view a1) 
  {
    http_ctx.respond(a1); 
  }

  inline void write_file(const std::string path) {
    http_ctx.send_file(path.c_str());
  }
  // Disabled because of missing cache implementation.
  // inline void write_static_file(const std::string path) {
  //   http_ctx.send_static_file(path.c_str(), 0);
  // }

  http_async_impl::http_ctx& http_ctx;
  std::string body;
};

} // namespace li
