# Modern Fonts Stacks for WordPress Font Library

[An user review](https://wordpress.org/support/topic/maybe-the-last-font-stacks-youll-ever-need-a-must-have-for-fse-users/): 

The “Modern Font Stacks” are 15 handpicked font families that ensure a similar look and feel of your text across platforms, be it Windows, macOS, Linux or mobile devices, in the fastest and most robust way possible — by using the best system fonts available.

No external downloads are necessary. No “flash of unstyled text”. There are no privacy issues.

Search for “Modern Font Stacks” on your favorite search engine for the full story; you won’t regret it.

You can add these font stacks to your theme via theme.json, which is not overly technical, just a bit cumbersome — or — you can use the “Modern Fonts for Font Library” plugin, which does just that for you. Afterward, the new font stacks will be available in the typography settings of your full site editing theme and, as a result, in the block editor for your content.

Worried about long-time support? Don’t be. The system fonts aren’t going anywhere, and you can at any time replace the “Modern Font for Font Library” plugin with a few lines of custom CSS or the mentioned addition to theme.json.

I’ve built numerous sites using Modern Font Stacks. Having a good selection of beautiful and efficient fonts for body text, script, monospaced text, etc. means that I can often avoid external fonts entirely, or just use a single external font for branding or headings. This results in a super-fast user experience.


**This is a plugin that adds a font collection to provide users with the ability to install a modern system fonts stacks.**
It can be used new WordPress Font Library with `WordPress >= 6.5`.

![Screenshot Modern Fonts Stacks for WordPress Font Library](https://github.com/matiasbenedetto/modern-fonts-stacks-for-font-library/assets/1310626/a1af8f98-fcc4-4916-bdee-fa7990da1867)


## Why?
As an example to showcase the extensibility of the WordPress Font Library.

## How to use:
📁 [Download the plugin](https://wordpress.org/plugins/modern-fonts-stacks-for-font-library/) and install it in your WordPress.

---

### Props:
Props to [@danklammer](https://github.com/danklammer) for the [Modern Fonts Stacks](https://modernfontstacks.com/) project.

Props to [@Ren2049](https://github.com/Ren2049) and [@LittleBigThing](https://github.com/LittleBigThing) for [proposing the addition](https://github.com/WordPress/gutenberg/issues/54186) to the font library by default.
