/*
 * Decompiled with CFR 0.152.
 */
package com.tucows.oxrs.epprtk.rtk.xml;

import com.tucows.oxrs.epprtk.rtk.xml.EPPRegistrarBase;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.xerces.dom.DocumentImpl;
import org.openrtk.idl.epprtk.domain.epp_DomainContact;
import org.openrtk.idl.epprtk.domain.epp_DomainContactType;
import org.openrtk.idl.epprtk.epp_Command;
import org.openrtk.idl.epprtk.epp_Exception;
import org.openrtk.idl.epprtk.epp_XMLException;
import org.openrtk.idl.epprtk.registrar.epp_RegistrarInfo;
import org.openrtk.idl.epprtk.registrar.epp_RegistrarInfoReq;
import org.openrtk.idl.epprtk.registrar.epp_RegistrarInfoRsp;
import org.openrtk.idl.epprtk.registrar.epp_RegistrarPortfolio;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class EPPRegistrarInfo
extends EPPRegistrarBase
implements epp_RegistrarInfo {
    private epp_RegistrarInfoReq action_request_;
    private epp_RegistrarInfoRsp action_response_;

    public EPPRegistrarInfo() {
    }

    public EPPRegistrarInfo(String xml) throws epp_XMLException, epp_Exception {
        String method_name = "EPPRegistrarInfo(String)";
        this.debug(2, method_name, "xml is [" + xml + "]");
        this.fromXML(xml);
    }

    @Override
    public void setRequestData(epp_RegistrarInfoReq value) {
        this.action_request_ = value;
    }

    @Override
    public epp_RegistrarInfoRsp getResponseData() {
        return this.action_response_;
    }

    @Override
    public String toXML() throws epp_XMLException {
        String request_xml;
        String method_name = "buildRequestXML()";
        this.debug(3, method_name, "Entered");
        if (this.action_request_ == null || this.action_request_.m_cmd == null || this.action_request_.m_id == null) {
            throw new epp_XMLException("missing request data or registrar id");
        }
        DocumentImpl doc = new DocumentImpl();
        Element root = this.createDocRoot((Document)doc);
        Element command = doc.createElement("command");
        Element info = doc.createElement("info");
        epp_Command command_data = this.action_request_.m_cmd;
        Element registrar_info = doc.createElement("registrar:info");
        this.setCommonAttributes(registrar_info);
        this.addXMLElement((Document)doc, registrar_info, "registrar:id", this.action_request_.m_id);
        info.appendChild(registrar_info);
        command.appendChild(info);
        this.prepareExtensionElement((Document)doc, command, command_data.m_extensions);
        if (command_data.m_client_trid != null) {
            this.addXMLElement((Document)doc, command, "clTRID", command_data.m_client_trid);
        }
        root.appendChild(command);
        doc.appendChild(root);
        try {
            request_xml = this.createXMLFromDoc((Document)doc);
        }
        catch (IOException xcp) {
            throw new epp_XMLException("IOException in building XML [" + xcp.getMessage() + "]");
        }
        this.debug(3, method_name, "Leaving");
        return request_xml;
    }

    @Override
    public void fromXML(String xml) throws epp_XMLException, epp_Exception {
        String method_name = "fromXML()";
        this.debug(3, method_name, "Entered");
        this.xml_ = xml;
        try {
            Element epp_node = this.getDocumentElement();
            Node response_node = epp_node.getElementsByTagName("response").item(0);
            if (response_node == null) {
                throw new epp_XMLException("unparsable or missing response");
            }
            this.action_response_ = new epp_RegistrarInfoRsp();
            this.action_response_.m_rsp = this.parseGenericResult(response_node);
            if (this.action_response_.m_rsp.m_results[0].m_code >= 2000) {
                throw new epp_Exception(this.action_response_.m_rsp.m_results);
            }
            Element response_data_element = this.getElement(response_node.getChildNodes(), "resData");
            NodeList registrar_info_result_list = response_data_element.getElementsByTagName("registrar:infData").item(0).getChildNodes();
            this.debug(2, method_name, "registrar:infData's node count [" + registrar_info_result_list.getLength() + "]");
            if (registrar_info_result_list.getLength() == 0) {
                throw new epp_XMLException("missing info results");
            }
            ArrayList<epp_DomainContact> contacts = new ArrayList<epp_DomainContact>();
            ArrayList<epp_RegistrarPortfolio> portfolios = new ArrayList<epp_RegistrarPortfolio>();
            for (int count = 0; count < registrar_info_result_list.getLength(); ++count) {
                Node a_node = registrar_info_result_list.item(count);
                if (a_node.getNodeName().equals("registrar:id")) {
                    this.action_response_.m_id = a_node.getFirstChild().getNodeValue();
                }
                if (a_node.getNodeName().equals("registrar:roid")) {
                    this.action_response_.m_roid = a_node.getFirstChild().getNodeValue();
                }
                if (a_node.getNodeName().equals("registrar:user")) {
                    this.action_response_.m_user = a_node.getFirstChild().getNodeValue();
                }
                if (a_node.getNodeName().equals("registrar:guid")) {
                    this.action_response_.m_guid = Integer.valueOf(a_node.getFirstChild().getNodeValue());
                }
                if (a_node.getNodeName().equals("registrar:ctID")) {
                    this.action_response_.m_contact_roid = a_node.getFirstChild().getNodeValue();
                }
                if (a_node.getNodeName().equals("registrar:contact")) {
                    epp_DomainContact domain_contact = new epp_DomainContact();
                    domain_contact.m_id = a_node.getFirstChild().getNodeValue();
                    domain_contact.m_type = (epp_DomainContactType)contact_type_hash_.get(((Element)a_node).getAttribute("type"));
                    contacts.add(domain_contact);
                }
                if (a_node.getNodeName().equals("registrar:url")) {
                    this.action_response_.m_url = a_node.getFirstChild().getNodeValue();
                }
                if (a_node.getNodeName().equals("registrar:crID")) {
                    this.action_response_.m_created_by = a_node.getFirstChild().getNodeValue();
                }
                if (a_node.getNodeName().equals("registrar:crDate")) {
                    this.action_response_.m_created_date = a_node.getFirstChild().getNodeValue();
                }
                if (a_node.getNodeName().equals("registrar:upID")) {
                    this.action_response_.m_updated_by = a_node.getFirstChild().getNodeValue();
                }
                if (a_node.getNodeName().equals("registrar:upDate")) {
                    this.action_response_.m_updated_date = a_node.getFirstChild().getNodeValue();
                }
                if (a_node.getNodeName().equals("registrar:status")) {
                    this.action_response_.m_status = ((Element)a_node).getAttribute("s");
                }
                if (a_node.getNodeName().equals("registrar:email")) {
                    this.action_response_.m_email = a_node.getFirstChild().getNodeValue();
                }
                if (a_node.getNodeName().equals("registrar:portfolio")) {
                    epp_RegistrarPortfolio registrarPortfolio = new epp_RegistrarPortfolio();
                    registrarPortfolio.setName(((Element)a_node).getAttribute("name"));
                    NodeList portfolio_nodelist = a_node.getChildNodes();
                    for (int i = 0; i < portfolio_nodelist.getLength(); ++i) {
                        Node portfolio_node = portfolio_nodelist.item(i);
                        if (portfolio_node.getNodeName().equals("registrar:balance")) {
                            registrarPortfolio.setBalance(Float.valueOf(portfolio_node.getFirstChild().getNodeValue()).floatValue());
                        }
                        if (!portfolio_node.getNodeName().equals("registrar:threshold")) continue;
                        registrarPortfolio.setThreshold(Float.valueOf(portfolio_node.getFirstChild().getNodeValue()).floatValue());
                    }
                    portfolios.add(registrarPortfolio);
                }
                if (a_node.getNodeName().equals("registrar:category")) {
                    this.action_response_.m_category = a_node.getFirstChild().getNodeValue();
                }
                if (!a_node.getNodeName().equals("registrar:groupLeadRole")) continue;
                epp_DomainContact registrar_groupLeadRole = new epp_DomainContact();
                registrar_groupLeadRole.m_id = a_node.getFirstChild().getNodeValue();
                registrar_groupLeadRole.m_type = (epp_DomainContactType)contact_type_hash_.get(((Element)a_node).getAttribute("type"));
                this.action_response_.m_groupLeadRole = registrar_groupLeadRole;
            }
            if (contacts.size() > 0) {
                this.action_response_.m_contacts = (epp_DomainContact[])EPPRegistrarInfo.convertListToArray(new epp_DomainContact().getClass(), contacts);
            }
            if (portfolios.size() > 0) {
                this.action_response_.m_portfolios = (epp_RegistrarPortfolio[])EPPRegistrarInfo.convertListToArray(epp_RegistrarPortfolio.class, portfolios);
            }
        }
        catch (SAXException xcp) {
            this.debug(1, method_name, xcp);
            throw new epp_XMLException("unable to parse xml [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
        }
        catch (IOException xcp) {
            this.debug(1, method_name, xcp);
            throw new epp_XMLException("unable to parse xml [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
        }
    }
}

