/*
 * Decompiled with CFR 0.152.
 */
package com.tucows.oxrs.epprtk.rtk.xml;

import com.tucows.oxrs.epprtk.rtk.RTKBase;
import com.tucows.oxrs.epprtk.rtk.xml.EPPXMLBase;
import com.tucows.oxrs.epprtk.rtk.xml.poll.PollResData;
import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.apache.xerces.dom.DocumentImpl;
import org.openrtk.idl.epprtk.epp_Command;
import org.openrtk.idl.epprtk.epp_Exception;
import org.openrtk.idl.epprtk.epp_Poll;
import org.openrtk.idl.epprtk.epp_PollOpType;
import org.openrtk.idl.epprtk.epp_PollReq;
import org.openrtk.idl.epprtk.epp_PollRsp;
import org.openrtk.idl.epprtk.epp_XMLException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class EPPPoll
extends EPPXMLBase
implements epp_Poll {
    private epp_PollReq action_request_;
    private epp_PollRsp action_response_;
    private static Hashtable poll_op_to_string_hash_;

    public EPPPoll() {
        this.initHash();
    }

    public EPPPoll(String xml) throws epp_XMLException, epp_Exception {
        super(xml);
        String method_name = "EPPPoll(String)";
        this.debug(2, method_name, "xml is [" + xml + "]");
        this.initHash();
        this.fromXML(xml);
    }

    private void initHash() {
        if (poll_op_to_string_hash_ == null) {
            poll_op_to_string_hash_ = new Hashtable();
            poll_op_to_string_hash_.put(epp_PollOpType.REQ, "req");
            poll_op_to_string_hash_.put(epp_PollOpType.ACK, "ack");
        }
    }

    @Override
    public void setRequestData(epp_PollReq value) {
        this.action_request_ = value;
    }

    @Override
    public epp_PollRsp getResponseData() {
        return this.action_response_;
    }

    @Override
    public String toXML() throws epp_XMLException {
        String request_xml;
        String method_name = "buildRequestXML()";
        this.debug(3, method_name, "Entered");
        if (this.action_request_ == null) {
            throw new epp_XMLException("missing request data");
        }
        DocumentImpl doc = new DocumentImpl();
        Element root = this.createDocRoot((Document)doc);
        Element command = doc.createElement("command");
        Element poll = doc.createElement("poll");
        epp_Command command_data = this.action_request_.m_cmd;
        if (this.action_request_.m_op == null) {
            this.action_request_.m_op = epp_PollOpType.REQ;
        }
        poll.setAttribute("op", (String)poll_op_to_string_hash_.get(this.action_request_.m_op));
        if (this.action_request_.m_msgID != null) {
            poll.setAttribute("msgID", this.action_request_.m_msgID);
        }
        command.appendChild(poll);
        this.prepareExtensionElement((Document)doc, command, command_data.m_extensions);
        if (command_data.m_client_trid != null) {
            this.addXMLElement((Document)doc, command, "clTRID", command_data.m_client_trid);
        }
        root.appendChild(command);
        doc.appendChild(root);
        try {
            request_xml = this.createXMLFromDoc((Document)doc);
        }
        catch (IOException xcp) {
            throw new epp_XMLException("IOException in building XML [" + xcp.getMessage() + "]");
        }
        this.debug(3, method_name, "Leaving");
        return request_xml;
    }

    @Override
    public void fromXML(String xml) throws epp_XMLException, epp_Exception {
        block11: {
            String method_name = "fromXML()";
            this.debug(3, method_name, "Entered");
            this.xml_ = xml;
            try {
                Element epp_node = this.getDocumentElement();
                Node response_node = epp_node.getElementsByTagName("response").item(0);
                if (response_node == null) {
                    throw new epp_XMLException("unparsable or missing response");
                }
                this.action_response_ = new epp_PollRsp();
                this.action_response_.m_rsp = this.parseGenericResult(response_node);
                if (this.action_response_.m_rsp.m_results[0].m_code >= 2000) {
                    throw new epp_Exception(this.action_response_.m_rsp.m_results);
                }
                Element response_data_element = this.getElement(response_node.getChildNodes(), "resData");
                if (response_data_element == null) break block11;
                NodeList poll_resData_nodelist = response_data_element.getElementsByTagName("*");
                this.debug(2, method_name, "poll_resData_nodelist count [" + poll_resData_nodelist.getLength() + "]");
                int count = 0;
                if (count >= poll_resData_nodelist.getLength()) break block11;
                Node a_node = poll_resData_nodelist.item(count);
                String a_node_name = a_node.getNodeName();
                this.debug(2, method_name, "poll resData node name [" + a_node_name + "]");
                RE regexp = new RE("\\W");
                String class_name = regexp.subst(a_node_name, "");
                String poll_extension_package_name = "com.tucows.oxrs.epprtk.rtk.xml.poll";
                StringTokenizer poll_package_names = new StringTokenizer(RTKBase.getRTKProperties().getProperty("poll.parser.extension.packages", ""), ",");
                PollResData poll_res_data = null;
                while (poll_res_data == null) {
                    try {
                        this.debug(2, method_name, "Trying to instantiate poll resData parser class [" + poll_extension_package_name + class_name + "]");
                        poll_res_data = (PollResData)Class.forName(poll_extension_package_name + "." + class_name).newInstance();
                    }
                    catch (ClassNotFoundException xcp) {
                        if (poll_package_names == null || !poll_package_names.hasMoreTokens()) break;
                        poll_extension_package_name = poll_package_names.nextToken();
                    }
                    catch (Exception xcp) {
                        throw new epp_XMLException("Error loading Poll resData parser class [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
                    }
                    this.debug(2, method_name, "Found class.");
                }
                if (poll_res_data == null) {
                    throw new epp_XMLException("Unrecognized Poll resData [" + a_node_name + "]");
                }
                poll_res_data.fromXML(a_node);
                this.action_response_.m_res_data = poll_res_data.getPollResData();
            }
            catch (SAXException xcp) {
                this.debug(1, method_name, xcp);
                throw new epp_XMLException("unable to parse xml [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
            }
            catch (IOException xcp) {
                this.debug(1, method_name, xcp);
                throw new epp_XMLException("unable to parse xml [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
            }
            catch (RESyntaxException xcp) {
                this.debug(1, method_name, (Exception)((Object)xcp));
                throw new epp_XMLException("Error in parsing poll resData parser class name[" + ((Object)((Object)xcp)).getClass().getName() + "] [" + xcp.getMessage() + "]");
            }
        }
    }
}

