/*
 * Decompiled with CFR 0.152.
 */
package com.tucows.oxrs.epprtk.rtk.xml;

import com.tucows.oxrs.epprtk.rtk.xml.EPPXMLBase;
import java.io.IOException;
import org.apache.xerces.dom.DocumentImpl;
import org.openrtk.idl.epprtk.epp_Command;
import org.openrtk.idl.epprtk.epp_Exception;
import org.openrtk.idl.epprtk.epp_Login;
import org.openrtk.idl.epprtk.epp_LoginReq;
import org.openrtk.idl.epprtk.epp_LoginRsp;
import org.openrtk.idl.epprtk.epp_XMLException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EPPLogin
extends EPPXMLBase
implements epp_Login {
    private epp_LoginReq action_request_;
    private epp_LoginRsp action_response_;

    public EPPLogin() {
    }

    public EPPLogin(String xml) throws epp_XMLException, epp_Exception {
        String method_name = "EPPLogin(String)";
        this.debug(2, method_name, "xml is [" + xml + "]");
        this.fromXML(xml);
    }

    @Override
    public void setRequestData(epp_LoginReq value) {
        this.action_request_ = value;
    }

    @Override
    public epp_LoginRsp getResponseData() {
        return this.action_response_;
    }

    @Override
    public String toXML() throws epp_Exception, epp_XMLException {
        String request_xml;
        String method_name = "toXML(EPPLoginReq)";
        this.debug(3, method_name, "Entered");
        if (this.action_request_ == null || this.action_request_.m_cmd == null) {
            throw new epp_XMLException("missing login request or creds data");
        }
        if (this.action_request_.m_services == null) {
            throw new epp_XMLException("missing services in login");
        }
        DocumentImpl doc = new DocumentImpl();
        Element root = this.createDocRoot((Document)doc);
        Element command = doc.createElement("command");
        Element login = doc.createElement("login");
        epp_Command command_data = this.action_request_.m_cmd;
        this.addXMLElement((Document)doc, login, "clID", this.action_request_.m_client_id);
        this.addXMLElement((Document)doc, login, "pw", this.action_request_.m_password);
        if (this.action_request_.m_new_password != null) {
            this.addXMLElement((Document)doc, login, "newPW", this.action_request_.m_new_password);
        }
        if (this.action_request_.m_options != null) {
            Element options_element = doc.createElement("options");
            if (this.action_request_.m_options.m_version != null) {
                this.addXMLElement((Document)doc, options_element, "version", this.action_request_.m_options.m_version);
            }
            if (this.action_request_.m_options.m_lang != null) {
                this.addXMLElement((Document)doc, options_element, "lang", this.action_request_.m_options.m_lang);
            }
            login.appendChild(options_element);
        }
        Element services_element = doc.createElement("svcs");
        for (int count = 0; count < this.action_request_.m_services.length; ++count) {
            String service = this.action_request_.m_services[count];
            this.addXMLElement((Document)doc, services_element, "objURI", service);
        }
        if (this.action_request_.m_extensions != null) {
            Element extensions_element = doc.createElement("svcExtension");
            for (int count = 0; count < this.action_request_.m_extensions.length; ++count) {
                String extension = this.action_request_.m_extensions[count];
                this.addXMLElement((Document)doc, extensions_element, "extURI", extension);
            }
            services_element.appendChild(extensions_element);
        }
        login.appendChild(services_element);
        command.appendChild(login);
        this.prepareExtensionElement((Document)doc, command, command_data.m_extensions);
        if (command_data.m_client_trid != null) {
            this.addXMLElement((Document)doc, command, "clTRID", command_data.m_client_trid);
        }
        root.appendChild(command);
        doc.appendChild(root);
        try {
            request_xml = this.createXMLFromDoc((Document)doc);
        }
        catch (IOException xcp) {
            throw new epp_XMLException("IOException in building XML [" + xcp.getMessage() + "]");
        }
        this.debug(3, method_name, "Leaving");
        return request_xml;
    }

    @Override
    public void fromXML(String xml) throws epp_XMLException, epp_Exception {
        String method_name = "fromXML()";
        this.debug(3, method_name, "Entered");
        this.xml_ = xml;
        try {
            Element epp_node = this.getDocumentElement();
            Node response_node = epp_node.getElementsByTagName("response").item(0);
            if (response_node == null) {
                throw new epp_XMLException("unparsable or missing response");
            }
            this.action_response_ = new epp_LoginRsp();
            this.action_response_.m_rsp = this.parseGenericResult(response_node);
            if (this.action_response_.m_rsp.m_results[0].m_code >= 2000) {
                throw new epp_Exception(this.action_response_.m_rsp.m_results);
            }
        }
        catch (epp_Exception xcp) {
            this.debug(1, method_name, (Exception)((Object)xcp));
            throw xcp;
        }
        catch (Exception xcp) {
            this.debug(1, method_name, xcp);
            throw new epp_XMLException("unable to parse xml [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
        }
    }
}

