/*
 * Decompiled with CFR 0.152.
 */
package com.tucows.oxrs.epprtk.rtk.xml;

import com.tucows.oxrs.epprtk.rtk.xml.EPPDomainBase;
import java.io.IOException;
import org.apache.xerces.dom.DocumentImpl;
import org.openrtk.idl.epprtk.domain.epp_DomainPeriod;
import org.openrtk.idl.epprtk.domain.epp_DomainRenew;
import org.openrtk.idl.epprtk.domain.epp_DomainRenewReq;
import org.openrtk.idl.epprtk.domain.epp_DomainRenewRsp;
import org.openrtk.idl.epprtk.epp_Command;
import org.openrtk.idl.epprtk.epp_Exception;
import org.openrtk.idl.epprtk.epp_XMLException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class EPPDomainRenew
extends EPPDomainBase
implements epp_DomainRenew {
    private epp_DomainRenewReq action_request_;
    private epp_DomainRenewRsp action_response_;

    public EPPDomainRenew() {
    }

    public EPPDomainRenew(String xml) throws epp_XMLException, epp_Exception {
        String method_name = "EPPDomainRenew(String)";
        this.debug(2, method_name, "xml is [" + xml + "]");
        this.fromXML(xml);
    }

    @Override
    public void setRequestData(epp_DomainRenewReq value) {
        this.action_request_ = value;
    }

    @Override
    public epp_DomainRenewRsp getResponseData() {
        return this.action_response_;
    }

    @Override
    public String toXML() throws epp_XMLException {
        String request_xml;
        String method_name = "buildRequestXML()";
        this.debug(3, method_name, "Entered");
        if (this.action_request_ == null || this.action_request_.m_cmd == null || this.action_request_.m_name == null) {
            throw new epp_XMLException("missing request data or domain name");
        }
        DocumentImpl doc = new DocumentImpl();
        Element root = this.createDocRoot((Document)doc);
        Element command = doc.createElement("command");
        Element renew = doc.createElement("renew");
        epp_Command command_data = this.action_request_.m_cmd;
        Element domain_renew = doc.createElement("domain:renew");
        this.setCommonAttributes(domain_renew);
        this.addXMLElement((Document)doc, domain_renew, "domain:name", this.action_request_.m_name);
        this.addXMLElement((Document)doc, domain_renew, "domain:curExpDate", this.action_request_.m_current_expiration_date);
        if (this.action_request_.m_period != null) {
            epp_DomainPeriod domain_period = this.action_request_.m_period;
            Element period = this.addXMLElement((Document)doc, domain_renew, "domain:period", Short.toString(domain_period.m_value));
            period.setAttribute("unit", domain_period.m_unit.toString());
        }
        renew.appendChild(domain_renew);
        command.appendChild(renew);
        this.prepareExtensionElement((Document)doc, command, command_data.m_extensions);
        if (command_data.m_client_trid != null) {
            this.addXMLElement((Document)doc, command, "clTRID", command_data.m_client_trid);
        }
        root.appendChild(command);
        doc.appendChild(root);
        try {
            request_xml = this.createXMLFromDoc((Document)doc);
        }
        catch (IOException xcp) {
            throw new epp_XMLException("IOException in building XML [" + xcp.getMessage() + "]");
        }
        this.debug(3, method_name, "Leaving");
        return request_xml;
    }

    @Override
    public void fromXML(String xml) throws epp_XMLException, epp_Exception {
        String method_name = "fromXML()";
        this.debug(3, method_name, "Entered");
        this.xml_ = xml;
        try {
            Element epp_node = this.getDocumentElement();
            Node response_node = epp_node.getElementsByTagName("response").item(0);
            if (response_node == null) {
                throw new epp_XMLException("unparsable or missing response");
            }
            this.action_response_ = new epp_DomainRenewRsp();
            this.action_response_.m_rsp = this.parseGenericResult(response_node);
            if (this.action_response_.m_rsp.m_results[0].m_code >= 2000) {
                throw new epp_Exception(this.action_response_.m_rsp.m_results);
            }
            Element response_data_element = this.getElement(response_node.getChildNodes(), "resData");
            NodeList domain_renew_data_list = response_data_element.getElementsByTagName("domain:renData").item(0).getChildNodes();
            this.debug(2, method_name, "domain:renData's node count [" + domain_renew_data_list.getLength() + "]");
            if (domain_renew_data_list == null || domain_renew_data_list.getLength() == 0) {
                throw new epp_XMLException("missing domain renew response data");
            }
            for (int count = 0; count < domain_renew_data_list.getLength(); ++count) {
                Node a_node = domain_renew_data_list.item(count);
                if (a_node.getNodeName().equals("domain:name")) {
                    this.action_response_.m_name = a_node.getFirstChild().getNodeValue();
                }
                if (!a_node.getNodeName().equals("domain:exDate")) continue;
                this.action_response_.m_expiration_date = a_node.getFirstChild().getNodeValue();
            }
        }
        catch (SAXException xcp) {
            this.debug(1, method_name, xcp);
            throw new epp_XMLException("unable to parse xml [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
        }
        catch (IOException xcp) {
            this.debug(1, method_name, xcp);
            throw new epp_XMLException("unable to parse xml [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
        }
    }
}

