/*
 * Decompiled with CFR 0.152.
 */
package com.tucows.oxrs.epprtk.rtk.xml;

import com.tucows.oxrs.epprtk.rtk.xml.EPPXMLBase;
import java.util.Hashtable;
import java.util.List;
import org.openrtk.idl.epprtk.domain.epp_DomainContactType;
import org.openrtk.idl.epprtk.domain.epp_DomainStatusType;
import org.openrtk.idl.epprtk.domain.epp_DomainTrnData;
import org.openrtk.idl.epprtk.epp_TransferStatusType;
import org.openrtk.idl.epprtk.epp_XMLException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class EPPDomainBase
extends EPPXMLBase {
    protected static Hashtable domain_status_hash_;
    protected static Hashtable contact_type_hash_;

    public EPPDomainBase() {
        EPPDomainBase.initHashes();
    }

    public EPPDomainBase(String xml) {
        super(xml);
        EPPDomainBase.initHashes();
    }

    public static void initHashes() {
        EPPDomainBase.initDomainStatusHash();
        EPPDomainBase.initContactTypeHash();
    }

    protected static void initDomainStatusHash() {
        if (domain_status_hash_ == null) {
            domain_status_hash_ = new Hashtable();
            domain_status_hash_.put("clientDeleteProhibited", epp_DomainStatusType.CLIENT_DELETE_PROHIBITED);
            domain_status_hash_.put("clientHold", epp_DomainStatusType.CLIENT_HOLD);
            domain_status_hash_.put("clientRenewProhibited", epp_DomainStatusType.CLIENT_RENEW_PROHIBITED);
            domain_status_hash_.put("clientTransferProhibited", epp_DomainStatusType.CLIENT_TRANSFER_PROHIBITED);
            domain_status_hash_.put("clientUpdateProhibited", epp_DomainStatusType.CLIENT_UPDATE_PROHIBITED);
            domain_status_hash_.put("inactive", epp_DomainStatusType.INACTIVE);
            domain_status_hash_.put("ok", epp_DomainStatusType.OK);
            domain_status_hash_.put("pendingCreate", epp_DomainStatusType.PENDING_CREATE);
            domain_status_hash_.put("pendingDelete", epp_DomainStatusType.PENDING_DELETE);
            domain_status_hash_.put("pendingTransfer", epp_DomainStatusType.PENDING_TRANSFER);
            domain_status_hash_.put("pendingRenew", epp_DomainStatusType.PENDING_RENEW);
            domain_status_hash_.put("pendingUpdate", epp_DomainStatusType.PENDING_UPDATE);
            domain_status_hash_.put("serverDeleteProhibited", epp_DomainStatusType.SERVER_DELETE_PROHIBITED);
            domain_status_hash_.put("serverHold", epp_DomainStatusType.SERVER_HOLD);
            domain_status_hash_.put("serverRenewProhibited", epp_DomainStatusType.SERVER_RENEW_PROHIBITED);
            domain_status_hash_.put("serverTransferProhibited", epp_DomainStatusType.SERVER_TRANSFER_PROHIBITED);
            domain_status_hash_.put("serverUpdateProhibited", epp_DomainStatusType.SERVER_UPDATE_PROHIBITED);
        }
    }

    protected static void initContactTypeHash() {
        if (contact_type_hash_ == null) {
            contact_type_hash_ = new Hashtable();
            contact_type_hash_.put("admin", epp_DomainContactType.ADMIN);
            contact_type_hash_.put("billing", epp_DomainContactType.BILLING);
            contact_type_hash_.put("tech", epp_DomainContactType.TECH);
        }
    }

    protected void setCommonAttributes(Element command) {
        command.setAttribute("xmlns:domain", "urn:ietf:params:xml:ns:domain-1.0");
        command.setAttribute("xsi:schemaLocation", "urn:ietf:params:xml:ns:domain-1.0 domain-1.0.xsd");
    }

    protected Element createNameServerElement(Document doc, List nameServers) {
        Element nameServerElement = doc.createElement("domain:ns");
        for (String server_name : nameServers) {
            this.addXMLElement(doc, nameServerElement, "domain:hostObj", server_name);
        }
        return nameServerElement;
    }

    public static String domainStatusToString(epp_DomainStatusType status_type) {
        return status_type.toString();
    }

    public static String domainContactTypeToString(epp_DomainContactType contact_type) {
        return contact_type.toString();
    }

    public static epp_DomainStatusType domainStatusFromString(String s) {
        EPPDomainBase.initDomainStatusHash();
        return (epp_DomainStatusType)domain_status_hash_.get(s);
    }

    public static epp_DomainTrnData getTrnData(NodeList transfer_data_list) throws epp_XMLException {
        epp_DomainTrnData trn_data = new epp_DomainTrnData();
        for (int count = 0; count < transfer_data_list.getLength(); ++count) {
            Node a_node = transfer_data_list.item(count);
            if (a_node.getNodeName().equals("domain:name")) {
                trn_data.m_name = a_node.getFirstChild().getNodeValue();
            }
            if (a_node.getNodeName().equals("domain:reID")) {
                trn_data.m_request_client_id = a_node.getFirstChild().getNodeValue();
            }
            if (a_node.getNodeName().equals("domain:acID")) {
                trn_data.m_action_client_id = a_node.getFirstChild().getNodeValue();
            }
            if (a_node.getNodeName().equals("domain:trStatus")) {
                String status_value = a_node.getFirstChild().getNodeValue();
                if (!transfer_status_to_type_hash_.containsKey(status_value)) {
                    throw new epp_XMLException("unknown returned transfer status [" + status_value + "]");
                }
                trn_data.m_transfer_status = (epp_TransferStatusType)transfer_status_to_type_hash_.get(status_value);
            }
            if (a_node.getNodeName().equals("domain:reDate")) {
                trn_data.m_request_date = a_node.getFirstChild().getNodeValue();
            }
            if (a_node.getNodeName().equals("domain:acDate")) {
                trn_data.m_action_date = a_node.getFirstChild().getNodeValue();
            }
            if (!a_node.getNodeName().equals("domain:exDate")) continue;
            trn_data.m_expiration_date = a_node.getFirstChild().getNodeValue();
        }
        return trn_data;
    }
}

