/*
 * Decompiled with CFR 0.152.
 */
package com.tucows.oxrs.epprtk.rtk.example;

import com.tucows.oxrs.epprtk.rtk.EPPClient;
import com.tucows.oxrs.epprtk.rtk.xml.EPPHostCheck;
import com.tucows.oxrs.epprtk.rtk.xml.EPPHostCreate;
import com.tucows.oxrs.epprtk.rtk.xml.EPPHostDelete;
import com.tucows.oxrs.epprtk.rtk.xml.EPPXMLBase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openrtk.idl.epprtk.epp_CheckResult;
import org.openrtk.idl.epprtk.epp_Command;
import org.openrtk.idl.epprtk.epp_Exception;
import org.openrtk.idl.epprtk.epp_XMLException;
import org.openrtk.idl.epprtk.host.epp_HostAddress;
import org.openrtk.idl.epprtk.host.epp_HostAddressType;
import org.openrtk.idl.epprtk.host.epp_HostCheckReq;
import org.openrtk.idl.epprtk.host.epp_HostCreateReq;
import org.openrtk.idl.epprtk.host.epp_HostCreateRsp;
import org.openrtk.idl.epprtk.host.epp_HostDeleteReq;
import org.openrtk.idl.epprtk.host.epp_HostDeleteRsp;

public class HostUtils {
    private HostUtils() {
    }

    public static Map checkHosts(EPPClient client, List hostNames) throws epp_XMLException, epp_Exception, Exception {
        HashMap<String, Boolean> hostsAvail = new HashMap<String, Boolean>();
        epp_HostCheckReq host_check_request = new epp_HostCheckReq();
        epp_Command command = new epp_Command();
        command.setClientTrid(HostUtils.getClientTrid(client.getEPPClientID()));
        host_check_request.setCmd(command);
        host_check_request.setNames(EPPXMLBase.convertListToStringArray(hostNames));
        EPPHostCheck host_check = new EPPHostCheck();
        host_check.setRequestData(host_check_request);
        host_check = (EPPHostCheck)client.processAction(host_check);
        epp_CheckResult[] check_results = host_check.getResponseData().getResults();
        for (String hostName : hostNames) {
            Boolean hostAvail = EPPXMLBase.getAvailResultFor(check_results, hostName);
            hostsAvail.put(hostName, hostAvail);
        }
        return hostsAvail;
    }

    public static Boolean checkHost(EPPClient client, String hostName) throws epp_XMLException, epp_Exception, Exception {
        ArrayList<String> hostNames = new ArrayList<String>();
        hostNames.add(hostName);
        Map hostsAvail = HostUtils.checkHosts(client, hostNames);
        return (Boolean)hostsAvail.get(hostName);
    }

    public static epp_HostCreateRsp createHost(EPPClient client, String hostName, List ipAddresses) throws epp_XMLException, epp_Exception, Exception {
        epp_HostCreateReq host_create_request = new epp_HostCreateReq();
        epp_Command command_data = new epp_Command();
        command_data.setClientTrid(HostUtils.getClientTrid(client.getEPPClientID()));
        host_create_request.setCmd(command_data);
        if (ipAddresses != null) {
            ArrayList<epp_HostAddress> hostAddresses = new ArrayList<epp_HostAddress>();
            Iterator it = ipAddresses.iterator();
            while (it.hasNext()) {
                hostAddresses.add(new epp_HostAddress(epp_HostAddressType.IPV4, (String)it.next()));
            }
            host_create_request.setAddresses((epp_HostAddress[])EPPXMLBase.convertListToArray(new epp_HostAddress().getClass(), hostAddresses));
        }
        host_create_request.setName(hostName);
        EPPHostCreate host_create = new EPPHostCreate();
        host_create.setRequestData(host_create_request);
        host_create = (EPPHostCreate)client.processAction(host_create);
        return host_create.getResponseData();
    }

    public static epp_HostCreateRsp createExternalHost(EPPClient client, String hostName) throws epp_XMLException, epp_Exception, Exception {
        return HostUtils.createHost(client, hostName, null);
    }

    public static epp_HostDeleteRsp deleteHost(EPPClient client, String hostName) throws epp_XMLException, epp_Exception, Exception {
        epp_HostDeleteReq host_delete_request = new epp_HostDeleteReq();
        epp_Command command_data = new epp_Command();
        command_data.setClientTrid(HostUtils.getClientTrid(client.getEPPClientID()));
        host_delete_request.setCmd(command_data);
        host_delete_request.setName(hostName);
        EPPHostDelete host_delete = new EPPHostDelete();
        host_delete.setRequestData(host_delete_request);
        host_delete = (EPPHostDelete)client.processAction(host_delete);
        return host_delete.getResponseData();
    }

    protected static String getClientTrid(String epp_client_id) {
        return "ABC:" + epp_client_id + ":" + System.currentTimeMillis();
    }
}

