/*
 * Decompiled with CFR 0.152.
 */
package com.tucows.oxrs.epprtk.rtk.example;

import com.tucows.oxrs.epprtk.rtk.EPPClient;
import com.tucows.oxrs.epprtk.rtk.RTKBase;
import com.tucows.oxrs.epprtk.rtk.xml.EPPDomainCheck;
import com.tucows.oxrs.epprtk.rtk.xml.EPPDomainCreate;
import com.tucows.oxrs.epprtk.rtk.xml.EPPDomainDelete;
import com.tucows.oxrs.epprtk.rtk.xml.EPPDomainInfo;
import com.tucows.oxrs.epprtk.rtk.xml.EPPDomainRenew;
import com.tucows.oxrs.epprtk.rtk.xml.EPPDomainTransfer;
import com.tucows.oxrs.epprtk.rtk.xml.EPPDomainUpdate;
import com.tucows.oxrs.epprtk.rtk.xml.EPPXMLBase;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.openrtk.idl.epprtk.domain.epp_DomainCheckReq;
import org.openrtk.idl.epprtk.domain.epp_DomainContact;
import org.openrtk.idl.epprtk.domain.epp_DomainContactType;
import org.openrtk.idl.epprtk.domain.epp_DomainCreateReq;
import org.openrtk.idl.epprtk.domain.epp_DomainCreateRsp;
import org.openrtk.idl.epprtk.domain.epp_DomainDeleteReq;
import org.openrtk.idl.epprtk.domain.epp_DomainDeleteRsp;
import org.openrtk.idl.epprtk.domain.epp_DomainInfoReq;
import org.openrtk.idl.epprtk.domain.epp_DomainInfoRsp;
import org.openrtk.idl.epprtk.domain.epp_DomainPeriod;
import org.openrtk.idl.epprtk.domain.epp_DomainPeriodUnitType;
import org.openrtk.idl.epprtk.domain.epp_DomainRenewReq;
import org.openrtk.idl.epprtk.domain.epp_DomainRenewRsp;
import org.openrtk.idl.epprtk.domain.epp_DomainTransferReq;
import org.openrtk.idl.epprtk.domain.epp_DomainTransferRsp;
import org.openrtk.idl.epprtk.domain.epp_DomainUpdateAddRemove;
import org.openrtk.idl.epprtk.domain.epp_DomainUpdateChange;
import org.openrtk.idl.epprtk.domain.epp_DomainUpdateReq;
import org.openrtk.idl.epprtk.domain.epp_DomainUpdateRsp;
import org.openrtk.idl.epprtk.epp_AuthInfo;
import org.openrtk.idl.epprtk.epp_AuthInfoType;
import org.openrtk.idl.epprtk.epp_CheckResult;
import org.openrtk.idl.epprtk.epp_Command;
import org.openrtk.idl.epprtk.epp_Exception;
import org.openrtk.idl.epprtk.epp_TransferOpType;
import org.openrtk.idl.epprtk.epp_TransferRequest;
import org.openrtk.idl.epprtk.epp_XMLException;

public class DomainUtils {
    private DomainUtils() {
    }

    public static Map checkDomains(EPPClient client, List domainNames) throws epp_XMLException, epp_Exception, Exception {
        HashMap<String, Boolean> domainsAvail = new HashMap<String, Boolean>();
        epp_DomainCheckReq domain_check_request = new epp_DomainCheckReq();
        epp_Command command = new epp_Command();
        command.setClientTrid(DomainUtils.getClientTrid(client.getEPPClientID()));
        domain_check_request.setCmd(command);
        domain_check_request.setNames(EPPXMLBase.convertListToStringArray(domainNames));
        EPPDomainCheck domain_check = new EPPDomainCheck();
        domain_check.setRequestData(domain_check_request);
        domain_check = (EPPDomainCheck)client.processAction(domain_check);
        epp_CheckResult[] check_results = domain_check.getResponseData().getResults();
        for (String domainName : domainNames) {
            Boolean domainAvail = EPPXMLBase.getAvailResultFor(check_results, domainName);
            domainsAvail.put(domainName, domainAvail);
        }
        return domainsAvail;
    }

    public static Boolean checkDomain(EPPClient client, String domainName) throws epp_XMLException, epp_Exception, Exception {
        ArrayList<String> domainNames = new ArrayList<String>();
        domainNames.add(domainName);
        Map domainsAvail = DomainUtils.checkDomains(client, domainNames);
        return (Boolean)domainsAvail.get(domainName);
    }

    public static epp_DomainCreateRsp createDomain(EPPClient client, String domainName, int period, List nameServers, String authInfo, String registrantId, String adminContactId, String billingContactId, String techContactId) throws epp_XMLException, epp_Exception, Exception {
        epp_DomainCreateReq domain_create_request = new epp_DomainCreateReq();
        epp_Command command = new epp_Command();
        command.setClientTrid(DomainUtils.getClientTrid(client.getEPPClientID()));
        domain_create_request.setCmd(command);
        domain_create_request.setName(domainName);
        epp_DomainPeriod domainPeriod = new epp_DomainPeriod();
        domainPeriod.setUnit(epp_DomainPeriodUnitType.YEAR);
        domainPeriod.setValue(period);
        domain_create_request.setPeriod(domainPeriod);
        domain_create_request.setNameServers(EPPXMLBase.convertListToStringArray(nameServers));
        epp_AuthInfo domain_auth_info = new epp_AuthInfo();
        domain_auth_info.setValue(authInfo);
        domain_auth_info.setType(epp_AuthInfoType.PW);
        domain_create_request.setAuthInfo(domain_auth_info);
        Vector<epp_DomainContact> contacts = new Vector<epp_DomainContact>();
        contacts.add(new epp_DomainContact(epp_DomainContactType.TECH, techContactId));
        contacts.add(new epp_DomainContact(epp_DomainContactType.ADMIN, adminContactId));
        contacts.add(new epp_DomainContact(epp_DomainContactType.BILLING, billingContactId));
        domain_create_request.setContacts(contacts.toArray(new epp_DomainContact[1]));
        domain_create_request.setRegistrant(registrantId);
        EPPDomainCreate domain_create = new EPPDomainCreate();
        domain_create.setRequestData(domain_create_request);
        domain_create = (EPPDomainCreate)client.processAction(domain_create);
        return domain_create.getResponseData();
    }

    public static epp_DomainInfoRsp infoDomain(EPPClient client, String domainName) throws epp_XMLException, epp_Exception, Exception {
        epp_DomainInfoReq domain_info_request = new epp_DomainInfoReq();
        epp_Command command_data = new epp_Command();
        command_data.setClientTrid(DomainUtils.getClientTrid(client.getEPPClientID()));
        domain_info_request.setCmd(command_data);
        domain_info_request.setName(domainName);
        EPPDomainInfo domain_info = new EPPDomainInfo();
        domain_info.setRequestData(domain_info_request);
        domain_info = (EPPDomainInfo)client.processAction(domain_info);
        return domain_info.getResponseData();
    }

    public static epp_DomainRenewRsp renewDomain(EPPClient client, String domainName, int period, Date expiryDate) throws epp_XMLException, epp_Exception, Exception {
        epp_DomainRenewReq domain_renew_request = new epp_DomainRenewReq();
        epp_Command command_data = new epp_Command();
        command_data.setClientTrid(DomainUtils.getClientTrid(client.getEPPClientID()));
        domain_renew_request.setCmd(command_data);
        domain_renew_request.setName(domainName);
        epp_DomainPeriod domainPeriod = new epp_DomainPeriod();
        domainPeriod.setUnit(epp_DomainPeriodUnitType.YEAR);
        domainPeriod.setValue(period);
        domain_renew_request.setPeriod(domainPeriod);
        domain_renew_request.setCurrentExpirationDate(RTKBase.DATE_FMT.format(expiryDate));
        EPPDomainRenew domain_renew = new EPPDomainRenew();
        domain_renew.setRequestData(domain_renew_request);
        domain_renew = (EPPDomainRenew)client.processAction(domain_renew);
        return domain_renew.getResponseData();
    }

    public static epp_DomainTransferRsp transferDomain(EPPClient client, String domainName, epp_TransferOpType operation, String authInfo) throws epp_XMLException, epp_Exception, Exception {
        epp_DomainTransferReq domain_transfer_request = new epp_DomainTransferReq();
        epp_Command command_data = new epp_Command();
        command_data.setClientTrid(DomainUtils.getClientTrid(client.getEPPClientID()));
        domain_transfer_request.setCmd(command_data);
        epp_TransferRequest transfer_request = new epp_TransferRequest();
        transfer_request.setOp(operation);
        epp_AuthInfo domain_auth_info = new epp_AuthInfo();
        domain_auth_info.setValue(authInfo);
        transfer_request.setAuthInfo(domain_auth_info);
        domain_transfer_request.setTrans(transfer_request);
        domain_transfer_request.setName(domainName);
        EPPDomainTransfer domain_transfer = new EPPDomainTransfer();
        domain_transfer.setRequestData(domain_transfer_request);
        domain_transfer = (EPPDomainTransfer)client.processAction(domain_transfer);
        return domain_transfer.getResponseData();
    }

    public static epp_DomainUpdateRsp updateDomain(EPPClient client, String domainName, epp_DomainUpdateAddRemove add, epp_DomainUpdateAddRemove remove, epp_DomainUpdateChange change) throws epp_XMLException, epp_Exception, Exception {
        epp_DomainUpdateReq domain_update_request = new epp_DomainUpdateReq();
        epp_Command command_data = new epp_Command();
        command_data.setClientTrid(DomainUtils.getClientTrid(client.getEPPClientID()));
        domain_update_request.setCmd(command_data);
        domain_update_request.setName(domainName);
        domain_update_request.setAdd(add);
        domain_update_request.setRemove(remove);
        domain_update_request.setChange(change);
        EPPDomainUpdate domain_update = new EPPDomainUpdate();
        domain_update.setRequestData(domain_update_request);
        domain_update = (EPPDomainUpdate)client.processAction(domain_update);
        return domain_update.getResponseData();
    }

    public static epp_DomainDeleteRsp deleteDomain(EPPClient client, String domainName) throws epp_XMLException, epp_Exception, Exception {
        epp_DomainDeleteReq domain_delete_request = new epp_DomainDeleteReq();
        epp_Command command_data = new epp_Command();
        command_data.m_client_trid = DomainUtils.getClientTrid(client.getEPPClientID());
        domain_delete_request.m_cmd = command_data;
        domain_delete_request.m_name = domainName;
        EPPDomainDelete domain_delete = new EPPDomainDelete();
        domain_delete.setRequestData(domain_delete_request);
        domain_delete = (EPPDomainDelete)client.processAction(domain_delete);
        return domain_delete.getResponseData();
    }

    public static String getClientTrid(String epp_client_id) {
        return "ABC:" + epp_client_id + ":" + System.currentTimeMillis();
    }
}

