/*
 * Decompiled with CFR 0.152.
 */
package com.tucows.oxrs.epprtk.rtk.example;

import com.tucows.oxrs.epprtk.rtk.EPPClient;
import com.tucows.oxrs.epprtk.rtk.example.ContactUtils;
import com.tucows.oxrs.epprtk.rtk.example.DomainUtils;
import com.tucows.oxrs.epprtk.rtk.example.HostUtils;
import java.util.ArrayList;
import java.util.Iterator;
import org.openrtk.idl.epprtk.domain.epp_DomainTransferRsp;
import org.openrtk.idl.epprtk.epp_TransferOpType;

public class DomainTransferExample {
    private static String USAGE = "Usage: com.tucows.oxrs.epprtk.rtk.example.DomainExample <epp host> <epp port> <client1> <password1> <client2> <password2> <domain name>";
    private static String AUTH_INFO = "123456";

    public static void main(String[] args) {
        if (args.length < 7) {
            System.err.println(USAGE);
            System.exit(1);
        }
        String host = args[0];
        int port = Integer.parseInt(args[1]);
        String user = args[2];
        String password = args[3];
        String user2 = args[4];
        String password2 = args[5];
        String domainName = args[6];
        if (domainName.indexOf(46) == -1) {
            System.err.println("ERROR: Domain name must contain a TLD.");
            System.exit(1);
        }
        String contactId = domainName.substring(0, domainName.indexOf(46)) + "-C";
        ArrayList<String> nameServers = new ArrayList<String>();
        nameServers.add("ns1.example.com");
        nameServers.add("ns2.example.com");
        System.out.println("      HOST: " + host);
        System.out.println("      PORT: " + port);
        System.out.println("   CLIENT1: " + user);
        System.out.println("   CLIENT2: " + user2);
        System.out.println("    DOMAIN: " + domainName);
        System.out.println("   CONTACT: " + contactId);
        Iterator it = nameServers.iterator();
        while (it.hasNext()) {
            System.out.println("NAMESERVER: " + it.next());
        }
        System.out.println();
        try {
            EPPClient client = new EPPClient();
            client.setEPPHostName(host);
            client.setEPPHostPort(port);
            client.setLang("en");
            System.out.println("Connecting to EPP server...");
            client.connectAndGetGreeting();
            System.out.println();
            System.out.println("Logging in as \"" + user + "\"...");
            String trid = DomainTransferExample.getClientTrid(user);
            client.login(trid, user, password);
            System.out.println();
            for (String hostName : nameServers) {
                System.out.println("Checking availability of host \"" + hostName + "\"...");
                if (HostUtils.checkHost(client, hostName).booleanValue()) {
                    System.out.println("  Host \"" + hostName + "\" does not exist. Creating...");
                    HostUtils.createExternalHost(client, hostName);
                } else {
                    System.out.println("  Host \"" + hostName + "\" already exists...");
                }
                System.out.println();
            }
            System.out.println("Checking availability of contact \"" + contactId + "\"...");
            if (ContactUtils.checkContact(client, contactId).booleanValue()) {
                System.out.println("  Contact \"" + contactId + "\" does not exist. Creating...");
                ContactUtils.createContact(client, contactId, AUTH_INFO);
            }
            System.out.println();
            System.out.println("Checking availability of domain \"" + domainName + "\"...");
            if (!DomainUtils.checkDomain(client, domainName).booleanValue()) {
                throw new Exception("Domain \"" + domainName + "\" already exists! Please choose a different name.");
            }
            System.out.println();
            System.out.println("Creating domain \"" + domainName + "\"...");
            DomainUtils.createDomain(client, domainName, 2, nameServers, AUTH_INFO, contactId, contactId, contactId, contactId);
            System.out.println();
            System.out.println("Logging out...");
            client.logout(trid);
            System.out.println("Logging in as \"" + user2 + "\"...");
            trid = DomainTransferExample.getClientTrid(user2);
            client.login(trid, user2, password2);
            System.out.println();
            System.out.println("Requesting transfer of domain \"" + domainName + "\"...");
            epp_DomainTransferRsp domainTransferRsp = DomainUtils.transferDomain(client, domainName, epp_TransferOpType.REQUEST, "123456");
            System.out.println("  Result code:    " + domainTransferRsp.getRsp().getResults()[0].getCode());
            System.out.println("  Result message: " + domainTransferRsp.getRsp().getResults()[0].getMsg());
            System.out.println();
            System.out.println("Logging out...");
            client.logout(trid);
            System.out.println();
            System.out.println("Logging in as \"" + user + "\"...");
            trid = DomainTransferExample.getClientTrid(user);
            client.login(trid, user, password);
            System.out.println();
            System.out.println("Approving transfer of domain \"" + domainName + "\"...");
            domainTransferRsp = DomainUtils.transferDomain(client, domainName, epp_TransferOpType.APPROVE, AUTH_INFO);
            System.out.println("  Result code:    " + domainTransferRsp.getRsp().getResults()[0].getCode());
            System.out.println("  Result message: " + domainTransferRsp.getRsp().getResults()[0].getMsg());
            System.out.println();
            System.out.println("Logging out...");
            client.logout(trid);
            System.out.println();
            System.out.println("Logging in as \"" + user + "\"...");
            trid = DomainTransferExample.getClientTrid(user2);
            client.login(trid, user2, password2);
            System.out.println();
            System.out.println("Deleting domain...");
            DomainUtils.deleteDomain(client, domainName);
            System.out.println();
            System.out.println("Logging out...");
            client.logout(trid);
            System.out.println();
            System.out.println("Disconnecting from EPP server...");
            client.disconnect();
            System.out.println();
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e.getMessage());
            e.printStackTrace(System.err);
        }
    }

    protected static String getClientTrid(String epp_client_id) {
        return "ABC:" + epp_client_id + ":" + System.currentTimeMillis();
    }
}

