/*
 * Decompiled with CFR 0.152.
 */
package com.tucows.oxrs.epprtk.rtk.example;

import com.tucows.oxrs.epprtk.rtk.EPPClient;
import com.tucows.oxrs.epprtk.rtk.RTKBase;
import com.tucows.oxrs.epprtk.rtk.example.ContactUtils;
import com.tucows.oxrs.epprtk.rtk.example.DomainUtils;
import com.tucows.oxrs.epprtk.rtk.example.HostUtils;
import com.tucows.oxrs.epprtk.rtk.example.QueueUtils;
import com.tucows.oxrs.epprtk.rtk.xml.EPPXMLBase;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import org.openrtk.idl.epprtk.domain.epp_DomainCreateRsp;
import org.openrtk.idl.epprtk.domain.epp_DomainDeleteRsp;
import org.openrtk.idl.epprtk.domain.epp_DomainInfoRsp;
import org.openrtk.idl.epprtk.domain.epp_DomainRenewRsp;
import org.openrtk.idl.epprtk.domain.epp_DomainStatus;
import org.openrtk.idl.epprtk.domain.epp_DomainStatusType;
import org.openrtk.idl.epprtk.domain.epp_DomainUpdateAddRemove;
import org.openrtk.idl.epprtk.domain.epp_DomainUpdateChange;
import org.openrtk.idl.epprtk.domain.epp_DomainUpdateRsp;
import org.openrtk.idl.epprtk.epp_AuthInfo;
import org.openrtk.idl.epprtk.epp_Exception;
import org.openrtk.idl.epprtk.epp_Greeting;
import org.openrtk.idl.epprtk.epp_PollOpType;
import org.openrtk.idl.epprtk.epp_PollRsp;
import org.openrtk.idl.epprtk.epp_Result;
import org.openrtk.idl.epprtk.epp_XMLException;

public class DomainExample {
    private static String USAGE = "Usage: com.tucows.oxrs.epprtk.rtk.example.DomainExample <epp host> <epp port> <client> <password> <domain name>";
    private static String AUTH_INFO = "123456";
    private static String NEW_AUTH_INFO = "ABCDEF";
    private static int RENEW_PERIOD = 2;

    public static void main(String[] args) {
        try {
            if (args.length < 5) {
                System.err.println(USAGE);
                System.exit(1);
            }
            String host = args[0];
            int port = Integer.parseInt(args[1]);
            String user = args[2];
            String password = args[3];
            String domainName = args[4];
            ArrayList<String> oldNameServers = new ArrayList<String>();
            oldNameServers.add("ns1.example.com");
            oldNameServers.add("ns2.example.com");
            ArrayList<String> newNameServers = new ArrayList<String>();
            newNameServers.add("ns3.example.com");
            newNameServers.add("ns4.example.com");
            ArrayList<String> allNameServers = new ArrayList<String>();
            allNameServers.addAll(oldNameServers);
            allNameServers.addAll(newNameServers);
            if (domainName.indexOf(46) == -1) {
                System.err.println("ERROR: Domain name must contain a TLD.");
                System.exit(1);
            }
            String contactId = domainName.substring(0, domainName.indexOf(46)) + "-C";
            System.out.println("          HOST: " + host);
            System.out.println("          PORT: " + port);
            System.out.println("        CLIENT: " + user);
            System.out.println("        DOMAIN: " + domainName);
            System.out.println("       CONTACT: " + contactId);
            Iterator it = oldNameServers.iterator();
            while (it.hasNext()) {
                System.out.println("OLD NAMESERVER: " + it.next());
            }
            it = newNameServers.iterator();
            while (it.hasNext()) {
                System.out.println("NEW NAMESERVER: " + it.next());
            }
            System.out.println();
            EPPClient client = new EPPClient(host, port, user, password);
            client.setLang("en");
            System.out.println("Connecting to EPP Server...");
            epp_Greeting greeting = client.connectAndGetGreeting();
            System.out.println("  EPP-Server ID:           " + greeting.getServerId());
            System.out.println("  EPP-Server current date: " + greeting.getServerDate());
            System.out.println("  EPP-Server services:     " + greeting.getSvcMenu());
            System.out.println();
            String client_trid = DomainExample.getClientTrid(user);
            System.out.println("Logging in as \"" + user + "\"...");
            client.login(client_trid);
            System.out.println();
            for (String hostName : allNameServers) {
                System.out.println("Checking availability of host \"" + hostName + "\"...");
                if (HostUtils.checkHost(client, hostName).booleanValue()) {
                    System.out.println("  Host \"" + hostName + "\" does not exist. Creating...");
                    HostUtils.createExternalHost(client, hostName);
                } else {
                    System.out.println("  Host \"" + hostName + "\" already exists.");
                }
                System.out.println();
            }
            System.out.println("Polling \"" + user + "\"'s message queue...");
            epp_PollRsp pollRsp = QueueUtils.pollQueue(client, epp_PollOpType.REQ);
            System.out.println("  Result code:    " + pollRsp.getRsp().getResults()[0].getCode());
            System.out.println("  Result message: " + pollRsp.getRsp().getResults()[0].getMsg());
            System.out.println();
            System.out.println("Checking availability of domains...");
            ArrayList<String> domainNames = new ArrayList<String>();
            domainNames.add(user + "1.info");
            domainNames.add(user + "2.info");
            Map domainsAvail = DomainUtils.checkDomains(client, domainNames);
            for (String domain : domainNames) {
                if (((Boolean)domainsAvail.get(domain)).booleanValue()) {
                    System.out.println("  Domain \"" + domain + "\" is available.");
                    continue;
                }
                System.out.println("  Domain \"" + domain + "\" is not available.");
            }
            System.out.println();
            System.out.println("Checking availability of domain \"" + domainName + "\"...");
            if (!DomainUtils.checkDomain(client, domainName).booleanValue()) {
                throw new Exception("  Domain \"" + domainName + "\" already exists! Please choose a different name.");
            }
            System.out.println("  Domain \"" + domainName + "\" is available.");
            System.out.println();
            System.out.println("Checking availability of contact \"" + contactId + "\"...");
            if (ContactUtils.checkContact(client, contactId).booleanValue()) {
                System.out.println("  Contact \"" + contactId + "\" does not exist. Creating...");
                ContactUtils.createContact(client, contactId, AUTH_INFO);
            }
            System.out.println();
            System.out.println("Creating domain \"" + domainName + "\"...");
            epp_DomainCreateRsp domainCreateRsp = DomainUtils.createDomain(client, domainName, 2, oldNameServers, AUTH_INFO, contactId, contactId, contactId, contactId);
            System.out.println("  Result code:    " + domainCreateRsp.getRsp().getResults()[0].getCode());
            System.out.println("  Result message: " + domainCreateRsp.getRsp().getResults()[0].getMsg());
            System.out.println("  Creation date:  " + RTKBase.UTC_FMT.parse(domainCreateRsp.getCreationDate()));
            System.out.println("  Expiry date:    " + domainCreateRsp.getExpirationDate());
            System.out.println();
            System.out.println("Viewing domain \"" + domainName + "\"...");
            epp_DomainInfoRsp domainInfoRsp = DomainUtils.infoDomain(client, domainName);
            Date domainExpiryDate = RTKBase.UTC_FMT.parse(domainInfoRsp.getExpirationDate());
            System.out.println("  Result code:    " + domainInfoRsp.getRsp().getResults()[0].getCode());
            System.out.println("  Result message: " + domainInfoRsp.getRsp().getResults()[0].getMsg());
            System.out.println("  AuthInfo:       " + domainInfoRsp.getAuthInfo().getValue());
            System.out.println("  Creation date:  " + RTKBase.UTC_FMT.parse(domainInfoRsp.getCreatedDate()));
            System.out.println("  Expiry date:    " + domainExpiryDate);
            System.out.println();
            System.out.println("Updating domain \"" + domainName + "\"...");
            epp_DomainUpdateAddRemove add = new epp_DomainUpdateAddRemove();
            add.setNameServers(EPPXMLBase.convertListToStringArray(newNameServers));
            epp_DomainStatus domainStatus = new epp_DomainStatus();
            domainStatus.setType(epp_DomainStatusType.CLIENT_TRANSFER_PROHIBITED);
            domainStatus.setLang("en");
            domainStatus.setValue("The client did not send money.");
            epp_DomainStatus[] domainStatuses = new epp_DomainStatus[]{domainStatus};
            add.setStatus(domainStatuses);
            epp_DomainUpdateAddRemove remove = new epp_DomainUpdateAddRemove();
            remove.setNameServers(EPPXMLBase.convertListToStringArray(oldNameServers));
            epp_DomainUpdateChange change = new epp_DomainUpdateChange();
            change = new epp_DomainUpdateChange();
            epp_AuthInfo newAuthInfo = new epp_AuthInfo();
            newAuthInfo.setValue(NEW_AUTH_INFO);
            remove.setNameServers(EPPXMLBase.convertListToStringArray(oldNameServers));
            epp_DomainUpdateRsp domainUpdateRsp = DomainUtils.updateDomain(client, domainName, add, remove, change);
            System.out.println("  Result code:    " + domainUpdateRsp.getRsp().getResults()[0].getCode());
            System.out.println("  Result message: " + domainUpdateRsp.getRsp().getResults()[0].getMsg());
            System.out.println();
            System.out.println("Renewing domain \"" + domainName + " for " + RENEW_PERIOD + " years...");
            epp_DomainRenewRsp domainRenewRsp = DomainUtils.renewDomain(client, domainName, RENEW_PERIOD, domainExpiryDate);
            System.out.println("  Result code:    " + domainRenewRsp.getRsp().getResults()[0].getCode());
            System.out.println("  Result message: " + domainRenewRsp.getRsp().getResults()[0].getMsg());
            System.out.println("  Expiry date:    " + RTKBase.UTC_FMT.parse(domainRenewRsp.getExpirationDate()));
            System.out.println();
            System.out.println("Deleting domain \"" + domainName + "...");
            epp_DomainDeleteRsp domainDeleteRsp = DomainUtils.deleteDomain(client, domainName);
            System.out.println("  Result code:    " + domainDeleteRsp.getRsp().getResults()[0].getCode());
            System.out.println("  Result message: " + domainDeleteRsp.getRsp().getResults()[0].getMsg());
            System.out.println();
            System.out.println("Logging out from the EPP Server...");
            client.logout(DomainExample.getClientTrid(user));
            System.out.println();
            System.out.println("Disconnecting from the EPP Server...");
            client.disconnect();
            System.out.println();
        }
        catch (epp_XMLException xcp) {
            System.err.println("ERROR: (epp_XMLException): " + xcp.getErrorMessage());
        }
        catch (epp_Exception xcp) {
            System.err.println("ERROR (epp_Exception):");
            epp_Result[] results = xcp.getDetails();
            System.err.println("  Result: [" + results[0] + "]");
        }
        catch (Exception xcp) {
            System.err.println("ERROR: Exception [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
            xcp.printStackTrace();
        }
    }

    private static String getClientTrid(String epp_client_id) {
        return "ABC:" + epp_client_id + ":" + System.currentTimeMillis();
    }
}

