/*
 * Decompiled with CFR 0.152.
 */
package com.tucows.oxrs.epprtk.rtk.example;

import com.tucows.oxrs.epprtk.rtk.EPPClient;
import com.tucows.oxrs.epprtk.rtk.xml.EPPContactCheck;
import com.tucows.oxrs.epprtk.rtk.xml.EPPContactCreate;
import com.tucows.oxrs.epprtk.rtk.xml.EPPContactDelete;
import com.tucows.oxrs.epprtk.rtk.xml.EPPContactInfo;
import com.tucows.oxrs.epprtk.rtk.xml.EPPContactUpdate;
import com.tucows.oxrs.epprtk.rtk.xml.EPPXMLBase;
import java.util.ArrayList;
import java.util.Random;
import org.openrtk.idl.epprtk.contact.epp_ContactAddress;
import org.openrtk.idl.epprtk.contact.epp_ContactCheckReq;
import org.openrtk.idl.epprtk.contact.epp_ContactCheckRsp;
import org.openrtk.idl.epprtk.contact.epp_ContactCreateReq;
import org.openrtk.idl.epprtk.contact.epp_ContactCreateRsp;
import org.openrtk.idl.epprtk.contact.epp_ContactDeleteReq;
import org.openrtk.idl.epprtk.contact.epp_ContactDeleteRsp;
import org.openrtk.idl.epprtk.contact.epp_ContactInfoReq;
import org.openrtk.idl.epprtk.contact.epp_ContactInfoRsp;
import org.openrtk.idl.epprtk.contact.epp_ContactNameAddress;
import org.openrtk.idl.epprtk.contact.epp_ContactPhone;
import org.openrtk.idl.epprtk.contact.epp_ContactPostalInfoType;
import org.openrtk.idl.epprtk.contact.epp_ContactUpdateChange;
import org.openrtk.idl.epprtk.contact.epp_ContactUpdateReq;
import org.openrtk.idl.epprtk.contact.epp_ContactUpdateRsp;
import org.openrtk.idl.epprtk.epp_AuthInfo;
import org.openrtk.idl.epprtk.epp_AuthInfoType;
import org.openrtk.idl.epprtk.epp_CheckResult;
import org.openrtk.idl.epprtk.epp_Command;
import org.openrtk.idl.epprtk.epp_Exception;
import org.openrtk.idl.epprtk.epp_Greeting;
import org.openrtk.idl.epprtk.epp_Response;
import org.openrtk.idl.epprtk.epp_Result;
import org.openrtk.idl.epprtk.epp_XMLException;

public class ContactExample {
    private static String USAGE = "Usage: com.tucows.oxrs.epprtk.rtk.example.ContactExample epp_contact_name epp_contact_port epp_client_id epp_password";

    public static void main(String[] args) {
        System.out.println("Start of the Contact example");
        epp_AuthInfo contact_auth_info = null;
        epp_Command command_data = null;
        try {
            epp_Result[] results;
            epp_Response response;
            epp_Result[] results2;
            epp_Result[] results3;
            epp_Response response2;
            if (args.length < 4) {
                System.err.println(USAGE);
                System.exit(1);
            }
            String epp_contact_name = args[0];
            String epp_contact_port_string = args[1];
            String epp_client_id = args[2];
            String epp_password = args[3];
            int epp_contact_port = Integer.parseInt(epp_contact_port_string);
            Random rng = new Random();
            String randnum = "" + rng.nextInt() % 999999;
            while ((epp_client_id + randnum).length() > 16) {
                randnum = randnum.substring(0, randnum.length() - 1);
            }
            String default_contact_id = epp_client_id + randnum;
            EPPClient epp_client = new EPPClient(epp_contact_name, epp_contact_port, epp_client_id, epp_password);
            epp_client.setLang("en");
            System.out.println("Connecting to the EPP Server and getting the greeting");
            epp_Greeting greeting = epp_client.connectAndGetGreeting();
            System.out.println("greeting's server: [" + greeting.m_server_id + "]");
            System.out.println("greeting's server-date: [" + greeting.m_server_date + "]");
            System.out.println("greeting's service menu: [" + greeting.getSvcMenu() + "]");
            System.out.println();
            String client_trid = ContactExample.getClientTrid(epp_client_id);
            System.out.println("Logging into the EPP Server");
            epp_client.login(client_trid);
            try {
                System.out.println("Creating the Contact Check command");
                epp_ContactCheckReq contact_check_request = new epp_ContactCheckReq();
                command_data = new epp_Command();
                command_data.m_client_trid = ContactExample.getClientTrid(epp_client_id);
                contact_check_request.m_cmd = command_data;
                ArrayList<String> contact_list = new ArrayList<String>();
                contact_list.add("C100-LRMS");
                contact_list.add("C102-LRMS");
                contact_list.add("C999-LRMS");
                contact_check_request.m_ids = EPPXMLBase.convertListToStringArray(contact_list);
                EPPContactCheck contact_check = new EPPContactCheck();
                contact_check.setRequestData(contact_check_request);
                contact_check = (EPPContactCheck)epp_client.processAction(contact_check);
                epp_ContactCheckRsp contact_check_response = contact_check.getResponseData();
                response2 = contact_check_response.m_rsp;
                results3 = response2.m_results;
                System.out.println("ContactCheck results: [" + results3[0].m_code + "] [" + results3[0].m_msg + "]");
                epp_CheckResult[] check_results = contact_check_response.m_results;
                System.out.println("ContactCheck results: contact [C100-LRMS] available? [" + EPPXMLBase.getAvailResultFor(check_results, "C100-LRMS") + "]");
                System.out.println("ContactCheck results: contact [C102-LRMS] available? [" + EPPXMLBase.getAvailResultFor(check_results, "C102-LRMS") + "]");
                System.out.println("ContactCheck results: contact [C999-LRMS] available? [" + EPPXMLBase.getAvailResultFor(check_results, "C999-LRMS") + "]");
            }
            catch (epp_XMLException xcp) {
                System.err.println("epp_XMLException! [" + xcp.m_error_message + "]");
            }
            catch (epp_Exception xcp) {
                System.err.println("epp_Exception!");
                results2 = xcp.m_details;
                System.err.println("\tcode: [" + results2[0].m_code + "] lang: [" + results2[0].m_lang + "] msg: [" + results2[0].m_msg + "]");
                if (results2[0].m_values != null && results2[0].m_values.length > 0) {
                    System.err.println("\tvalue: [" + results2[0].m_values[0] + "]");
                }
            }
            catch (Exception xcp) {
                System.err.println("Contact Check failed! [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
                xcp.printStackTrace();
            }
            try {
                System.out.println("Creating the Contact Create command");
                epp_ContactCreateReq contact_create_request = new epp_ContactCreateReq();
                command_data = new epp_Command();
                command_data.m_client_trid = ContactExample.getClientTrid(epp_client_id);
                contact_create_request.m_cmd = command_data;
                contact_create_request.m_id = default_contact_id;
                epp_ContactNameAddress[] name_address = new epp_ContactNameAddress[]{new epp_ContactNameAddress()};
                name_address[0].setType(epp_ContactPostalInfoType.LOC);
                name_address[0].setName("\u7528\u6237\u540d\u5b57");
                name_address[0].setOrg("\u516c\u53f8\u540d\u5b57");
                name_address[0].setAddress(new epp_ContactAddress());
                name_address[0].getAddress().setStreet1("\u9a6c\u8def");
                name_address[0].getAddress().setCity("\u9999\u6e2f");
                name_address[0].getAddress().setStateProvince("\u9999\u6e2f");
                name_address[0].getAddress().setPostalCode("Z1Z1Z1");
                name_address[0].getAddress().setCountryCode("CA");
                contact_create_request.setAddresses(name_address);
                contact_create_request.setVoice(new epp_ContactPhone("1234", "+1.4165559999"));
                contact_create_request.setFax(new epp_ContactPhone("9876", "+1.4165558888"));
                contact_create_request.setEmail("jdoe@company.info");
                contact_auth_info = new epp_AuthInfo();
                contact_auth_info.setValue("test_contact");
                contact_auth_info.setType(epp_AuthInfoType.PW);
                contact_create_request.setAuthInfo(contact_auth_info);
                EPPContactCreate contact_create = new EPPContactCreate();
                contact_create.setRequestData(contact_create_request);
                contact_create = (EPPContactCreate)epp_client.processAction(contact_create);
                epp_ContactCreateRsp contact_create_response = contact_create.getResponseData();
                response2 = contact_create_response.m_rsp;
                results3 = response2.m_results;
                System.out.println("ContactCreate results: [" + results3[0].m_code + "] [" + results3[0].m_msg + "]");
                System.out.println("ContactCreate results: contact id [" + contact_create_response.m_id + "]");
            }
            catch (epp_XMLException xcp) {
                System.err.println("epp_XMLException! [" + xcp.m_error_message + "]");
            }
            catch (epp_Exception xcp) {
                System.err.println("epp_Exception!");
                results2 = xcp.m_details;
                System.err.println("\tresults: " + results2[0] + "]");
            }
            catch (Exception xcp) {
                System.err.println("Contact Create failed! [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
                xcp.printStackTrace();
            }
            try {
                System.out.println("Creating the Contact Info command");
                epp_ContactInfoReq contact_info_request = new epp_ContactInfoReq();
                command_data = new epp_Command();
                command_data.m_client_trid = ContactExample.getClientTrid(epp_client_id);
                contact_info_request.m_cmd = command_data;
                contact_info_request.m_id = default_contact_id;
                EPPContactInfo contact_info = new EPPContactInfo();
                contact_info.setRequestData(contact_info_request);
                contact_info = (EPPContactInfo)epp_client.processAction(contact_info);
                epp_ContactInfoRsp contact_info_response = contact_info.getResponseData();
                response = contact_info_response.m_rsp;
                results = response.m_results;
                contact_auth_info = contact_info_response.m_auth_info;
                System.out.println("ContactInfo results: [" + results[0].m_code + "] [" + results[0].m_msg + "]");
                System.out.println("              Voice: [" + contact_info_response.m_voice + "]");
                System.out.println("                Fax: [" + contact_info_response.m_fax + "]");
                System.out.println("          Auth Info: [" + contact_auth_info.m_value + "]");
            }
            catch (epp_XMLException xcp) {
                System.err.println("epp_XMLException! [" + xcp.m_error_message + "]");
            }
            catch (epp_Exception xcp) {
                System.err.println("epp_Exception!");
                results2 = xcp.m_details;
                System.err.println("\tresults: " + results2[0] + "]");
            }
            catch (Exception xcp) {
                System.err.println("Contact Info failed! [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
                xcp.printStackTrace();
            }
            try {
                System.out.println("Creating the Contact Update command");
                epp_ContactUpdateReq contact_update_request = new epp_ContactUpdateReq();
                command_data = new epp_Command();
                command_data.m_client_trid = ContactExample.getClientTrid(epp_client_id);
                contact_update_request.m_cmd = command_data;
                contact_update_request.m_id = default_contact_id;
                epp_ContactUpdateChange contact_update_change = new epp_ContactUpdateChange();
                epp_ContactNameAddress[] name_address = new epp_ContactNameAddress[]{new epp_ContactNameAddress()};
                name_address[0].setType(epp_ContactPostalInfoType.INT);
                name_address[0].setName("Jane Doe");
                name_address[0].setOrg("ACME Systems");
                name_address[0].setAddress(new epp_ContactAddress());
                name_address[0].getAddress().setStreet1("999 Front St");
                name_address[0].getAddress().setCity("Townsville");
                name_address[0].getAddress().setPostalCode("A9A9A9");
                name_address[0].getAddress().setCountryCode("CA");
                contact_update_change.setAddresses(name_address);
                contact_update_change.setFax(new epp_ContactPhone("", ""));
                epp_AuthInfo contact_auth_info_new = new epp_AuthInfo();
                contact_auth_info_new.setValue("test_contact_new");
                contact_update_change.setAuthInfo(contact_auth_info_new);
                contact_auth_info = contact_auth_info_new;
                contact_update_request.m_change = contact_update_change;
                EPPContactUpdate contact_update = new EPPContactUpdate();
                contact_update.setRequestData(contact_update_request);
                contact_update = (EPPContactUpdate)epp_client.processAction(contact_update);
                epp_ContactUpdateRsp contact_update_response = contact_update.getResponseData();
                epp_Response response3 = contact_update_response.m_rsp;
                epp_Result[] results4 = response3.m_results;
                System.out.println("ContactUpdate results: [" + results4[0].m_code + "] [" + results4[0].m_msg + "]");
            }
            catch (epp_XMLException xcp) {
                System.err.println("epp_XMLException! [" + xcp.m_error_message + "]");
            }
            catch (epp_Exception xcp) {
                System.err.println("epp_Exception!");
                results2 = xcp.m_details;
                System.err.println("\tresults: " + results2[0] + "]");
            }
            catch (Exception xcp) {
                System.err.println("Contact Update failed! [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
                xcp.printStackTrace();
            }
            try {
                System.out.println("Creating the Contact Delete command");
                epp_ContactDeleteReq contact_delete_request = new epp_ContactDeleteReq();
                command_data = new epp_Command();
                command_data.m_client_trid = ContactExample.getClientTrid(epp_client_id);
                contact_delete_request.m_cmd = command_data;
                contact_delete_request.m_id = default_contact_id;
                EPPContactDelete contact_delete = new EPPContactDelete();
                contact_delete.setRequestData(contact_delete_request);
                contact_delete = (EPPContactDelete)epp_client.processAction(contact_delete);
                epp_ContactDeleteRsp contact_delete_response = contact_delete.getResponseData();
                response = contact_delete_response.m_rsp;
                results = response.m_results;
                System.out.println("ContactDelete results: [" + results[0].m_code + "] [" + results[0].m_msg + "]");
            }
            catch (epp_XMLException xcp) {
                System.err.println("epp_XMLException! [" + xcp.m_error_message + "]");
            }
            catch (epp_Exception xcp) {
                System.err.println("epp_Exception!");
                results2 = xcp.m_details;
                System.err.println("\tresults: " + results2[0] + "]");
            }
            catch (Exception xcp) {
                System.err.println("Contact Delete failed! [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
                xcp.printStackTrace();
            }
            System.out.println("Logging out from the EPP Server");
            epp_client.logout(ContactExample.getClientTrid(epp_client_id));
            System.out.println("Disconnecting from the EPP Server");
            epp_client.disconnect();
        }
        catch (epp_XMLException xcp) {
            System.err.println("epp_XMLException! [" + xcp.m_error_message + "]");
        }
        catch (epp_Exception xcp) {
            System.err.println("epp_Exception!");
            epp_Result[] results = xcp.m_details;
            System.err.println("\tresults: " + results[0] + "]");
        }
        catch (Exception xcp) {
            System.err.println("Exception! [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
            xcp.printStackTrace();
        }
    }

    protected static String getClientTrid(String epp_client_id) {
        return "ABC:" + epp_client_id + ":" + System.currentTimeMillis();
    }
}

