/*
 * Decompiled with CFR 0.152.
 */
package com.tucows.oxrs.epp0705.rtk.xml;

import com.tucows.oxrs.epp0705.rtk.xml.EPPHostBase;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.xerces.dom.DocumentImpl;
import org.openrtk.idl.epp0705.epp_Command;
import org.openrtk.idl.epp0705.epp_Exception;
import org.openrtk.idl.epp0705.epp_XMLException;
import org.openrtk.idl.epp0705.host.epp_HostAddress;
import org.openrtk.idl.epp0705.host.epp_HostStatus;
import org.openrtk.idl.epp0705.host.epp_HostUpdate;
import org.openrtk.idl.epp0705.host.epp_HostUpdateAddRemove;
import org.openrtk.idl.epp0705.host.epp_HostUpdateReq;
import org.openrtk.idl.epp0705.host.epp_HostUpdateRsp;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class EPPHostUpdate
extends EPPHostBase
implements epp_HostUpdate {
    private epp_HostUpdateReq action_request_;
    private epp_HostUpdateRsp action_response_;

    public EPPHostUpdate() {
    }

    public EPPHostUpdate(String xml) throws epp_XMLException, epp_Exception {
        String method_name = "EPPHostUpdate(String)";
        this.debug(2, method_name, "xml is [" + xml + "]");
        this.fromXML(xml);
    }

    @Override
    public void setRequestData(epp_HostUpdateReq value) {
        this.action_request_ = value;
    }

    @Override
    public epp_HostUpdateRsp getResponseData() {
        return this.action_response_;
    }

    @Override
    public String toXML() throws epp_XMLException {
        String request_xml;
        Element remove_element;
        String method_name = "buildRequestXML()";
        this.debug(3, method_name, "Entered");
        if (this.action_request_ == null || this.action_request_.m_cmd == null || this.action_request_.m_name == null) {
            throw new epp_XMLException("missing request data or host name");
        }
        DocumentImpl doc = new DocumentImpl();
        Element root = this.createDocRoot((Document)doc);
        Element command = doc.createElement("command");
        Element update = doc.createElement("update");
        epp_Command command_data = this.action_request_.m_cmd;
        Element host_update = doc.createElement("host:update");
        this.setCommonAttributes(host_update);
        this.addXMLElement((Document)doc, host_update, "host:name", this.action_request_.m_name);
        Element add_element = this.getAddRemoveElement((Document)doc, this.action_request_.m_add, "host:add");
        if (add_element != null) {
            host_update.appendChild(add_element);
        }
        if ((remove_element = this.getAddRemoveElement((Document)doc, this.action_request_.m_remove, "host:rem")) != null) {
            host_update.appendChild(remove_element);
        }
        if (this.action_request_.m_change != null && this.action_request_.m_change.m_name != null) {
            Element change_element = doc.createElement("host:chg");
            this.addXMLElement((Document)doc, change_element, "host:name", this.action_request_.m_change.m_name);
            host_update.appendChild(change_element);
        }
        update.appendChild(host_update);
        command.appendChild(update);
        this.prepareExtensionElement((Document)doc, command, command_data.m_extensions);
        if (command_data.m_client_trid != null) {
            this.addXMLElement((Document)doc, command, "clTRID", command_data.m_client_trid);
        }
        root.appendChild(command);
        doc.appendChild(root);
        try {
            request_xml = this.createXMLFromDoc((Document)doc);
        }
        catch (IOException xcp) {
            throw new epp_XMLException("IOException in building XML [" + xcp.getMessage() + "]");
        }
        this.debug(3, method_name, "Leaving");
        return request_xml;
    }

    private Element getAddRemoveElement(Document doc, epp_HostUpdateAddRemove add_remove_items, String tag_name) throws epp_XMLException {
        String method_name = "getAddRemoveElement(Document, epp_HostUpdateAddRemove, String)";
        this.debug(3, method_name, "Entered");
        Element add_remove_element = null;
        if (add_remove_items != null) {
            List<Object> status_list;
            if (add_remove_items.m_addresses != null && add_remove_items.m_addresses.length > 0) {
                add_remove_element = doc.createElement(tag_name);
                status_list = Arrays.asList(add_remove_items.m_addresses);
                for (epp_HostAddress epp_HostAddress2 : status_list) {
                    Element addr_element = this.addXMLElement(doc, add_remove_element, "host:addr", epp_HostAddress2.m_ip);
                    addr_element.setAttribute("ip", epp_HostAddress2.m_type.toString());
                }
            }
            if (add_remove_items.m_status != null && add_remove_items.m_status.length > 0) {
                if (add_remove_element == null) {
                    add_remove_element = doc.createElement(tag_name);
                }
                status_list = Arrays.asList(add_remove_items.m_status);
                for (epp_HostStatus epp_HostStatus2 : status_list) {
                    Element status_element = this.addXMLElement(doc, add_remove_element, "host:status", epp_HostStatus2.m_value);
                    status_element.setAttribute("s", epp_HostStatus2.m_type.toString());
                    if (epp_HostStatus2.m_lang == null) continue;
                    status_element.setAttribute("lang", epp_HostStatus2.m_lang);
                }
            }
        }
        this.debug(3, method_name, "Leaving");
        return add_remove_element;
    }

    @Override
    public void fromXML(String xml) throws epp_XMLException, epp_Exception {
        String method_name = "fromXML()";
        this.debug(3, method_name, "Entered");
        this.xml_ = xml;
        try {
            Element epp_node = this.getDocumentElement();
            Node response_node = epp_node.getElementsByTagName("response").item(0);
            if (response_node == null) {
                throw new epp_XMLException("unparsable or missing response");
            }
            this.action_response_ = new epp_HostUpdateRsp();
            this.action_response_.m_rsp = this.parseGenericResult(response_node);
            if (this.action_response_.m_rsp.m_results[0].m_code >= 2000) {
                throw new epp_Exception(this.action_response_.m_rsp.m_results);
            }
        }
        catch (SAXException xcp) {
            this.debug(1, method_name, xcp);
            throw new epp_XMLException("unable to parse xml [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
        }
        catch (IOException xcp) {
            this.debug(1, method_name, xcp);
            throw new epp_XMLException("unable to parse xml [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
        }
    }
}

