/*
 * Decompiled with CFR 0.152.
 */
package com.tucows.oxrs.epp0705.rtk.xml;

import com.tucows.oxrs.epp0705.rtk.xml.EPPHostBase;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.xerces.dom.DocumentImpl;
import org.openrtk.idl.epp0705.epp_Command;
import org.openrtk.idl.epp0705.epp_Exception;
import org.openrtk.idl.epp0705.epp_XMLException;
import org.openrtk.idl.epp0705.host.epp_HostAddress;
import org.openrtk.idl.epp0705.host.epp_HostCreate;
import org.openrtk.idl.epp0705.host.epp_HostCreateReq;
import org.openrtk.idl.epp0705.host.epp_HostCreateRsp;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class EPPHostCreate
extends EPPHostBase
implements epp_HostCreate {
    private epp_HostCreateReq action_request_;
    private epp_HostCreateRsp action_response_;

    public EPPHostCreate() {
    }

    public EPPHostCreate(String xml) throws epp_XMLException, epp_Exception {
        String method_name = "EPPHostCreate(String)";
        this.debug(2, method_name, "xml is [" + xml + "]");
        this.fromXML(xml);
    }

    @Override
    public void setRequestData(epp_HostCreateReq value) {
        this.action_request_ = value;
    }

    @Override
    public epp_HostCreateRsp getResponseData() {
        return this.action_response_;
    }

    @Override
    public String toXML() throws epp_XMLException {
        String request_xml;
        String method_name = "buildRequestXML(EPPTransID)";
        this.debug(3, method_name, "Entered");
        if (this.action_request_ == null || this.action_request_.m_cmd == null || this.action_request_.m_name == null) {
            throw new epp_XMLException("missing request data or host name");
        }
        DocumentImpl doc = new DocumentImpl();
        Element root = this.createDocRoot((Document)doc);
        Element command = doc.createElement("command");
        Element create = doc.createElement("create");
        epp_Command command_data = this.action_request_.m_cmd;
        Element host_create = doc.createElement("host:create");
        this.setCommonAttributes(host_create);
        this.addXMLElement((Document)doc, host_create, "host:name", this.action_request_.m_name);
        if (this.action_request_.m_addresses != null && this.action_request_.m_addresses.length > 0) {
            List<epp_HostAddress> addresses = Arrays.asList(this.action_request_.m_addresses);
            for (epp_HostAddress address : addresses) {
                Element addr_element = this.addXMLElement((Document)doc, host_create, "host:addr", address.m_ip);
                addr_element.setAttribute("ip", address.m_type.toString());
            }
        }
        create.appendChild(host_create);
        command.appendChild(create);
        this.prepareExtensionElement((Document)doc, command, command_data.m_extensions);
        if (command_data.m_client_trid != null) {
            this.addXMLElement((Document)doc, command, "clTRID", command_data.m_client_trid);
        }
        root.appendChild(command);
        doc.appendChild(root);
        try {
            request_xml = this.createXMLFromDoc((Document)doc);
        }
        catch (IOException xcp) {
            throw new epp_XMLException("IOException in building XML [" + xcp.getMessage() + "]");
        }
        this.debug(3, method_name, "Leaving");
        return request_xml;
    }

    @Override
    public void fromXML(String xml) throws epp_XMLException, epp_Exception {
        String method_name = "fromXML()";
        this.debug(3, method_name, "Entered");
        this.xml_ = xml;
        try {
            Element epp_node = this.getDocumentElement();
            Node response_node = epp_node.getElementsByTagName("response").item(0);
            if (response_node == null) {
                throw new epp_XMLException("unparsable or missing response");
            }
            this.action_response_ = new epp_HostCreateRsp();
            this.action_response_.m_rsp = this.parseGenericResult(response_node);
            if (this.action_response_.m_rsp.m_results[0].m_code >= 2000) {
                throw new epp_Exception(this.action_response_.m_rsp.m_results);
            }
            Element response_data_element = this.getElement(response_node.getChildNodes(), "resData");
            if (response_data_element == null) {
                throw new epp_XMLException("response is missing the resData element");
            }
            NodeList host_create_data_list = response_data_element.getElementsByTagName("host:creData").item(0).getChildNodes();
            this.debug(2, method_name, "host:creData's node count [" + host_create_data_list.getLength() + "]");
            if (host_create_data_list == null || host_create_data_list.getLength() == 0) {
                throw new epp_XMLException("missing host create response data");
            }
            for (int count = 0; count < host_create_data_list.getLength(); ++count) {
                Node a_node = host_create_data_list.item(count);
                if (a_node.getNodeName().equals("host:name")) {
                    this.action_response_.m_name = a_node.getFirstChild().getNodeValue();
                }
                if (!a_node.getNodeName().equals("host:crDate")) continue;
                this.action_response_.m_creation_date = a_node.getFirstChild().getNodeValue();
            }
        }
        catch (SAXException xcp) {
            this.debug(1, method_name, xcp);
            throw new epp_XMLException("unable to parse xml [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
        }
        catch (IOException xcp) {
            this.debug(1, method_name, xcp);
            throw new epp_XMLException("unable to parse xml [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
        }
    }
}

