/*
 * Decompiled with CFR 0.152.
 */
package com.tucows.oxrs.epp0705.rtk.xml;

import com.tucows.oxrs.epp0705.rtk.xml.EPPXMLBase;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import org.apache.xerces.dom.DocumentImpl;
import org.openrtk.idl.epp0705.epp_DataCollectionPolicy;
import org.openrtk.idl.epp0705.epp_Exception;
import org.openrtk.idl.epp0705.epp_Greeting;
import org.openrtk.idl.epp0705.epp_Hello;
import org.openrtk.idl.epp0705.epp_ServiceMenu;
import org.openrtk.idl.epp0705.epp_XMLException;
import org.openrtk.idl.epp0705.epp_dcpAccessType;
import org.openrtk.idl.epp0705.epp_dcpExpiry;
import org.openrtk.idl.epp0705.epp_dcpExpiryType;
import org.openrtk.idl.epp0705.epp_dcpPurposeType;
import org.openrtk.idl.epp0705.epp_dcpRecipient;
import org.openrtk.idl.epp0705.epp_dcpRecipientType;
import org.openrtk.idl.epp0705.epp_dcpRetentionType;
import org.openrtk.idl.epp0705.epp_dcpStatement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class EPPGreeting
extends EPPXMLBase
implements epp_Hello {
    private epp_Greeting greeting_;
    private static Hashtable dcp_access_string_to_type_hash_ = null;
    private static Hashtable dcp_purpose_string_to_type_hash_ = null;
    private static Hashtable dcp_recipient_string_to_type_hash_ = null;
    private static Hashtable dcp_retention_string_to_type_hash_ = null;
    private static Hashtable dcp_expiry_string_to_type_hash_ = null;

    public EPPGreeting() {
    }

    public EPPGreeting(String xml) throws epp_XMLException, epp_Exception {
        String method_name = "EPPGreeting(String)";
        this.debug(2, method_name, "xml is [" + xml + "]");
        this.fromXML(xml);
    }

    @Override
    public epp_Greeting getResponseData() {
        return this.greeting_;
    }

    @Override
    public String toXML() throws epp_XMLException {
        String request_xml;
        String method_name = "buildRequestXML()";
        this.debug(3, method_name, "Entered");
        DocumentImpl doc = new DocumentImpl();
        Element root = this.createDocRoot((Document)doc);
        Element hello = doc.createElement("hello");
        root.appendChild(hello);
        doc.appendChild(root);
        try {
            request_xml = this.createXMLFromDoc((Document)doc);
        }
        catch (IOException xcp) {
            throw new epp_XMLException("IOException in building XML [" + xcp.getMessage() + "]");
        }
        this.debug(3, method_name, "Leaving");
        return request_xml;
    }

    @Override
    public void fromXML(String xml) throws epp_XMLException, epp_Exception {
        String method_name = "fromXML()";
        this.debug(3, method_name, "Entered");
        this.xml_ = xml;
        try {
            NodeList inner_nodes;
            this.greeting_ = new epp_Greeting();
            Element epp_node = this.getDocumentElement();
            NodeList greeting_nodes = epp_node.getElementsByTagName("greeting").item(0).getChildNodes();
            if (greeting_nodes == null || greeting_nodes.getLength() == 0) {
                throw new epp_XMLException("unparsable or missing greeting");
            }
            Node service_menu = null;
            Node dcp = null;
            for (int count = 0; count < greeting_nodes.getLength(); ++count) {
                Node a_node = greeting_nodes.item(count);
                if (a_node.getNodeName().equals("svID")) {
                    this.greeting_.m_server_id = a_node.getFirstChild().getNodeValue();
                }
                if (a_node.getNodeName().equals("svDate")) {
                    this.greeting_.m_server_date = a_node.getFirstChild().getNodeValue();
                }
                if (a_node.getNodeName().equals("svcMenu")) {
                    service_menu = a_node;
                }
                if (!a_node.getNodeName().equals("dcp")) continue;
                dcp = a_node;
            }
            if (service_menu != null) {
                epp_ServiceMenu svc_menu = new epp_ServiceMenu();
                inner_nodes = service_menu.getChildNodes();
                ArrayList<String> service_list = new ArrayList<String>();
                ArrayList<String> extension_list = new ArrayList<String>();
                ArrayList<String> version_list = new ArrayList<String>();
                ArrayList<String> lang_list = new ArrayList<String>();
                Node service_extension = null;
                for (int count = 0; count < inner_nodes.getLength(); ++count) {
                    Node a_node = inner_nodes.item(count);
                    if (a_node.getNodeName().equals("version")) {
                        version_list.add(a_node.getFirstChild().getNodeValue());
                    }
                    if (a_node.getNodeName().equals("lang")) {
                        lang_list.add(a_node.getFirstChild().getNodeValue());
                    }
                    if (a_node.getNodeName().equals("svcExtension")) {
                        service_extension = a_node;
                    }
                    if (!a_node.getNodeName().equals("objURI")) continue;
                    service_list.add(a_node.getFirstChild().getNodeValue());
                }
                svc_menu.m_versions = EPPGreeting.convertListToStringArray(version_list);
                svc_menu.m_langs = EPPGreeting.convertListToStringArray(lang_list);
                svc_menu.m_services = EPPGreeting.convertListToStringArray(service_list);
                if (service_extension != null) {
                    NodeList ext_nodes = service_extension.getChildNodes();
                    for (int count = 0; count < ext_nodes.getLength(); ++count) {
                        Node a_node = ext_nodes.item(count);
                        if (!a_node.getNodeName().equals("extURI")) continue;
                        extension_list.add(a_node.getFirstChild().getNodeValue());
                    }
                }
                if (extension_list.size() > 0) {
                    svc_menu.m_extensions = EPPGreeting.convertListToStringArray(extension_list);
                }
                this.greeting_.m_svc_menu = svc_menu;
            }
            if (dcp != null) {
                epp_DataCollectionPolicy dc_policy = new epp_DataCollectionPolicy();
                inner_nodes = dcp.getChildNodes();
                ArrayList<epp_dcpStatement> statement_list = new ArrayList<epp_dcpStatement>();
                this.debug(3, method_name, "Going through the DCP elements");
                for (int count = 0; count < inner_nodes.getLength(); ++count) {
                    String type;
                    int i;
                    String type2;
                    Node a_node = inner_nodes.item(count);
                    this.debug(3, method_name, "DCP node name: [" + a_node.getNodeName() + "]");
                    if (a_node.getNodeName().equals("access")) {
                        type2 = a_node.getFirstChild().getNodeName().toLowerCase();
                        dc_policy.m_access = (epp_dcpAccessType)dcp_access_string_to_type_hash_.get(type2);
                    }
                    if (a_node.getNodeName().equals("expiry")) {
                        type2 = a_node.getFirstChild().getNodeName().toLowerCase();
                        dc_policy.m_expiry = new epp_dcpExpiry();
                        dc_policy.m_expiry.m_type = (epp_dcpExpiryType)dcp_expiry_string_to_type_hash_.get(type2);
                        dc_policy.m_expiry.m_value = a_node.getFirstChild().getNodeValue();
                    }
                    if (!a_node.getNodeName().equals("statement")) continue;
                    NodeList s_inner_nodes = a_node.getChildNodes();
                    NodeList purpose_nodes = null;
                    NodeList recipients_nodes = null;
                    ArrayList purpose_list = new ArrayList();
                    ArrayList<epp_dcpRecipient> recipients_list = new ArrayList<epp_dcpRecipient>();
                    epp_dcpStatement dcp_statement = new epp_dcpStatement();
                    for (i = 0; i < s_inner_nodes.getLength(); ++i) {
                        Node s_node = s_inner_nodes.item(i);
                        if (s_node.getNodeName().equals("purpose")) {
                            purpose_nodes = s_node.getChildNodes();
                        }
                        if (s_node.getNodeName().equals("recipient")) {
                            recipients_nodes = s_node.getChildNodes();
                        }
                        if (!s_node.getNodeName().equals("retention")) continue;
                        String type3 = s_node.getFirstChild().getNodeName().toLowerCase();
                        dcp_statement.m_retention = (epp_dcpRetentionType)dcp_retention_string_to_type_hash_.get(type3);
                    }
                    if (purpose_nodes != null) {
                        for (i = 0; i < purpose_nodes.getLength(); ++i) {
                            type = purpose_nodes.item(i).getNodeName().toLowerCase();
                            purpose_list.add(dcp_purpose_string_to_type_hash_.get(type));
                        }
                        dcp_statement.m_purposes = (epp_dcpPurposeType[])EPPGreeting.convertListToArray(epp_dcpPurposeType.class, purpose_list);
                    }
                    if (recipients_nodes != null) {
                        for (i = 0; i < recipients_nodes.getLength(); ++i) {
                            type = recipients_nodes.item(i).getNodeName().toLowerCase();
                            epp_dcpRecipient recip = new epp_dcpRecipient((epp_dcpRecipientType)dcp_recipient_string_to_type_hash_.get(type), null);
                            recipients_list.add(recip);
                        }
                        dcp_statement.m_recipients = (epp_dcpRecipient[])EPPGreeting.convertListToArray(epp_dcpRecipient.class, recipients_list);
                    }
                    statement_list.add(dcp_statement);
                }
                dc_policy.m_statements = (epp_dcpStatement[])EPPGreeting.convertListToArray(epp_dcpStatement.class, statement_list);
                this.greeting_.m_dcp = dc_policy;
            }
        }
        catch (SAXException xcp) {
            this.debug(1, method_name, xcp);
            throw new epp_XMLException("unable to parse xml [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
        }
        catch (IOException xcp) {
            this.debug(1, method_name, xcp);
            throw new epp_XMLException("unable to parse xml [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
        }
    }

    static {
        dcp_access_string_to_type_hash_ = new Hashtable();
        dcp_access_string_to_type_hash_.put("all", epp_dcpAccessType.ALL);
        dcp_access_string_to_type_hash_.put("none", epp_dcpAccessType.NONE_ACCESS);
        dcp_access_string_to_type_hash_.put("null", epp_dcpAccessType.NULL_ACCESS);
        dcp_access_string_to_type_hash_.put("other", epp_dcpAccessType.OTHER);
        dcp_access_string_to_type_hash_.put("personal", epp_dcpAccessType.PERSONAL);
        dcp_access_string_to_type_hash_.put("personalAndOther", epp_dcpAccessType.PERSONAL);
        dcp_purpose_string_to_type_hash_ = new Hashtable();
        dcp_purpose_string_to_type_hash_.put("admin", epp_dcpPurposeType.ADMIN);
        dcp_purpose_string_to_type_hash_.put("contact", epp_dcpPurposeType.CONTACT);
        dcp_purpose_string_to_type_hash_.put("other", epp_dcpPurposeType.OTHER_PURPOSE);
        dcp_purpose_string_to_type_hash_.put("prov", epp_dcpPurposeType.PROV);
        dcp_recipient_string_to_type_hash_ = new Hashtable();
        dcp_recipient_string_to_type_hash_.put("other", epp_dcpRecipientType.OTHER_RECIPIENT);
        dcp_recipient_string_to_type_hash_.put("ours", epp_dcpRecipientType.OURS);
        dcp_recipient_string_to_type_hash_.put("public", epp_dcpRecipientType.PUBLIK);
        dcp_recipient_string_to_type_hash_.put("same", epp_dcpRecipientType.SAME);
        dcp_recipient_string_to_type_hash_.put("unrelated", epp_dcpRecipientType.UNRELATED);
        dcp_retention_string_to_type_hash_ = new Hashtable();
        dcp_retention_string_to_type_hash_.put("business", epp_dcpRetentionType.BUSINESS);
        dcp_retention_string_to_type_hash_.put("indefinite", epp_dcpRetentionType.INDEFINITE);
        dcp_retention_string_to_type_hash_.put("legal", epp_dcpRetentionType.LEGAL);
        dcp_retention_string_to_type_hash_.put("none", epp_dcpRetentionType.NONE);
        dcp_retention_string_to_type_hash_.put("stated", epp_dcpRetentionType.STATED);
        dcp_expiry_string_to_type_hash_ = new Hashtable();
        dcp_expiry_string_to_type_hash_.put("absolute", epp_dcpExpiryType.ABSOLUTE);
        dcp_expiry_string_to_type_hash_.put("relative", epp_dcpExpiryType.RELATIVE);
    }
}

