/*
 * Decompiled with CFR 0.152.
 */
package com.tucows.oxrs.epp0705.rtk.xml;

import com.tucows.oxrs.epp0705.rtk.xml.EPPDomainBase;
import java.io.IOException;
import org.apache.xerces.dom.DocumentImpl;
import org.openrtk.idl.epp0705.domain.epp_DomainPeriod;
import org.openrtk.idl.epp0705.domain.epp_DomainTransfer;
import org.openrtk.idl.epp0705.domain.epp_DomainTransferReq;
import org.openrtk.idl.epp0705.domain.epp_DomainTransferRsp;
import org.openrtk.idl.epp0705.epp_Command;
import org.openrtk.idl.epp0705.epp_Exception;
import org.openrtk.idl.epp0705.epp_TransferOpType;
import org.openrtk.idl.epp0705.epp_TransferRequest;
import org.openrtk.idl.epp0705.epp_XMLException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class EPPDomainTransfer
extends EPPDomainBase
implements epp_DomainTransfer {
    private epp_DomainTransferReq action_request_;
    private epp_DomainTransferRsp action_response_;

    public EPPDomainTransfer() {
    }

    public EPPDomainTransfer(String xml) throws epp_XMLException, epp_Exception {
        String method_name = "EPPDomainTransfer(String)";
        this.debug(2, method_name, "xml is [" + xml + "]");
        this.fromXML(xml);
    }

    @Override
    public void setRequestData(epp_DomainTransferReq value) {
        this.action_request_ = value;
    }

    @Override
    public epp_DomainTransferRsp getResponseData() {
        return this.action_response_;
    }

    @Override
    public String toXML() throws epp_XMLException {
        String request_xml;
        String method_name = "toXML()";
        this.debug(3, method_name, "Entered");
        if (this.action_request_ == null || this.action_request_.m_cmd == null || this.action_request_.m_trans == null || this.action_request_.m_name == null) {
            throw new epp_XMLException("missing request data or domain name");
        }
        epp_Command command_data = this.action_request_.m_cmd;
        epp_TransferRequest transfer_request_data = this.action_request_.m_trans;
        if (transfer_request_data.m_op == null) {
            this.debug(2, method_name, "transfer op is null, so assuming query");
            transfer_request_data.m_op = epp_TransferOpType.QUERY;
        }
        DocumentImpl doc = new DocumentImpl();
        Element root = this.createDocRoot((Document)doc);
        Element command = doc.createElement("command");
        Element transfer = doc.createElement("transfer");
        transfer.setAttribute("op", transfer_request_data.m_op.toString());
        Element domain_transfer = doc.createElement("domain:transfer");
        this.setCommonAttributes(domain_transfer);
        this.addXMLElement((Document)doc, domain_transfer, "domain:name", this.action_request_.m_name);
        if (this.action_request_.m_period != null) {
            epp_DomainPeriod domain_period = this.action_request_.m_period;
            Element period = this.addXMLElement((Document)doc, domain_transfer, "domain:period", Short.toString(domain_period.m_value));
            period.setAttribute("unit", domain_period.m_unit.toString());
        }
        transfer.appendChild(domain_transfer);
        if (transfer_request_data.m_auth_info != null) {
            domain_transfer.appendChild(this.prepareAuthInfo((Document)doc, "domain", transfer_request_data.m_auth_info));
        } else if (transfer_request_data.m_op == epp_TransferOpType.REQUEST) {
            throw new epp_XMLException("missing request auth id");
        }
        command.appendChild(transfer);
        this.prepareExtensionElement((Document)doc, command, command_data.m_extensions);
        if (command_data.m_client_trid != null) {
            this.addXMLElement((Document)doc, command, "clTRID", command_data.m_client_trid);
        }
        root.appendChild(command);
        doc.appendChild(root);
        try {
            request_xml = this.createXMLFromDoc((Document)doc);
        }
        catch (IOException xcp) {
            throw new epp_XMLException("IOException in building XML [" + xcp.getMessage() + "]");
        }
        this.debug(3, method_name, "Leaving");
        return request_xml;
    }

    @Override
    public void fromXML(String xml) throws epp_XMLException, epp_Exception {
        String method_name = "fromXML()";
        this.debug(3, method_name, "Entered");
        this.xml_ = xml;
        try {
            Element epp_node = this.getDocumentElement();
            Node response_node = epp_node.getElementsByTagName("response").item(0);
            if (response_node == null) {
                throw new epp_XMLException("unparsable or missing response");
            }
            this.action_response_ = new epp_DomainTransferRsp();
            this.action_response_.m_rsp = this.parseGenericResult(response_node);
            if (this.action_response_.m_rsp.m_results[0].m_code >= 2000) {
                throw new epp_Exception(this.action_response_.m_rsp.m_results);
            }
            Element response_data_element = this.getElement(response_node.getChildNodes(), "resData");
            NodeList domain_transfer_data_list = response_data_element.getElementsByTagName("domain:trnData").item(0).getChildNodes();
            this.debug(2, method_name, "domain:trnData's node count [" + domain_transfer_data_list.getLength() + "]");
            if (domain_transfer_data_list.getLength() == 0) {
                throw new epp_XMLException("missing domain transfer data");
            }
            this.action_response_.m_trn_data = EPPDomainTransfer.getTrnData(domain_transfer_data_list);
        }
        catch (SAXException xcp) {
            this.debug(1, method_name, xcp);
            throw new epp_XMLException("unable to parse xml [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
        }
        catch (IOException xcp) {
            this.debug(1, method_name, xcp);
            throw new epp_XMLException("unable to parse xml [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
        }
    }
}

