/*
 * Decompiled with CFR 0.152.
 */
package com.tucows.oxrs.epp0705.rtk.xml;

import com.tucows.oxrs.epp0705.rtk.xml.EPPDomainBase;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.xerces.dom.DocumentImpl;
import org.openrtk.idl.epp0705.domain.epp_DomainCheck;
import org.openrtk.idl.epp0705.domain.epp_DomainCheckReq;
import org.openrtk.idl.epp0705.domain.epp_DomainCheckRsp;
import org.openrtk.idl.epp0705.epp_Command;
import org.openrtk.idl.epp0705.epp_Exception;
import org.openrtk.idl.epp0705.epp_XMLException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class EPPDomainCheck
extends EPPDomainBase
implements epp_DomainCheck {
    private epp_DomainCheckReq action_request_;
    private epp_DomainCheckRsp action_response_;

    public EPPDomainCheck() {
    }

    public EPPDomainCheck(String xml) throws epp_XMLException, epp_Exception {
        String method_name = "EPPDomainCheck(String)";
        this.debug(2, method_name, "xml is [" + xml + "]");
        this.fromXML(xml);
    }

    @Override
    public void setRequestData(epp_DomainCheckReq value) {
        this.action_request_ = value;
    }

    @Override
    public epp_DomainCheckRsp getResponseData() {
        return this.action_response_;
    }

    @Override
    public String toXML() throws epp_XMLException {
        String request_xml;
        String method_name = "buildRequestXML()";
        this.debug(3, method_name, "Entered");
        if (this.action_request_ == null || this.action_request_.m_cmd == null || this.action_request_.m_names == null || this.action_request_.m_names.length == 0) {
            throw new epp_XMLException("missing request data");
        }
        DocumentImpl doc = new DocumentImpl();
        Element root = this.createDocRoot((Document)doc);
        Element command = doc.createElement("command");
        Element check = doc.createElement("check");
        epp_Command command_data = this.action_request_.m_cmd;
        Element domain_check = doc.createElement("domain:check");
        this.setCommonAttributes(domain_check);
        List<String> domain_names = Arrays.asList(this.action_request_.m_names);
        for (String domain_name : domain_names) {
            this.addXMLElement((Document)doc, domain_check, "domain:name", domain_name);
        }
        check.appendChild(domain_check);
        command.appendChild(check);
        this.prepareExtensionElement((Document)doc, command, command_data.m_extensions);
        if (command_data.m_client_trid != null) {
            this.addXMLElement((Document)doc, command, "clTRID", command_data.m_client_trid);
        }
        root.appendChild(command);
        doc.appendChild(root);
        try {
            request_xml = this.createXMLFromDoc((Document)doc);
        }
        catch (IOException xcp) {
            throw new epp_XMLException("IOException in building XML [" + xcp.getMessage() + "]");
        }
        this.debug(3, method_name, "Leaving");
        return request_xml;
    }

    @Override
    public void fromXML(String xml) throws epp_XMLException, epp_Exception {
        String method_name = "fromXML()";
        this.debug(3, method_name, "Entered");
        this.xml_ = xml;
        try {
            Element epp_node = this.getDocumentElement();
            Node response_node = epp_node.getElementsByTagName("response").item(0);
            if (response_node == null) {
                throw new epp_XMLException("unparsable or missing response");
            }
            this.action_response_ = new epp_DomainCheckRsp();
            this.action_response_.m_rsp = this.parseGenericResult(response_node);
            if (this.action_response_.m_rsp.m_results[0].m_code >= 2000) {
                throw new epp_Exception(this.action_response_.m_rsp.m_results);
            }
            Element response_data_element = this.getElement(response_node.getChildNodes(), "resData");
            Node domain_check_data_node = response_data_element.getElementsByTagName("domain:chkData").item(0);
            this.action_response_.m_results = this.parseGenericCheckResults(domain_check_data_node);
        }
        catch (SAXException xcp) {
            this.debug(1, method_name, xcp);
            throw new epp_XMLException("unable to parse xml [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
        }
        catch (IOException xcp) {
            this.debug(1, method_name, xcp);
            throw new epp_XMLException("unable to parse xml [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
        }
    }
}

