/*
 * Decompiled with CFR 0.152.
 */
package com.tucows.oxrs.epp0705.rtk.xml;

import com.tucows.oxrs.epp0705.rtk.xml.EPPContactBase;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.xerces.dom.DocumentImpl;
import org.openrtk.idl.epp0705.contact.epp_ContactAddress;
import org.openrtk.idl.epp0705.contact.epp_ContactInfo;
import org.openrtk.idl.epp0705.contact.epp_ContactInfoReq;
import org.openrtk.idl.epp0705.contact.epp_ContactInfoRsp;
import org.openrtk.idl.epp0705.contact.epp_ContactNameAddress;
import org.openrtk.idl.epp0705.contact.epp_ContactPhone;
import org.openrtk.idl.epp0705.contact.epp_ContactPostalInfoType;
import org.openrtk.idl.epp0705.contact.epp_ContactStatus;
import org.openrtk.idl.epp0705.contact.epp_ContactStatusType;
import org.openrtk.idl.epp0705.epp_AuthInfo;
import org.openrtk.idl.epp0705.epp_AuthInfoType;
import org.openrtk.idl.epp0705.epp_Command;
import org.openrtk.idl.epp0705.epp_Exception;
import org.openrtk.idl.epp0705.epp_XMLException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class EPPContactInfo
extends EPPContactBase
implements epp_ContactInfo {
    private epp_ContactInfoReq action_request_;
    private epp_ContactInfoRsp action_response_;

    public EPPContactInfo() {
    }

    public EPPContactInfo(String xml) throws epp_XMLException, epp_Exception {
        String method_name = "EPPContactInfo(String)";
        this.debug(2, method_name, "xml is [" + xml + "]");
        this.fromXML(xml);
    }

    @Override
    public void setRequestData(epp_ContactInfoReq value) {
        this.action_request_ = value;
    }

    @Override
    public epp_ContactInfoRsp getResponseData() {
        return this.action_response_;
    }

    @Override
    public String toXML() throws epp_XMLException {
        String request_xml;
        String method_name = "buildRequestXML()";
        this.debug(3, method_name, "Entered");
        if (this.action_request_ == null || this.action_request_.m_cmd == null || this.action_request_.m_id == null) {
            throw new epp_XMLException("missing request data or contact id");
        }
        DocumentImpl doc = new DocumentImpl();
        Element root = this.createDocRoot((Document)doc);
        Element command = doc.createElement("command");
        Element info = doc.createElement("info");
        epp_Command command_data = this.action_request_.m_cmd;
        Element contact_info = doc.createElement("contact:info");
        this.setCommonAttributes(contact_info);
        this.addXMLElement((Document)doc, contact_info, "contact:id", this.action_request_.m_id);
        info.appendChild(contact_info);
        command.appendChild(info);
        this.prepareExtensionElement((Document)doc, command, command_data.m_extensions);
        if (command_data.m_client_trid != null) {
            this.addXMLElement((Document)doc, command, "clTRID", command_data.m_client_trid);
        }
        root.appendChild(command);
        doc.appendChild(root);
        try {
            request_xml = this.createXMLFromDoc((Document)doc);
        }
        catch (IOException xcp) {
            throw new epp_XMLException("IOException in building XML [" + xcp.getMessage() + "]");
        }
        this.debug(3, method_name, "Leaving");
        return request_xml;
    }

    @Override
    public void fromXML(String xml) throws epp_XMLException, epp_Exception {
        String method_name = "fromXML()";
        this.debug(3, method_name, "Entered");
        this.xml_ = xml;
        try {
            Element epp_node = this.getDocumentElement();
            Node response_node = epp_node.getElementsByTagName("response").item(0);
            if (response_node == null) {
                throw new epp_XMLException("unparsable or missing response");
            }
            this.action_response_ = new epp_ContactInfoRsp();
            this.action_response_.m_rsp = this.parseGenericResult(response_node);
            if (this.action_response_.m_rsp.m_results[0].m_code >= 2000) {
                throw new epp_Exception(this.action_response_.m_rsp.m_results);
            }
            Element response_data_element = this.getElement(response_node.getChildNodes(), "resData");
            NodeList contact_info_result_list = response_data_element.getElementsByTagName("contact:infData").item(0).getChildNodes();
            this.debug(2, method_name, "contact:infData's node count [" + contact_info_result_list.getLength() + "]");
            if (contact_info_result_list.getLength() == 0) {
                throw new epp_XMLException("missing info results");
            }
            ArrayList<epp_ContactStatus> statuses = new ArrayList<epp_ContactStatus>();
            ArrayList<epp_ContactNameAddress> addresses = new ArrayList<epp_ContactNameAddress>();
            for (int count = 0; count < contact_info_result_list.getLength(); ++count) {
                Node a_node = contact_info_result_list.item(count);
                if (a_node.getNodeName().equals("contact:id")) {
                    this.action_response_.m_id = a_node.getFirstChild().getNodeValue();
                }
                if (a_node.getNodeName().equals("contact:roid")) {
                    this.action_response_.m_roid = a_node.getFirstChild().getNodeValue();
                }
                if (a_node.getNodeName().equals("contact:postalInfo")) {
                    epp_ContactNameAddress epp_address = this.addressFromXML(a_node);
                    addresses.add(epp_address);
                    if (epp_address.getType() == epp_ContactPostalInfoType.INT) {
                        this.action_response_.m_ascii_address = epp_address;
                    } else {
                        this.action_response_.m_i15d_address = epp_address;
                    }
                }
                if (a_node.getNodeName().equals("contact:voice")) {
                    this.action_response_.m_voice = new epp_ContactPhone();
                    this.action_response_.m_voice.m_value = a_node.getFirstChild().getNodeValue();
                    this.action_response_.m_voice.m_extension = ((Element)a_node).getAttribute("x");
                }
                if (a_node.getNodeName().equals("contact:fax")) {
                    this.action_response_.m_fax = new epp_ContactPhone();
                    this.action_response_.m_fax.m_value = a_node.getFirstChild().getNodeValue();
                    this.action_response_.m_fax.m_extension = ((Element)a_node).getAttribute("x");
                }
                if (a_node.getNodeName().equals("contact:email")) {
                    this.action_response_.m_email = a_node.getFirstChild().getNodeValue();
                }
                if (a_node.getNodeName().equals("contact:status")) {
                    String lang;
                    epp_ContactStatus status = new epp_ContactStatus();
                    Node status_value_node = a_node.getFirstChild();
                    if (status_value_node != null) {
                        status.m_value = status_value_node.getNodeValue();
                    }
                    if ((lang = ((Element)a_node).getAttribute("lang")) != null && lang.length() > 0) {
                        status.m_lang = lang;
                    }
                    if (!contact_status_hash_.containsKey(((Element)a_node).getAttribute("s"))) {
                        status.m_value = "invalid contact status from server";
                        status.m_lang = "en-US";
                        status.m_type = null;
                    } else {
                        status.m_type = (epp_ContactStatusType)contact_status_hash_.get(((Element)a_node).getAttribute("s"));
                    }
                    statuses.add(status);
                }
                if (a_node.getNodeName().equals("contact:clID")) {
                    this.action_response_.m_client_id = a_node.getFirstChild().getNodeValue();
                }
                if (a_node.getNodeName().equals("contact:crID")) {
                    this.action_response_.m_created_by = a_node.getFirstChild().getNodeValue();
                }
                if (a_node.getNodeName().equals("contact:crDate")) {
                    this.action_response_.m_created_date = a_node.getFirstChild().getNodeValue();
                }
                if (a_node.getNodeName().equals("contact:upID")) {
                    this.action_response_.m_updated_by = a_node.getFirstChild().getNodeValue();
                }
                if (a_node.getNodeName().equals("contact:upDate")) {
                    this.action_response_.m_updated_date = a_node.getFirstChild().getNodeValue();
                }
                if (a_node.getNodeName().equals("contact:trDate")) {
                    this.action_response_.m_transfer_date = a_node.getFirstChild().getNodeValue();
                }
                if (!a_node.getNodeName().equals("contact:authInfo")) continue;
                this.action_response_.m_auth_info = new epp_AuthInfo();
                Node auth_info_child = a_node.getFirstChild();
                if (auth_info_child == null) {
                    throw new epp_XMLException("authInfo element missing sub-element");
                }
                this.action_response_.m_auth_info.m_value = auth_info_child.getFirstChild().getNodeValue();
                this.action_response_.m_auth_info.m_type = (epp_AuthInfoType)auth_type_string_to_type_hash_.get(((Element)auth_info_child).getLocalName());
                this.action_response_.m_auth_info.m_roid = ((Element)auth_info_child).getAttribute("roid");
            }
            if (addresses.size() > 0) {
                this.action_response_.m_addresses = (epp_ContactNameAddress[])EPPContactInfo.convertListToArray(new epp_ContactNameAddress().getClass(), addresses);
            }
            if (statuses.size() > 0) {
                this.action_response_.m_status = (epp_ContactStatus[])EPPContactInfo.convertListToArray(new epp_ContactStatus().getClass(), statuses);
            }
        }
        catch (SAXException xcp) {
            this.debug(1, method_name, xcp);
            throw new epp_XMLException("unable to parse xml [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
        }
        catch (IOException xcp) {
            this.debug(1, method_name, xcp);
            throw new epp_XMLException("unable to parse xml [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
        }
    }

    private epp_ContactNameAddress addressFromXML(Node address_node) throws epp_XMLException {
        String method_name = "fromXML()";
        this.debug(3, method_name, "Entered");
        epp_ContactNameAddress name_address = new epp_ContactNameAddress();
        NodeList address_nodes = address_node.getChildNodes();
        if (!contact_address_type_hash_.containsKey(((Element)address_node).getAttribute("type"))) {
            throw new epp_XMLException("invalid contact postal info type from server: [" + ((Element)address_node).getAttribute("type") + "]");
        }
        name_address.m_type = (epp_ContactPostalInfoType)contact_address_type_hash_.get(((Element)address_node).getAttribute("type"));
        for (int count = 0; count < address_nodes.getLength(); ++count) {
            Node a_node = address_nodes.item(count);
            if (a_node.getNodeName().equals("contact:name")) {
                name_address.m_name = a_node.getFirstChild().getNodeValue();
            }
            if (a_node.getNodeName().equals("contact:org")) {
                name_address.m_org = a_node.getFirstChild().getNodeValue();
            }
            if (!a_node.getNodeName().equals("contact:addr")) continue;
            epp_ContactAddress address = new epp_ContactAddress();
            address.m_street3 = null;
            address.m_street2 = null;
            address.m_street1 = null;
            NodeList address_sub_nodes = a_node.getChildNodes();
            for (int count2 = 0; count2 < address_sub_nodes.getLength(); ++count2) {
                Node an_inner_node = address_sub_nodes.item(count2);
                if (an_inner_node.getNodeName().equals("contact:street")) {
                    if (address.m_street1 == null) {
                        address.m_street1 = an_inner_node.getFirstChild().getNodeValue();
                    } else if (address.m_street2 == null) {
                        address.m_street2 = an_inner_node.getFirstChild().getNodeValue();
                    } else if (address.m_street3 == null) {
                        address.m_street3 = an_inner_node.getFirstChild().getNodeValue();
                    }
                }
                if (an_inner_node.getNodeName().equals("contact:city")) {
                    address.m_city = an_inner_node.getFirstChild().getNodeValue();
                }
                if (an_inner_node.getNodeName().equals("contact:sp")) {
                    address.m_state_province = an_inner_node.getFirstChild().getNodeValue();
                }
                if (an_inner_node.getNodeName().equals("contact:pc")) {
                    address.m_postal_code = an_inner_node.getFirstChild().getNodeValue();
                }
                if (!an_inner_node.getNodeName().equals("contact:cc")) continue;
                address.m_country_code = an_inner_node.getFirstChild().getNodeValue();
            }
            name_address.m_address = address;
        }
        this.debug(3, method_name, "Leaving");
        return name_address;
    }
}

