/*
 * Decompiled with CFR 0.152.
 */
package com.tucows.oxrs.epp0705.rtk.example;

import com.tucows.oxrs.epp0705.rtk.EPPClient;
import com.tucows.oxrs.epp0705.rtk.RTKBase;
import com.tucows.oxrs.epp0705.rtk.xml.EPPContactBase;
import com.tucows.oxrs.epp0705.rtk.xml.EPPContactCheck;
import com.tucows.oxrs.epp0705.rtk.xml.EPPContactCreate;
import com.tucows.oxrs.epp0705.rtk.xml.EPPContactInfo;
import com.tucows.oxrs.epp0705.rtk.xml.EPPDomainBase;
import com.tucows.oxrs.epp0705.rtk.xml.EPPDomainCheck;
import com.tucows.oxrs.epp0705.rtk.xml.EPPDomainCreate;
import com.tucows.oxrs.epp0705.rtk.xml.EPPDomainDelete;
import com.tucows.oxrs.epp0705.rtk.xml.EPPDomainInfo;
import com.tucows.oxrs.epp0705.rtk.xml.EPPDomainRenew;
import com.tucows.oxrs.epp0705.rtk.xml.EPPDomainTransfer;
import com.tucows.oxrs.epp0705.rtk.xml.EPPDomainUpdate;
import com.tucows.oxrs.epp0705.rtk.xml.EPPHostBase;
import com.tucows.oxrs.epp0705.rtk.xml.EPPHostCheck;
import com.tucows.oxrs.epp0705.rtk.xml.EPPHostCreate;
import com.tucows.oxrs.epp0705.rtk.xml.EPPHostInfo;
import com.tucows.oxrs.epp0705.rtk.xml.EPPXMLBase;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Date;
import org.openrtk.idl.epp0705.contact.epp_ContactAddress;
import org.openrtk.idl.epp0705.contact.epp_ContactCheckReq;
import org.openrtk.idl.epp0705.contact.epp_ContactCheckRsp;
import org.openrtk.idl.epp0705.contact.epp_ContactCreateReq;
import org.openrtk.idl.epp0705.contact.epp_ContactCreateRsp;
import org.openrtk.idl.epp0705.contact.epp_ContactInfoReq;
import org.openrtk.idl.epp0705.contact.epp_ContactInfoRsp;
import org.openrtk.idl.epp0705.contact.epp_ContactNameAddress;
import org.openrtk.idl.epp0705.contact.epp_ContactPhone;
import org.openrtk.idl.epp0705.contact.epp_ContactPostalInfoType;
import org.openrtk.idl.epp0705.domain.epp_DomainCheckReq;
import org.openrtk.idl.epp0705.domain.epp_DomainCheckRsp;
import org.openrtk.idl.epp0705.domain.epp_DomainContact;
import org.openrtk.idl.epp0705.domain.epp_DomainContactType;
import org.openrtk.idl.epp0705.domain.epp_DomainCreateReq;
import org.openrtk.idl.epp0705.domain.epp_DomainDeleteReq;
import org.openrtk.idl.epp0705.domain.epp_DomainInfoReq;
import org.openrtk.idl.epp0705.domain.epp_DomainInfoRsp;
import org.openrtk.idl.epp0705.domain.epp_DomainPeriod;
import org.openrtk.idl.epp0705.domain.epp_DomainPeriodUnitType;
import org.openrtk.idl.epp0705.domain.epp_DomainRenewReq;
import org.openrtk.idl.epp0705.domain.epp_DomainRenewRsp;
import org.openrtk.idl.epp0705.domain.epp_DomainTransferReq;
import org.openrtk.idl.epp0705.domain.epp_DomainTransferRsp;
import org.openrtk.idl.epp0705.domain.epp_DomainUpdateAddRemove;
import org.openrtk.idl.epp0705.domain.epp_DomainUpdateReq;
import org.openrtk.idl.epp0705.epp_AuthInfo;
import org.openrtk.idl.epp0705.epp_AuthInfoType;
import org.openrtk.idl.epp0705.epp_CheckResult;
import org.openrtk.idl.epp0705.epp_Command;
import org.openrtk.idl.epp0705.epp_Exception;
import org.openrtk.idl.epp0705.epp_Greeting;
import org.openrtk.idl.epp0705.epp_PollRsp;
import org.openrtk.idl.epp0705.epp_Response;
import org.openrtk.idl.epp0705.epp_Result;
import org.openrtk.idl.epp0705.epp_TransferOpType;
import org.openrtk.idl.epp0705.epp_TransferRequest;
import org.openrtk.idl.epp0705.epp_TransferStatusType;
import org.openrtk.idl.epp0705.epp_XMLException;
import org.openrtk.idl.epp0705.host.epp_HostAddress;
import org.openrtk.idl.epp0705.host.epp_HostAddressType;
import org.openrtk.idl.epp0705.host.epp_HostCheckReq;
import org.openrtk.idl.epp0705.host.epp_HostCheckRsp;
import org.openrtk.idl.epp0705.host.epp_HostCreateReq;
import org.openrtk.idl.epp0705.host.epp_HostInfoReq;
import org.openrtk.idl.epp0705.host.epp_HostInfoRsp;

public class SessionExample {
    private static String USAGE = "Usage: com.tucows.oxrs.epp0705.rtk.example.SessionExample epp_host_name epp_host_port epp_client_id epp_password domain_name [contact_id1] [contact_id2]";

    public static void main(String[] args) {
        System.out.println("Start of the Session example");
        Date domain_exp_date = null;
        epp_AuthInfo domain_auth_info = null;
        epp_AuthInfo contact1_auth_info = null;
        epp_AuthInfo contact2_auth_info = null;
        Date current_time = new Date();
        try {
            epp_Result[] results;
            String[] domain_nameservers = null;
            epp_Command command_data = null;
            epp_TransferRequest transfer_request = null;
            epp_CheckResult[] check_results = null;
            if (args.length < 5) {
                System.err.println(USAGE);
                System.exit(1);
            }
            String epp_host_name = args[0];
            String epp_host_port_string = args[1];
            String epp_client_id = args[2];
            String epp_password = args[3];
            String domain_name = args[4];
            String contact_id1 = null;
            String contact_id2 = null;
            if (args.length > 5) {
                contact_id1 = args[5];
            }
            if (args.length > 6) {
                contact_id2 = args[6];
            }
            if (contact_id1 == null) {
                contact_id1 = epp_client_id + "001";
            }
            if (contact_id2 == null) {
                contact_id2 = epp_client_id + "002";
            }
            int epp_host_port = Integer.parseInt(epp_host_port_string);
            EPPClient epp_client = new EPPClient(epp_host_name, epp_host_port, epp_client_id, epp_password);
            epp_client.setLang("en");
            System.out.println("Connecting to the EPP Server and getting the greeting");
            epp_Greeting greeting = epp_client.connectAndGetGreeting();
            System.out.println("greeting's server: [" + greeting.getServerId() + "]");
            System.out.println("greeting's server-date: [" + greeting.getServerDate() + "]");
            System.out.println("greeting's service menu: [" + greeting.getSvcMenu() + "]");
            String client_trid = "ABC:" + epp_client_id + ":" + current_time.getTime();
            command_data = new epp_Command();
            command_data.setClientTrid(client_trid);
            System.out.println("Logging into the EPP Server");
            epp_client.login(client_trid);
            try {
                System.out.println("Polling the server...");
                current_time = new Date();
                client_trid = "ABC:" + epp_client_id + ":" + current_time.getTime();
                epp_PollRsp poll_response = epp_client.poll(client_trid);
                epp_Response response = poll_response.getRsp();
                System.out.println("Poll results: " + response);
            }
            catch (epp_XMLException xcp) {
                System.err.println("epp_XMLException! [" + xcp.getErrorMessage() + "]");
            }
            catch (epp_Exception xcp) {
                System.err.println("epp_Exception!");
                results = xcp.getDetails();
                System.err.println("\tcode: [" + results[0].getCode() + "] lang: [" + results[0].getLang() + "] msg: [" + results[0].getMsg() + "]");
                if (results[0].getValues() != null && results[0].getValues().length > 0) {
                    System.err.println("\tvalue: [" + results[0].getValues()[0] + "]");
                }
            }
            catch (Exception xcp) {
                System.err.println("EPP Poll failed! [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
                xcp.printStackTrace();
            }
            try {
                int i;
                EPPHostCreate host_create;
                String ipAddr;
                BufferedReader buffed_reader;
                ArrayList<epp_HostAddress> ip_list;
                epp_HostCreateReq host_create_request;
                System.out.println("Creating the Domain Check command");
                epp_DomainCheckReq domain_check_request = new epp_DomainCheckReq();
                current_time = new Date();
                client_trid = "ABC:" + epp_client_id + ":" + current_time.getTime();
                command_data.setClientTrid(client_trid);
                domain_check_request.setCmd(command_data);
                ArrayList<String> domain_list = new ArrayList<String>();
                domain_list.add(domain_name);
                domain_check_request.setNames(EPPXMLBase.convertListToStringArray(domain_list));
                EPPDomainCheck domain_check = new EPPDomainCheck();
                domain_check.setRequestData(domain_check_request);
                domain_check = (EPPDomainCheck)epp_client.processAction(domain_check);
                epp_DomainCheckRsp domain_check_response = domain_check.getResponseData();
                check_results = domain_check_response.getResults();
                System.out.println("DomainCheck results: domain [" + domain_name + "] available? [" + EPPXMLBase.getAvailResultFor(check_results, domain_name) + "]");
                if (EPPXMLBase.getAvailResultFor(check_results, domain_name) != null && EPPXMLBase.getAvailResultFor(check_results, domain_name).booleanValue()) {
                    epp_ContactCreateRsp contact_create_response;
                    EPPContactCreate contact_create;
                    epp_ContactAddress address;
                    epp_ContactNameAddress[] name_address;
                    BufferedReader buffed_reader2;
                    epp_ContactCreateReq contact_create_request;
                    boolean contact1_avail = false;
                    boolean contact2_avail = false;
                    if (contact_id1 != null) {
                        System.out.println("Creating the Contact Check command for [" + contact_id1 + "]");
                        epp_ContactCheckReq contact_check_request = new epp_ContactCheckReq();
                        current_time = new Date();
                        client_trid = "ABC:" + epp_client_id + ":" + current_time.getTime();
                        command_data.setClientTrid(client_trid);
                        contact_check_request.setCmd(command_data);
                        ArrayList<String> contact_list = new ArrayList<String>();
                        contact_list.add(contact_id1);
                        if (contact_id2 != null) {
                            contact_list.add(contact_id2);
                        }
                        contact_check_request.setIds(EPPXMLBase.convertListToStringArray(contact_list));
                        EPPContactCheck contact_check = new EPPContactCheck();
                        contact_check.setRequestData(contact_check_request);
                        contact_check = (EPPContactCheck)epp_client.processAction(contact_check);
                        epp_ContactCheckRsp contact_check_response = contact_check.getResponseData();
                        check_results = contact_check_response.getResults();
                        System.out.println("ContactCheck results: contact [" + contact_id1 + "] available? [" + EPPXMLBase.getAvailResultFor(check_results, contact_id1) + "]");
                        System.out.println("ContactCheck results: contact [" + contact_id2 + "] available? [" + EPPXMLBase.getAvailResultFor(check_results, contact_id2) + "]");
                        if (EPPXMLBase.getAvailResultFor(check_results, contact_id1) != null) {
                            contact1_avail = EPPXMLBase.getAvailResultFor(check_results, contact_id1);
                        }
                        if (contact_id2 != null && EPPXMLBase.getAvailResultFor(check_results, contact_id2) != null) {
                            contact2_avail = EPPXMLBase.getAvailResultFor(check_results, contact_id2);
                        }
                    }
                    if (contact_id1 == null || contact1_avail) {
                        System.out.println("Creating the Contact Create command");
                        contact_create_request = new epp_ContactCreateReq();
                        current_time = new Date();
                        client_trid = "ABC:" + epp_client_id + ":" + current_time.getTime();
                        command_data.setClientTrid(client_trid);
                        contact_create_request.setCmd(command_data);
                        contact_create_request.setId(contact_id1);
                        buffed_reader2 = new BufferedReader(new InputStreamReader(System.in));
                        contact1_auth_info = new epp_AuthInfo();
                        System.out.print("Dear registrant, please enter a passphrase for the new registrant contact(min 6, max 16): ");
                        while (contact1_auth_info.getValue() == null || contact1_auth_info.getValue().length() == 0) {
                            contact1_auth_info.setValue(buffed_reader2.readLine());
                        }
                        contact1_auth_info.setType(epp_AuthInfoType.PW);
                        contact_create_request.setAuthInfo(contact1_auth_info);
                        name_address = new epp_ContactNameAddress[]{new epp_ContactNameAddress()};
                        name_address[0].setType(epp_ContactPostalInfoType.INT);
                        name_address[0].setName("John Doe");
                        name_address[0].setOrg("ACME Solutions");
                        address = new epp_ContactAddress();
                        address.setStreet1("100 Centre St");
                        address.setCity("Townsville");
                        address.setStateProvince("County Derry");
                        address.setPostalCode("Z1Z1Z1");
                        address.setCountryCode("CA");
                        name_address[0].setAddress(address);
                        contact_create_request.setAddresses(name_address);
                        contact_create_request.setVoice(new epp_ContactPhone("1234", "+1.4165559999"));
                        contact_create_request.setFax(new epp_ContactPhone("9876", "+1.4165558888"));
                        contact_create_request.setEmail("john.doe@company.info");
                        contact_create = new EPPContactCreate();
                        contact_create.setRequestData(contact_create_request);
                        contact_create = (EPPContactCreate)epp_client.processAction(contact_create);
                        contact_create_response = contact_create.getResponseData();
                        System.out.println("ContactCreate results: contact id [" + contact_create_response.getId() + "]");
                    }
                    if (contact_id2 == null || contact2_avail) {
                        System.out.println("Creating the Contact Create command");
                        contact_create_request = new epp_ContactCreateReq();
                        current_time = new Date();
                        client_trid = "ABC:" + epp_client_id + ":" + current_time.getTime();
                        command_data.setClientTrid(client_trid);
                        contact_create_request.setCmd(command_data);
                        contact_create_request.setId(contact_id2);
                        buffed_reader2 = new BufferedReader(new InputStreamReader(System.in));
                        contact2_auth_info = new epp_AuthInfo();
                        System.out.print("Dear registrant, please enter a passphrase for the new tech contact:(min 6, max 16) ");
                        while (contact2_auth_info.getValue() == null || contact2_auth_info.getValue().length() == 0) {
                            contact2_auth_info.setValue(buffed_reader2.readLine());
                        }
                        contact2_auth_info.setType(epp_AuthInfoType.PW);
                        contact_create_request.setAuthInfo(contact2_auth_info);
                        name_address = new epp_ContactNameAddress[]{new epp_ContactNameAddress()};
                        name_address[0].setType(epp_ContactPostalInfoType.INT);
                        name_address[0].setName("Jane Doe");
                        name_address[0].setOrg("ACME Technicians");
                        address = new epp_ContactAddress();
                        address.setStreet1("101 Centre St");
                        address.setCity("Townsville");
                        address.setStateProvince("County Derry");
                        address.setPostalCode("Z1Z1Z1");
                        address.setCountryCode("CA");
                        name_address[0].setAddress(address);
                        contact_create_request.setAddresses(name_address);
                        contact_create_request.setVoice(new epp_ContactPhone("1234", "+1.4165551111"));
                        contact_create_request.setFax(new epp_ContactPhone("9876", "+1.4165552222"));
                        contact_create_request.setEmail("jane.doe@company.info");
                        contact_create = new EPPContactCreate();
                        contact_create.setRequestData(contact_create_request);
                        contact_create = (EPPContactCreate)epp_client.processAction(contact_create);
                        contact_create_response = contact_create.getResponseData();
                        System.out.println("ContactCreate results: contact id [" + contact_create_response.getId() + "]");
                    }
                    BufferedReader buffed_reader3 = new BufferedReader(new InputStreamReader(System.in));
                    domain_auth_info = new epp_AuthInfo();
                    System.out.print("Dear registrant, please enter a passphrase for your new domain:(min 6, max 16) ");
                    while (domain_auth_info.getValue() == null || domain_auth_info.getValue().length() == 0) {
                        domain_auth_info.setValue(buffed_reader3.readLine());
                    }
                    domain_auth_info.setType(epp_AuthInfoType.PW);
                    System.out.println("Creating the Domain Create command");
                    epp_DomainCreateReq domain_create_request = new epp_DomainCreateReq();
                    current_time = new Date();
                    client_trid = "ABC:" + epp_client_id + ":" + current_time.getTime();
                    command_data.setClientTrid(client_trid);
                    domain_create_request.setCmd(command_data);
                    domain_create_request.setName(domain_name);
                    epp_DomainPeriod period = new epp_DomainPeriod();
                    period.setUnit(epp_DomainPeriodUnitType.YEAR);
                    period.setValue((short)2);
                    domain_create_request.setPeriod(period);
                    domain_create_request.setRegistrant(contact_id1);
                    ArrayList<epp_DomainContact> domain_contacts = new ArrayList<epp_DomainContact>();
                    domain_contacts.add(new epp_DomainContact(epp_DomainContactType.TECH, contact_id2));
                    domain_contacts.add(new epp_DomainContact(epp_DomainContactType.ADMIN, contact_id1));
                    domain_contacts.add(new epp_DomainContact(epp_DomainContactType.BILLING, contact_id2));
                    domain_create_request.setContacts((epp_DomainContact[])EPPXMLBase.convertListToArray(new epp_DomainContact().getClass(), domain_contacts));
                    domain_create_request.setAuthInfo(domain_auth_info);
                    EPPDomainCreate domain_create = new EPPDomainCreate();
                    domain_create.setRequestData(domain_create_request);
                    domain_create = (EPPDomainCreate)epp_client.processAction(domain_create);
                }
                System.out.println("Creating the Domain Info command");
                epp_DomainInfoReq domain_info_request = new epp_DomainInfoReq();
                current_time = new Date();
                client_trid = "ABC:" + epp_client_id + ":" + current_time.getTime();
                command_data.setClientTrid(client_trid);
                domain_info_request.setCmd(command_data);
                domain_info_request.setName(domain_name);
                EPPDomainInfo domain_info = new EPPDomainInfo();
                domain_info.setRequestData(domain_info_request);
                domain_info = (EPPDomainInfo)epp_client.processAction(domain_info);
                epp_DomainInfoRsp domain_info_response = domain_info.getResponseData();
                System.out.println("DomainInfo Results: registrant [" + domain_info_response.getRegistrant() + "]");
                System.out.println("DomainInfo Results: status count [" + domain_info_response.getStatus().length + "]");
                for (int i2 = 0; i2 < domain_info_response.getStatus().length; ++i2) {
                    System.out.println("\tstatus[" + i2 + "] string [" + EPPDomainBase.domainStatusToString(domain_info_response.getStatus()[i2].getType()) + "]");
                    System.out.println("\tstatus[" + i2 + "] note [" + domain_info_response.getStatus()[i2].getValue() + "]");
                }
                domain_exp_date = RTKBase.UTC_FMT.parse(domain_info_response.getExpirationDate());
                domain_nameservers = domain_info_response.getNameServers();
                domain_auth_info = domain_info_response.getAuthInfo();
                if (domain_info_response.getAuthInfo() == null) {
                    System.out.println("Domain belongs to another registrar, building transfer command.");
                    BufferedReader buffed_reader4 = new BufferedReader(new InputStreamReader(System.in));
                    epp_AuthInfo other_domain_auth_info = new epp_AuthInfo();
                    System.out.print("Dear registrant, please enter the passphrase for the domain you wish to transfer:(min 6, max 16) ");
                    while (other_domain_auth_info.getValue() == null || other_domain_auth_info.getValue().length() == 0) {
                        other_domain_auth_info.setValue(buffed_reader4.readLine());
                    }
                    other_domain_auth_info.setType(epp_AuthInfoType.PW);
                    System.out.println("Creating the Domain Transfer command");
                    epp_DomainTransferReq domain_transfer_request = new epp_DomainTransferReq();
                    current_time = new Date();
                    client_trid = "ABC:" + epp_client_id + ":" + current_time.getTime();
                    command_data.setClientTrid(client_trid);
                    domain_transfer_request.setCmd(command_data);
                    transfer_request = new epp_TransferRequest();
                    transfer_request.setOp(epp_TransferOpType.REQUEST);
                    transfer_request.setAuthInfo(other_domain_auth_info);
                    domain_transfer_request.setTrans(transfer_request);
                    domain_transfer_request.setName(domain_name);
                    EPPDomainTransfer domain_transfer = new EPPDomainTransfer();
                    domain_transfer.setRequestData(domain_transfer_request);
                    domain_transfer = (EPPDomainTransfer)epp_client.processAction(domain_transfer);
                    epp_DomainTransferRsp domain_transfer_response = domain_transfer.getResponseData();
                    System.out.println("DomainTransfer Results: transfer status [" + EPPXMLBase.transferStatusToString(domain_transfer_response.getTrnData().getTransferStatus()) + "]");
                    System.out.println("Logging out from the EPP Server");
                    epp_client.logout(client_trid);
                    System.out.println("Disconnecting from the EPP Server");
                    epp_client.disconnect();
                    System.exit(1);
                }
                System.out.println("Creating the Host Check command");
                epp_HostCheckReq host_check_request = new epp_HostCheckReq();
                current_time = new Date();
                client_trid = "ABC:" + epp_client_id + ":" + current_time.getTime();
                command_data.setClientTrid(client_trid);
                host_check_request.setCmd(command_data);
                ArrayList<String> host_list = new ArrayList<String>();
                host_list.add("ns1." + domain_name);
                host_list.add("ns2." + domain_name);
                host_check_request.setNames(EPPXMLBase.convertListToStringArray(host_list));
                EPPHostCheck host_check = new EPPHostCheck();
                host_check.setRequestData(host_check_request);
                host_check = (EPPHostCheck)epp_client.processAction(host_check);
                epp_HostCheckRsp host_check_response = host_check.getResponseData();
                check_results = host_check_response.getResults();
                System.out.println("HostCheck results: host [ns1." + domain_name + "] avail? [" + EPPXMLBase.getAvailResultFor(check_results, "ns1." + domain_name) + "]");
                System.out.println("HostCheck results: host [ns2." + domain_name + "] avail? [" + EPPXMLBase.getAvailResultFor(check_results, "ns2." + domain_name) + "]");
                if (EPPXMLBase.getAvailResultFor(check_results, "ns1." + domain_name) == null || EPPXMLBase.getAvailResultFor(check_results, "ns1." + domain_name).booleanValue()) {
                    System.out.println("Creating the Host Create command");
                    host_create_request = new epp_HostCreateReq();
                    current_time = new Date();
                    client_trid = "ABC:" + epp_client_id + ":" + current_time.getTime();
                    command_data.setClientTrid(client_trid);
                    host_create_request.setCmd(command_data);
                    host_create_request.setName("ns1." + domain_name);
                    ip_list = new ArrayList<epp_HostAddress>();
                    buffed_reader = new BufferedReader(new InputStreamReader(System.in));
                    System.out.print("Dear registrant, please enter an IPv4 address for the nameserver " + host_create_request.getName() + "\n(it must not already be used and must not be a restricted address): ");
                    ipAddr = null;
                    while (ipAddr == null || ipAddr.length() == 0) {
                        ipAddr = buffed_reader.readLine();
                    }
                    ip_list.add(new epp_HostAddress(epp_HostAddressType.IPV4, ipAddr));
                    host_create_request.setAddresses((epp_HostAddress[])EPPXMLBase.convertListToArray(new epp_HostAddress().getClass(), ip_list));
                    host_create = new EPPHostCreate();
                    host_create.setRequestData(host_create_request);
                    host_create = (EPPHostCreate)epp_client.processAction(host_create);
                }
                if (EPPXMLBase.getAvailResultFor(check_results, "ns2." + domain_name) == null || EPPXMLBase.getAvailResultFor(check_results, "ns2." + domain_name).booleanValue()) {
                    System.out.println("Creating the Host Create command");
                    host_create_request = new epp_HostCreateReq();
                    current_time = new Date();
                    client_trid = "ABC:" + epp_client_id + ":" + current_time.getTime();
                    command_data.setClientTrid(client_trid);
                    host_create_request.setCmd(command_data);
                    host_create_request.setName("ns2." + domain_name);
                    ip_list = new ArrayList();
                    buffed_reader = new BufferedReader(new InputStreamReader(System.in));
                    System.out.print("Dear registrant, please enter an IPv4 address for the nameserver " + host_create_request.getName() + "\n(it must not already be used and must not be a restricted address): ");
                    ipAddr = null;
                    while (ipAddr == null || ipAddr.length() == 0) {
                        ipAddr = buffed_reader.readLine();
                    }
                    ip_list.add(new epp_HostAddress(epp_HostAddressType.IPV4, ipAddr));
                    host_create_request.setAddresses((epp_HostAddress[])EPPXMLBase.convertListToArray(new epp_HostAddress().getClass(), ip_list));
                    host_create = new EPPHostCreate();
                    host_create.setRequestData(host_create_request);
                    host_create = (EPPHostCreate)epp_client.processAction(host_create);
                }
                System.out.println("Creating the Host Info command");
                epp_HostInfoReq host_info_request = new epp_HostInfoReq();
                current_time = new Date();
                client_trid = "ABC:" + epp_client_id + ":" + current_time.getTime();
                command_data.setClientTrid(client_trid);
                host_info_request.setCmd(command_data);
                host_info_request.setName("ns2." + domain_name);
                EPPHostInfo host_info = new EPPHostInfo();
                host_info.setRequestData(host_info_request);
                host_info = (EPPHostInfo)epp_client.processAction(host_info);
                epp_HostInfoRsp host_info_response = host_info.getResponseData();
                System.out.println("HostInfo results: clID [" + host_info_response.getClientId() + "] crID [" + host_info_response.getCreatedBy() + "]");
                System.out.println("HostInfo results: crDate [" + host_info_response.getCreatedDate() + "] upDate [" + host_info_response.getUpdatedDate() + "]");
                System.out.println("HostInfo results: number of ipaddresses [" + (host_info_response.getAddresses() == null ? 0 : host_info_response.getAddresses().length) + "]");
                for (i = 0; i < host_info_response.getAddresses().length; ++i) {
                    System.out.println("\taddress[" + i + "] type [" + EPPHostBase.hostAddressTypeToString(host_info_response.getAddresses()[i].getType()) + "] value [" + host_info_response.getAddresses()[i].getIp() + "]");
                }
                System.out.println("HostInfo Results: status count [" + host_info_response.getStatus().length + "]");
                for (i = 0; i < host_info_response.getStatus().length; ++i) {
                    System.out.println("\tstatus[" + i + "] string [" + EPPHostBase.hostStatusToString(host_info_response.getStatus()[i].getType()) + "]");
                    System.out.println("\tstatus[" + i + "] note [" + host_info_response.getStatus()[i].getValue() + "]");
                }
                epp_DomainUpdateAddRemove add = null;
                epp_DomainUpdateAddRemove remove = null;
                if (domain_nameservers == null) {
                    ArrayList<String> add_list = new ArrayList<String>();
                    System.out.println("adding both ns1 and ns2 to domain");
                    add_list.add("ns1." + domain_name);
                    add_list.add("ns2." + domain_name);
                    add = new epp_DomainUpdateAddRemove();
                    add.setNameServers(EPPXMLBase.convertListToStringArray(add_list));
                } else {
                    int nameserver_count = domain_nameservers.length;
                    ArrayList<String> remove_list = new ArrayList<String>();
                    ArrayList<String> add_list = new ArrayList<String>();
                    boolean found_ns1 = false;
                    boolean found_ns2 = false;
                    for (int index = 0; index < nameserver_count; ++index) {
                        if (domain_nameservers[index].equalsIgnoreCase("ns1." + domain_name)) {
                            System.out.println("removing ns1 from domain");
                            remove_list.add("ns1." + domain_name);
                            found_ns1 = true;
                            continue;
                        }
                        if (!domain_nameservers[index].equalsIgnoreCase("ns2." + domain_name)) continue;
                        System.out.println("removing ns2 from domain");
                        remove_list.add("ns2." + domain_name);
                        found_ns2 = true;
                    }
                    if (!found_ns1) {
                        System.out.println("adding ns1 to domain");
                        add_list.add("ns1." + domain_name);
                    }
                    if (!found_ns2) {
                        System.out.println("adding ns2 to domain");
                        add_list.add("ns2." + domain_name);
                    }
                    if (add_list.size() > 0) {
                        add = new epp_DomainUpdateAddRemove();
                        add.setNameServers(EPPXMLBase.convertListToStringArray(add_list));
                    }
                    if (remove_list.size() > 0) {
                        remove = new epp_DomainUpdateAddRemove();
                        remove.setNameServers(EPPXMLBase.convertListToStringArray(remove_list));
                    }
                }
                System.out.println("Creating the Domain Update command");
                epp_DomainUpdateReq domain_update_request = new epp_DomainUpdateReq();
                current_time = new Date();
                client_trid = "ABC:" + epp_client_id + ":" + current_time.getTime();
                command_data.setClientTrid(client_trid);
                domain_update_request.setCmd(command_data);
                domain_update_request.setName(domain_name);
                if (add != null) {
                    domain_update_request.setAdd(add);
                }
                if (remove != null) {
                    domain_update_request.setRemove(remove);
                }
                EPPDomainUpdate domain_update = new EPPDomainUpdate();
                domain_update.setRequestData(domain_update_request);
                domain_update = (EPPDomainUpdate)epp_client.processAction(domain_update);
                System.out.println("Creating the Contact Info command");
                epp_ContactInfoReq contact_info_request = new epp_ContactInfoReq();
                current_time = new Date();
                client_trid = "ABC:" + epp_client_id + ":" + current_time.getTime();
                command_data.setClientTrid(client_trid);
                contact_info_request.setCmd(command_data);
                contact_info_request.setId(domain_info_response.m_registrant);
                EPPContactInfo contact_info = new EPPContactInfo();
                contact_info.setRequestData(contact_info_request);
                contact_info = (EPPContactInfo)epp_client.processAction(contact_info);
                epp_ContactInfoRsp contact_info_response = contact_info.getResponseData();
                System.out.println("ContactInfo results: clID [" + contact_info_response.getClientId() + "] crID [" + contact_info_response.getCreatedBy() + "]");
                System.out.println("ContactInfo results: crDate [" + contact_info_response.getCreatedDate() + "] upDate [" + contact_info_response.getUpdatedDate() + "]");
                System.out.println("ContactInfo results: address street 1 [" + contact_info_response.getAddresses()[0].getAddress().getStreet1() + "]");
                System.out.println("ContactInfo results: address street 2 [" + contact_info_response.getAddresses()[0].getAddress().getStreet2() + "]");
                System.out.println("ContactInfo results: address street 3 [" + contact_info_response.getAddresses()[0].getAddress().getStreet3() + "]");
                System.out.println("ContactInfo results: fax [" + contact_info_response.getFax() + "]");
                System.out.println("ContactInfo Results: status count [" + contact_info_response.getStatus().length + "]");
                for (int i3 = 0; i3 < contact_info_response.getStatus().length; ++i3) {
                    System.out.println("\tstatus[" + i3 + "] string [" + EPPContactBase.contactStatusToString(contact_info_response.getStatus()[i3].getType()) + "]");
                    System.out.println("\tstatus[" + i3 + "] note [" + contact_info_response.getStatus()[i3].getValue() + "]");
                }
                try {
                    System.out.println("Creating the Domain Transfer command");
                    epp_DomainTransferReq domain_transfer_request = new epp_DomainTransferReq();
                    current_time = new Date();
                    client_trid = "ABC:" + epp_client_id + ":" + current_time.getTime();
                    command_data.setClientTrid(client_trid);
                    domain_transfer_request.setCmd(command_data);
                    transfer_request = new epp_TransferRequest();
                    transfer_request.setOp(epp_TransferOpType.QUERY);
                    transfer_request.setAuthInfo(domain_auth_info);
                    domain_transfer_request.setTrans(transfer_request);
                    domain_transfer_request.setName(domain_name);
                    EPPDomainTransfer domain_transfer = new EPPDomainTransfer();
                    domain_transfer.setRequestData(domain_transfer_request);
                    domain_transfer = (EPPDomainTransfer)epp_client.processAction(domain_transfer);
                    epp_DomainTransferRsp domain_transfer_response = domain_transfer.getResponseData();
                    System.out.println("DomainTransfer Results: transfer status [" + EPPXMLBase.transferStatusToString(domain_transfer_response.getTrnData().getTransferStatus()) + "]");
                    if (domain_transfer_response.getTrnData().getTransferStatus() == epp_TransferStatusType.PENDING) {
                        System.out.println("Creating the Domain Transfer command");
                        domain_transfer_request = new epp_DomainTransferReq();
                        current_time = new Date();
                        client_trid = "ABC:" + epp_client_id + ":" + current_time.getTime();
                        command_data.setClientTrid(client_trid);
                        domain_transfer_request.setCmd(command_data);
                        transfer_request = new epp_TransferRequest();
                        BufferedReader buffed_reader5 = new BufferedReader(new InputStreamReader(System.in));
                        System.out.print("Do you wish to approve the domain's transfer [y]? ");
                        String answer = buffed_reader5.readLine();
                        while (answer != null && answer.length() != 0 && !answer.equalsIgnoreCase("y") && !answer.equalsIgnoreCase("n")) {
                            answer = buffed_reader5.readLine();
                        }
                        if (!answer.equalsIgnoreCase("n")) {
                            System.out.println("Going to approve the transfer");
                            transfer_request.setOp(epp_TransferOpType.APPROVE);
                        } else {
                            System.out.println("Going to reject the transfer");
                            transfer_request.setOp(epp_TransferOpType.REJECT);
                        }
                        transfer_request.setAuthInfo(domain_auth_info);
                        domain_transfer_request.setTrans(transfer_request);
                        domain_transfer_request.setName(domain_name);
                        domain_transfer = new EPPDomainTransfer();
                        domain_transfer.setRequestData(domain_transfer_request);
                        domain_transfer = (EPPDomainTransfer)epp_client.processAction(domain_transfer);
                        domain_transfer_response = domain_transfer.getResponseData();
                        System.out.println("DomainTransfer Results: transfer status [" + EPPXMLBase.transferStatusToString(domain_transfer_response.getTrnData().getTransferStatus()) + "]");
                        if (transfer_request.getOp() == epp_TransferOpType.APPROVE) {
                            System.out.println("Logging out from the EPP Server");
                            epp_client.logout(client_trid);
                            System.out.println("Disconnecting from the EPP Server");
                            epp_client.disconnect();
                            System.exit(1);
                        }
                    }
                }
                catch (epp_Exception xcp) {
                    epp_Result[] results2 = xcp.getDetails();
                    if (results2[0].getCode() == 2301) {
                        System.out.println("The domain is not currently in pending transfer state");
                    }
                    if (results2[0].getCode() == 2102) {
                        System.out.println("This EPP command option has not been implemented in the registry yet.  That's OK, let's continue...");
                    }
                    throw xcp;
                }
                BufferedReader buffed_reader6 = new BufferedReader(new InputStreamReader(System.in));
                System.out.print("Do you wish to renew your domain [y]? ");
                String answer = buffed_reader6.readLine();
                while (answer != null && answer.length() != 0 && !answer.equalsIgnoreCase("n") && !answer.equalsIgnoreCase("y")) {
                    answer = buffed_reader6.readLine();
                }
                if (!answer.equalsIgnoreCase("n")) {
                    System.out.println("Creating the Domain Renew command");
                    epp_DomainRenewReq domain_renew_request = new epp_DomainRenewReq();
                    current_time = new Date();
                    client_trid = "ABC:" + epp_client_id + ":" + current_time.getTime();
                    command_data.setClientTrid(client_trid);
                    domain_renew_request.setCmd(command_data);
                    domain_renew_request.setName(domain_name);
                    epp_DomainPeriod period = new epp_DomainPeriod();
                    period.setUnit(epp_DomainPeriodUnitType.YEAR);
                    period.setValue((short)6);
                    domain_renew_request.setPeriod(period);
                    domain_renew_request.setCurrentExpirationDate(RTKBase.DATE_FMT.format(domain_exp_date));
                    EPPDomainRenew domain_renew = new EPPDomainRenew();
                    domain_renew.setRequestData(domain_renew_request);
                    domain_renew = (EPPDomainRenew)epp_client.processAction(domain_renew);
                    epp_DomainRenewRsp domain_renew_response = domain_renew.getResponseData();
                    System.out.println("DomainRenew results: new exDate [" + domain_renew_response.getExpirationDate() + "]");
                    domain_exp_date = RTKBase.UTC_FMT.parse(domain_renew_response.getExpirationDate());
                }
                buffed_reader6 = new BufferedReader(new InputStreamReader(System.in));
                System.out.print("Do you wish to delete your domain [y]? ");
                answer = buffed_reader6.readLine();
                while (answer != null && answer.length() != 0 && !answer.equalsIgnoreCase("n") && !answer.equalsIgnoreCase("y")) {
                    answer = buffed_reader6.readLine();
                }
                if (!answer.equalsIgnoreCase("n")) {
                    System.out.println("Creating the Domain Delete command");
                    epp_DomainDeleteReq domain_delete_request = new epp_DomainDeleteReq();
                    current_time = new Date();
                    client_trid = "ABC:" + epp_client_id + ":" + current_time.getTime();
                    command_data.setClientTrid(client_trid);
                    domain_delete_request.setCmd(command_data);
                    domain_delete_request.setName(domain_name);
                    EPPDomainDelete domain_delete = new EPPDomainDelete();
                    domain_delete.setRequestData(domain_delete_request);
                    domain_delete = (EPPDomainDelete)epp_client.processAction(domain_delete);
                }
            }
            catch (epp_XMLException xcp) {
                System.err.println("epp_XMLException! [" + xcp.getErrorMessage() + "]");
            }
            catch (epp_Exception xcp) {
                System.err.println("epp_Exception!");
                results = xcp.getDetails();
                System.err.println("\t" + results[0]);
            }
            catch (Exception xcp) {
                System.err.println("EPP Action failed! [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
                xcp.printStackTrace();
            }
            System.out.println("Logging out from the EPP Server");
            epp_client.logout(client_trid);
            System.out.println("Disconnecting from the EPP Server");
            epp_client.disconnect();
        }
        catch (epp_XMLException xcp) {
            System.err.println("epp_XMLException! [" + xcp.getErrorMessage() + "]");
        }
        catch (epp_Exception xcp) {
            System.err.println("epp_Exception!");
            epp_Result[] results = xcp.getDetails();
            System.err.println("\tresult: [" + results[0] + "]");
        }
        catch (Exception xcp) {
            System.err.println("Exception! [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
            xcp.printStackTrace();
        }
    }
}

