/*
 * Decompiled with CFR 0.152.
 */
package com.tucows.oxrs.epp0705.rtk.example;

import com.tucows.oxrs.epp0705.rtk.EPPClient;
import com.tucows.oxrs.epp0705.rtk.xml.EPPContactCreate;
import com.tucows.oxrs.epp0705.rtk.xml.EPPDomainCreate;
import com.tucows.oxrs.epp0705.rtk.xml.EPPHostCheck;
import com.tucows.oxrs.epp0705.rtk.xml.EPPHostCreate;
import com.tucows.oxrs.epp0705.rtk.xml.EPPHostDelete;
import com.tucows.oxrs.epp0705.rtk.xml.EPPHostInfo;
import com.tucows.oxrs.epp0705.rtk.xml.EPPHostUpdate;
import com.tucows.oxrs.epp0705.rtk.xml.EPPXMLBase;
import java.util.ArrayList;
import java.util.Random;
import java.util.Vector;
import org.openrtk.idl.epp0705.contact.epp_ContactAddress;
import org.openrtk.idl.epp0705.contact.epp_ContactCreateReq;
import org.openrtk.idl.epp0705.contact.epp_ContactCreateRsp;
import org.openrtk.idl.epp0705.contact.epp_ContactNameAddress;
import org.openrtk.idl.epp0705.contact.epp_ContactPostalInfoType;
import org.openrtk.idl.epp0705.domain.epp_DomainContact;
import org.openrtk.idl.epp0705.domain.epp_DomainContactType;
import org.openrtk.idl.epp0705.domain.epp_DomainCreateReq;
import org.openrtk.idl.epp0705.domain.epp_DomainCreateRsp;
import org.openrtk.idl.epp0705.epp_AuthInfo;
import org.openrtk.idl.epp0705.epp_AuthInfoType;
import org.openrtk.idl.epp0705.epp_CheckResult;
import org.openrtk.idl.epp0705.epp_Command;
import org.openrtk.idl.epp0705.epp_Exception;
import org.openrtk.idl.epp0705.epp_Greeting;
import org.openrtk.idl.epp0705.epp_Response;
import org.openrtk.idl.epp0705.epp_Result;
import org.openrtk.idl.epp0705.epp_XMLException;
import org.openrtk.idl.epp0705.host.epp_HostAddress;
import org.openrtk.idl.epp0705.host.epp_HostAddressType;
import org.openrtk.idl.epp0705.host.epp_HostCheckReq;
import org.openrtk.idl.epp0705.host.epp_HostCheckRsp;
import org.openrtk.idl.epp0705.host.epp_HostCreateReq;
import org.openrtk.idl.epp0705.host.epp_HostCreateRsp;
import org.openrtk.idl.epp0705.host.epp_HostDeleteReq;
import org.openrtk.idl.epp0705.host.epp_HostDeleteRsp;
import org.openrtk.idl.epp0705.host.epp_HostInfoReq;
import org.openrtk.idl.epp0705.host.epp_HostInfoRsp;
import org.openrtk.idl.epp0705.host.epp_HostStatus;
import org.openrtk.idl.epp0705.host.epp_HostStatusType;
import org.openrtk.idl.epp0705.host.epp_HostUpdateAddRemove;
import org.openrtk.idl.epp0705.host.epp_HostUpdateChange;
import org.openrtk.idl.epp0705.host.epp_HostUpdateReq;
import org.openrtk.idl.epp0705.host.epp_HostUpdateRsp;

public class HostExample {
    private static String USAGE = "Usage: com.tucows.oxrs.epp0705.rtk.example.HostExample epp_host_name epp_host_port epp_client_id epp_password epp_domain_name";

    public static void main(String[] args) {
        System.out.println("Start of the Host example");
        int current_expiration_year = 2002;
        epp_Command command_data = null;
        try {
            epp_Result[] results;
            epp_Result[] results2;
            epp_Response response;
            epp_Result[] results3;
            epp_Response response2;
            if (args.length < 5) {
                System.err.println(USAGE);
                System.exit(1);
            }
            String epp_host_name = args[0];
            String epp_host_port_string = args[1];
            String epp_client_id = args[2];
            String epp_password = args[3];
            String epp_domain_name = args[4];
            int epp_host_port = Integer.parseInt(epp_host_port_string);
            EPPClient epp_client = new EPPClient(epp_host_name, epp_host_port, epp_client_id, epp_password);
            epp_client.setLang("en");
            System.out.println("Connecting to the EPP Server and getting the greeting");
            epp_Greeting greeting = epp_client.connectAndGetGreeting();
            System.out.println("greeting's server: [" + greeting.m_server_id + "]");
            System.out.println("greeting's server-date: [" + greeting.m_server_date + "]");
            System.out.println("greeting's service menu: [" + greeting.getSvcMenu() + "]");
            System.out.println();
            String client_trid = HostExample.getClientTrid(epp_client_id);
            System.out.println("Logging into the EPP Server");
            epp_client.login(client_trid);
            try {
                System.out.println("Creating the Host Check command");
                epp_HostCheckReq host_check_request = new epp_HostCheckReq();
                command_data = new epp_Command();
                command_data.m_client_trid = HostExample.getClientTrid(epp_client_id);
                host_check_request.m_cmd = command_data;
                ArrayList<String> host_list = new ArrayList<String>();
                host_list.add("ns1." + epp_client_id + ".info");
                host_list.add("ns2." + epp_client_id + ".info");
                host_list.add("dns.host.info");
                host_check_request.m_names = EPPXMLBase.convertListToStringArray(host_list);
                EPPHostCheck host_check = new EPPHostCheck();
                host_check.setRequestData(host_check_request);
                host_check = (EPPHostCheck)epp_client.processAction(host_check);
                epp_HostCheckRsp host_check_response = host_check.getResponseData();
                response2 = host_check_response.m_rsp;
                results3 = response2.m_results;
                System.out.println("HostCheck results: [" + results3[0].m_code + "] [" + results3[0].m_msg + "]");
                epp_CheckResult[] check_results = host_check_response.m_results;
                System.out.println("HostCheck results: host [ns1." + epp_client_id + ".info] available? [" + EPPXMLBase.getAvailResultFor(check_results, "ns1." + epp_client_id + ".info") + "]");
                System.out.println("HostCheck results: host [ns2." + epp_client_id + ".info] available? [" + EPPXMLBase.getAvailResultFor(check_results, "ns2." + epp_client_id + ".info") + "]");
                System.out.println("HostCheck results: host [dns.host.info] available? [" + EPPXMLBase.getAvailResultFor(check_results, "dns.host.info") + "]");
            }
            catch (epp_XMLException xcp) {
                System.err.println("epp_XMLException! [" + xcp.m_error_message + "]");
            }
            catch (epp_Exception xcp) {
                System.err.println("epp_Exception!");
                epp_Result[] results4 = xcp.m_details;
                System.err.println("\tresults: " + results4[0] + "]");
            }
            catch (Exception xcp) {
                System.err.println("EPP Host Check failed! [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
                xcp.printStackTrace();
            }
            System.out.println("Creating the Contact Create command");
            epp_ContactCreateReq contact_create_request = new epp_ContactCreateReq();
            try {
                command_data = new epp_Command();
                command_data.m_client_trid = HostExample.getClientTrid(epp_client_id);
                contact_create_request.m_cmd = command_data;
                Random rng = new Random();
                String randnum = "" + rng.nextInt() % 999999;
                while ((epp_client_id + randnum).length() > 16) {
                    randnum = randnum.substring(0, randnum.length() - 1);
                }
                contact_create_request.m_id = epp_client_id + randnum;
                epp_ContactNameAddress[] name_address = new epp_ContactNameAddress[]{new epp_ContactNameAddress()};
                name_address[0].setType(epp_ContactPostalInfoType.INT);
                name_address[0].m_name = "John Doe";
                name_address[0].setAddress(new epp_ContactAddress());
                name_address[0].getAddress().setStreet1("100 Centre St");
                name_address[0].getAddress().setCity("Townsville");
                name_address[0].getAddress().setStateProvince("County Derry");
                name_address[0].getAddress().setPostalCode("Z1Z1Z1");
                name_address[0].getAddress().setCountryCode("CA");
                contact_create_request.setAddresses(name_address);
                contact_create_request.setEmail("jdoe@company.info");
                epp_AuthInfo contact_auth_info = new epp_AuthInfo();
                contact_auth_info.m_value = "changeme";
                contact_auth_info.m_type = epp_AuthInfoType.PW;
                contact_create_request.m_auth_info = contact_auth_info;
                EPPContactCreate contact_create = new EPPContactCreate();
                contact_create.setRequestData(contact_create_request);
                contact_create = (EPPContactCreate)epp_client.processAction(contact_create);
                epp_ContactCreateRsp contact_create_response = contact_create.getResponseData();
                response = contact_create_response.m_rsp;
                results2 = response.m_results;
                System.out.println("ContactCreate results: [" + results2[0].m_code + "] [" + results2[0].m_msg + "]");
                System.out.println("ContactCreate results: contact id [" + contact_create_response.m_id + "]");
            }
            catch (epp_XMLException xcp) {
                System.err.println("epp_XMLException! [" + xcp.m_error_message + "]");
            }
            catch (epp_Exception xcp) {
                System.err.println("epp_Exception!");
                results = xcp.m_details;
                System.err.println("\tresult: [" + results[0] + "]");
            }
            catch (Exception xcp) {
                System.err.println("Contact Create failed! [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
                xcp.printStackTrace();
            }
            try {
                System.out.println("Creating the Domain Create command");
                epp_DomainCreateReq domain_create_request = new epp_DomainCreateReq();
                command_data = new epp_Command();
                command_data.m_client_trid = HostExample.getClientTrid(epp_client_id);
                domain_create_request.m_cmd = command_data;
                domain_create_request.m_name = epp_domain_name;
                epp_AuthInfo domain_auth_info = new epp_AuthInfo();
                domain_auth_info.m_value = "exam123";
                domain_create_request.m_auth_info = domain_auth_info;
                Vector<epp_DomainContact> contacts = new Vector<epp_DomainContact>();
                contacts.add(new epp_DomainContact(epp_DomainContactType.TECH, contact_create_request.m_id));
                contacts.add(new epp_DomainContact(epp_DomainContactType.ADMIN, contact_create_request.m_id));
                contacts.add(new epp_DomainContact(epp_DomainContactType.BILLING, contact_create_request.m_id));
                domain_create_request.m_contacts = contacts.toArray(new epp_DomainContact[1]);
                domain_create_request.m_registrant = contact_create_request.m_id;
                EPPDomainCreate domain_create = new EPPDomainCreate();
                domain_create.setRequestData(domain_create_request);
                domain_create = (EPPDomainCreate)epp_client.processAction(domain_create);
                epp_DomainCreateRsp domain_create_response = domain_create.getResponseData();
                epp_Response response3 = domain_create_response.m_rsp;
            }
            catch (epp_Exception xcp) {
                results = xcp.m_details;
                if (results[0].m_code == 2302) {
                    System.out.println("Domain already exists!  Let's continue...");
                } else {
                    System.err.println("epp_Exception!");
                    System.err.println("\tresult: [" + results[0] + "]");
                    System.exit(1);
                }
            }
            catch (Exception xcp) {
                System.err.println("Failed to create domain required for host example [" + xcp.getMessage() + "]");
                System.exit(1);
            }
            try {
                System.out.println("Creating the Host Create command");
                epp_HostCreateReq host_create_request = new epp_HostCreateReq();
                command_data = new epp_Command();
                command_data.m_client_trid = HostExample.getClientTrid(epp_client_id);
                host_create_request.m_cmd = command_data;
                ArrayList<epp_HostAddress> ip_list = new ArrayList<epp_HostAddress>();
                ip_list.add(new epp_HostAddress(epp_HostAddressType.IPV4, "130.111.111.200"));
                host_create_request.m_addresses = (epp_HostAddress[])EPPXMLBase.convertListToArray(new epp_HostAddress().getClass(), ip_list);
                host_create_request.m_name = "ns1." + epp_domain_name;
                EPPHostCreate host_create = new EPPHostCreate();
                host_create.setRequestData(host_create_request);
                host_create = (EPPHostCreate)epp_client.processAction(host_create);
                epp_HostCreateRsp host_create_response = host_create.getResponseData();
                epp_Response response4 = host_create_response.m_rsp;
                epp_Result[] results5 = response4.m_results;
                System.out.println("HostCreate results: [" + results5[0].m_code + "] [" + results5[0].m_msg + "]");
                System.out.println("HostCreate results: host name [" + host_create_response.m_name + "]");
            }
            catch (epp_XMLException xcp) {
                System.err.println("epp_XMLException! [" + xcp.m_error_message + "]");
            }
            catch (epp_Exception xcp) {
                System.err.println("epp_Exception!");
                results = xcp.m_details;
                System.err.println("\tresult: [" + results[0] + "]");
            }
            catch (Exception xcp) {
                System.err.println("EPP Host Create failed! [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
                xcp.printStackTrace();
            }
            try {
                System.out.println("Creating the Host Info command");
                epp_HostInfoReq host_info_request = new epp_HostInfoReq();
                command_data = new epp_Command();
                command_data.m_client_trid = HostExample.getClientTrid(epp_client_id);
                host_info_request.m_cmd = command_data;
                host_info_request.m_name = "ns1." + epp_domain_name;
                EPPHostInfo host_info = new EPPHostInfo();
                host_info.setRequestData(host_info_request);
                host_info = (EPPHostInfo)epp_client.processAction(host_info);
                epp_HostInfoRsp host_info_response = host_info.getResponseData();
                response2 = host_info_response.m_rsp;
                results3 = response2.m_results;
                System.out.println("HostInfo results: [" + results3[0].m_code + "] [" + results3[0].m_msg + "]");
                System.out.println("HostInfo results: clID [" + host_info_response.m_client_id + "] crID [" + host_info_response.m_created_by + "]");
                System.out.println("HostInfo results: crDate [" + host_info_response.m_created_date + "] upDate [" + host_info_response.m_updated_date + "]");
                System.out.println("HostInfo results: number of ipaddresses [" + (host_info_response.m_addresses == null ? 0 : host_info_response.m_addresses.length) + "]");
            }
            catch (epp_XMLException xcp) {
                System.err.println("epp_XMLException! [" + xcp.m_error_message + "]");
            }
            catch (epp_Exception xcp) {
                System.err.println("epp_Exception!");
                results = xcp.m_details;
                System.err.println("\tresult: [" + results[0] + "]");
            }
            catch (Exception xcp) {
                System.err.println("EPP Host Info failed! [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
                xcp.printStackTrace();
            }
            try {
                System.out.println("Creating the Host Update command");
                epp_HostUpdateReq host_update_request = new epp_HostUpdateReq();
                command_data = new epp_Command();
                command_data.m_client_trid = HostExample.getClientTrid(epp_client_id);
                host_update_request.m_cmd = command_data;
                host_update_request.m_name = "ns1." + epp_domain_name;
                epp_HostUpdateAddRemove add = new epp_HostUpdateAddRemove();
                ArrayList<epp_HostAddress> ip_list = new ArrayList<epp_HostAddress>();
                ip_list.add(new epp_HostAddress(epp_HostAddressType.IPV4, "130.111.111.201"));
                add.m_addresses = (epp_HostAddress[])EPPXMLBase.convertListToArray(new epp_HostAddress().getClass(), ip_list);
                add.m_status = new epp_HostStatus[1];
                add.m_status[0] = new epp_HostStatus();
                add.m_status[0].m_type = epp_HostStatusType.CLIENT_UPDATE_PROHIBITED;
                add.m_status[0].m_lang = "en";
                add.m_status[0].m_value = "Want to prevent accidental change of IP";
                host_update_request.m_add = add;
                epp_HostUpdateAddRemove remove = new epp_HostUpdateAddRemove();
                ip_list = new ArrayList();
                ip_list.add(new epp_HostAddress(epp_HostAddressType.IPV4, "130.111.111.200"));
                remove.m_addresses = (epp_HostAddress[])EPPXMLBase.convertListToArray(new epp_HostAddress().getClass(), ip_list);
                host_update_request.m_remove = remove;
                host_update_request.m_change = new epp_HostUpdateChange();
                host_update_request.m_change.m_name = "ns1." + epp_domain_name;
                EPPHostUpdate host_update = new EPPHostUpdate();
                host_update.setRequestData(host_update_request);
                host_update = (EPPHostUpdate)epp_client.processAction(host_update);
                epp_HostUpdateRsp host_update_response = host_update.getResponseData();
                response = host_update_response.m_rsp;
                results2 = response.m_results;
                System.out.println("HostUpdate results: [" + results2[0].m_code + "] [" + results2[0].m_msg + "]");
            }
            catch (epp_XMLException xcp) {
                System.err.println("epp_XMLException! [" + xcp.m_error_message + "]");
            }
            catch (epp_Exception xcp) {
                System.err.println("epp_Exception!");
                results = xcp.m_details;
                System.err.println("\tresult: [" + results[0] + "]");
            }
            catch (Exception xcp) {
                System.err.println("Host Update failed! [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
                xcp.printStackTrace();
            }
            try {
                System.out.println("Creating the Host Delete command");
                epp_HostDeleteReq host_delete_request = new epp_HostDeleteReq();
                command_data = new epp_Command();
                command_data.m_client_trid = HostExample.getClientTrid(epp_client_id);
                host_delete_request.m_cmd = command_data;
                host_delete_request.m_name = "ns1." + epp_domain_name;
                EPPHostDelete host_delete = new EPPHostDelete();
                host_delete.setRequestData(host_delete_request);
                host_delete = (EPPHostDelete)epp_client.processAction(host_delete);
                epp_HostDeleteRsp host_delete_response = host_delete.getResponseData();
                response2 = host_delete_response.m_rsp;
                results3 = response2.m_results;
                System.out.println("HostDelete results: [" + results3[0].m_code + "] [" + results3[0].m_msg + "]");
            }
            catch (epp_XMLException xcp) {
                System.err.println("epp_XMLException! [" + xcp.m_error_message + "]");
            }
            catch (epp_Exception xcp) {
                System.err.println("epp_Exception!");
                results = xcp.m_details;
                System.err.println("\tresult: [" + results[0] + "]");
            }
            catch (Exception xcp) {
                System.err.println("EPP Host Delete failed! [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
                xcp.printStackTrace();
            }
            System.out.println("Logging out from the EPP Server");
            epp_client.logout(client_trid);
            System.out.println("Disconnecting from the EPP Server");
            epp_client.disconnect();
        }
        catch (epp_XMLException xcp) {
            System.err.println("epp_XMLException! [" + xcp.m_error_message + "]");
        }
        catch (epp_Exception xcp) {
            System.err.println("epp_Exception!");
            epp_Result[] results = xcp.m_details;
            System.err.println("\tresult: [" + results[0] + "]");
        }
        catch (Exception xcp) {
            System.err.println("Exception! [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
            xcp.printStackTrace();
        }
    }

    protected static String getClientTrid(String epp_client_id) {
        return "ABC:" + epp_client_id + ":" + System.currentTimeMillis();
    }
}

