/*
 * Decompiled with CFR 0.152.
 */
package com.tucows.oxrs.epp0705.rtk;

import com.tucows.oxrs.epp0705.rtk.RTKBase;
import com.tucows.oxrs.epp0705.rtk.transport.EPPTransportBase;
import com.tucows.oxrs.epp0705.rtk.transport.EPPTransportException;
import com.tucows.oxrs.epp0705.rtk.transport.EPPTransportTCP;
import com.tucows.oxrs.epp0705.rtk.xml.EPPGreeting;
import com.tucows.oxrs.epp0705.rtk.xml.EPPLogin;
import com.tucows.oxrs.epp0705.rtk.xml.EPPLogout;
import com.tucows.oxrs.epp0705.rtk.xml.EPPPoll;
import com.tucows.oxrs.epp0705.rtk.xml.extension.RTKVersion;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.Provider;
import java.security.Security;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.openrtk.idl.epp0705.epp_Action;
import org.openrtk.idl.epp0705.epp_Command;
import org.openrtk.idl.epp0705.epp_Exception;
import org.openrtk.idl.epp0705.epp_Extension;
import org.openrtk.idl.epp0705.epp_Greeting;
import org.openrtk.idl.epp0705.epp_LoginReq;
import org.openrtk.idl.epp0705.epp_LogoutReq;
import org.openrtk.idl.epp0705.epp_Options;
import org.openrtk.idl.epp0705.epp_PollOpType;
import org.openrtk.idl.epp0705.epp_PollReq;
import org.openrtk.idl.epp0705.epp_PollRsp;
import org.openrtk.idl.epp0705.epp_Session;
import org.openrtk.idl.epp0705.epp_XMLException;

public class EPPClient
extends RTKBase
implements epp_Session {
    public static final String VERSION = "1.0";
    public static final String DEFAULT_LANG = "en";
    public static final String DEFAULT_TRANSPORT_CLASS = "EPPTransportTCPTLS";
    public static final String DEFAULT_TRANSPORT_PACKAGE = "com.tucows.oxrs.epp0705.rtk.transport";
    private String epp_host_name_;
    private int epp_host_port_;
    private int epp_timeout_;
    private String epp_client_id_;
    private String epp_password_;
    private String[] epp_services_;
    private String[] epp_service_extensions_;
    private String version_;
    private String lang_;
    private EPPTransportBase transport_;
    private long lastNetTransaction = 0L;
    private boolean isValid = false;
    private boolean sendver_;

    public EPPClient() {
        String method_name = "EPPClient()";
        this.version_ = VERSION;
        this.lang_ = DEFAULT_LANG;
        try {
            String sendver_str = RTKBase.getRTKProperties().getProperty("rtk.login.sendversion", "false");
            this.sendver_ = Boolean.valueOf(sendver_str);
        }
        catch (Exception xcp) {
            this.debug(1, method_name, "Configuration file not found or file read error! Default sendver value will be used.");
            this.sendver_ = false;
        }
    }

    public EPPClient(String epp_client_id, String epp_password) {
        this();
        this.epp_client_id_ = epp_client_id;
        this.epp_password_ = epp_password;
    }

    public EPPClient(String epp_host_name, int epp_host_port, String epp_client_id, String epp_password) {
        this(epp_client_id, epp_password);
        this.epp_host_name_ = epp_host_name;
        this.epp_host_port_ = epp_host_port;
    }

    public void setVersion(String value) {
        this.version_ = value;
    }

    public String getVersion() {
        return this.version_;
    }

    public void setLang(String value) {
        this.lang_ = value;
    }

    public String getLang() {
        return this.lang_;
    }

    public void setEPPHostName(String value) {
        this.epp_host_name_ = value;
    }

    public String getEPPHostName() {
        return this.epp_host_name_;
    }

    public void setEPPHostPort(int value) {
        this.epp_host_port_ = value;
    }

    public int getEPPHostPort() {
        return this.epp_host_port_;
    }

    public void setEPPTimeout(int value) {
        this.epp_timeout_ = value;
    }

    public int getEPPTimeout() {
        return this.epp_timeout_;
    }

    public void setEPPClientID(String value) {
        this.epp_client_id_ = value;
    }

    public String getEPPClientID() {
        return this.epp_client_id_;
    }

    public void setEPPPassword(String value) {
        this.epp_password_ = value;
    }

    public String getEPPPassword() {
        return this.epp_password_;
    }

    public void setEPPServices(String[] services) {
        this.epp_services_ = services;
    }

    public String[] getEPPServices() {
        return this.epp_services_;
    }

    public void setEPPServiceExtensions(String[] service_extensions) {
        this.epp_service_extensions_ = service_extensions;
    }

    public String[] getEPPServiceExtensions() {
        return this.epp_service_extensions_;
    }

    public long getLastNetTransaction() {
        return this.lastNetTransaction;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void setSocketToEPPServer(Socket value) throws epp_Exception, UnknownHostException, SocketException, IOException, EPPTransportException {
        String method_name = "setSocketToEPPServer";
        this.debug(3, method_name, "Enterd");
        this.transport_ = new EPPTransportTCP(value, this.epp_timeout_);
        this.transport_.connect();
        this.debug(3, method_name, "Leaving");
    }

    public void setTransport(EPPTransportBase value) {
        String method_name = "setTransport";
        this.debug(3, method_name, "Enterd");
        this.transport_ = value;
        this.debug(3, method_name, "Leaving");
    }

    public void connect(String epp_host_name, int epp_host_port) throws epp_Exception, UnknownHostException, SocketException, IOException, EPPTransportException {
        this.setEPPHostName(epp_host_name);
        this.setEPPHostPort(epp_host_port);
        this.connect();
    }

    public void connect(String epp_client_id, String epp_password) throws epp_Exception, UnknownHostException, SocketException, IOException, EPPTransportException {
        this.setEPPClientID(epp_client_id);
        this.setEPPPassword(epp_password);
        this.connect();
    }

    public void connect(String epp_host_name, int epp_host_port, String epp_client_id, String epp_password) throws epp_Exception, UnknownHostException, SocketException, IOException, EPPTransportException {
        this.setEPPHostName(epp_host_name);
        this.setEPPHostPort(epp_host_port);
        this.setEPPClientID(epp_client_id);
        this.setEPPPassword(epp_password);
        this.connect();
    }

    public void connect() throws epp_Exception, UnknownHostException, SocketException, IOException, EPPTransportException {
        String method_name = "connect()";
        this.debug(3, method_name, "Entered");
        boolean valid = this.isValid;
        this.isValid = false;
        this.getTransport();
        this.transport_.connect();
        this.isValid = valid;
        this.debug(3, method_name, "Leaving");
    }

    private EPPTransportBase getTransport() throws IOException, EPPTransportException {
        String method_name = "getTransport()";
        String transport_str = null;
        if (this.transport_ != null) {
            return this.transport_;
        }
        transport_str = RTKBase.getRTKProperties().getProperty("rtk.transport", DEFAULT_TRANSPORT_CLASS);
        if (transport_str.indexOf(46) == -1) {
            transport_str = "com.tucows.oxrs.epp0705.rtk.transport." + transport_str;
        }
        try {
            this.debug(2, method_name, "Trying to instantiate transport class [" + transport_str + "]");
            this.transport_ = (EPPTransportBase)((Object)Class.forName(transport_str).newInstance());
        }
        catch (IllegalAccessException xcp) {
            throw new EPPTransportException("Transport class [" + transport_str + "] could not be instantiated. Access error.");
        }
        catch (InstantiationException xcp) {
            throw new EPPTransportException("Transport class [" + transport_str + "] could not be instantiated. [" + xcp.getMessage() + "]");
        }
        catch (ClassNotFoundException xcp) {
            throw new EPPTransportException("Transport class [" + transport_str + "] not found. Please check your classpath and the package name for the transport.");
        }
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        catch (Exception xcp) {
            throw new IOException(xcp.getMessage());
        }
        this.transport_.initialize(this.epp_host_name_, this.epp_host_port_, this.epp_timeout_);
        return this.transport_;
    }

    public String readFromServer() throws epp_Exception {
        String method_name = "readFromServer()";
        this.debug(3, method_name, "Entered");
        String xml_from_server = null;
        try {
            xml_from_server = this.transport_.readFromServer();
        }
        catch (epp_Exception excp) {
            this.isValid = false;
            throw excp;
        }
        this.lastNetTransaction = System.currentTimeMillis();
        this.debug(3, method_name, "Leaving");
        return xml_from_server;
    }

    @Override
    public String processXML(String request_xml) throws epp_Exception {
        String method_name = "processXML(String)";
        this.debug(3, method_name, "Entered");
        this.debug(2, method_name, "Request XML is [" + request_xml + "]");
        this.writeToServer(request_xml);
        String response_xml = this.readFromServer();
        this.debug(2, method_name, "Response XML is [" + response_xml + "]");
        this.debug(3, method_name, "Leaving");
        return response_xml;
    }

    @Override
    public epp_Action processAction(epp_Action request) throws epp_XMLException, epp_Exception {
        String method_name = "processAction(epp_Action)";
        this.debug(3, method_name, "Entered");
        String request_xml = request.toXML();
        epp_Action response = request;
        String response_xml = this.processXML(request_xml);
        response.fromXML(response_xml);
        this.debug(3, method_name, "Leaving");
        return response;
    }

    public void writeToServer(String outbound_xml) throws epp_Exception {
        String method_name = "writeToServer(String)";
        this.debug(3, method_name, "Entered");
        try {
            this.transport_.writeToServer(outbound_xml);
        }
        catch (epp_Exception excp) {
            this.isValid = false;
            throw excp;
        }
        this.debug(3, method_name, "Leaving");
    }

    public epp_Greeting connectAndGetGreeting() throws epp_Exception, IOException, epp_XMLException, EPPTransportException {
        epp_Greeting hello_from_server;
        String method_name = "connectAndGetGreeting()";
        this.debug(3, method_name, "Entered");
        try {
            this.connect();
            hello_from_server = this.getGreeting();
        }
        catch (IOException xcp) {
            this.debug(1, method_name, xcp);
            this.isValid = false;
            throw xcp;
        }
        catch (EPPTransportException xcp) {
            this.debug(1, method_name, xcp);
            this.isValid = false;
            throw xcp;
        }
        catch (epp_XMLException xcp) {
            this.debug(1, method_name, (Exception)((Object)xcp));
            this.isValid = false;
            throw xcp;
        }
        this.debug(3, method_name, "Leaving");
        return hello_from_server;
    }

    public epp_Greeting getGreeting() throws epp_Exception, epp_XMLException {
        EPPGreeting hello_from_server;
        String method_name = "getGreeting()";
        this.debug(3, method_name, "Entered");
        try {
            String xml_from_server = this.readFromServer();
            this.debug(2, method_name, "Greeting from server: [" + xml_from_server + "]");
            hello_from_server = new EPPGreeting();
            hello_from_server.fromXML(xml_from_server);
        }
        catch (epp_XMLException xcp) {
            this.debug(1, method_name, (Exception)((Object)xcp));
            this.isValid = false;
            throw xcp;
        }
        this.debug(3, method_name, "Leaving");
        this.isValid = true;
        return hello_from_server.getResponseData();
    }

    public epp_Greeting hello() throws epp_Exception, epp_XMLException {
        String method_name = "hello()";
        this.debug(3, method_name, "Entered");
        EPPGreeting hello_from_server = new EPPGreeting();
        hello_from_server = (EPPGreeting)this.processAction(hello_from_server);
        this.debug(3, method_name, "Leaving");
        return hello_from_server.getResponseData();
    }

    public void disconnect() throws IOException {
        String method_name = "disconnect()";
        this.debug(3, method_name, "Entered");
        this.isValid = false;
        this.transport_.disconnect();
        this.transport_ = null;
        this.debug(3, method_name, "Leaving");
    }

    public void login(String client_tr_id) throws epp_XMLException, epp_Exception {
        this.login(client_tr_id, null);
    }

    public void login(String client_tr_id, String epp_client_id, String epp_password) throws epp_XMLException, epp_Exception {
        this.setEPPClientID(epp_client_id);
        this.setEPPPassword(epp_password);
        this.login(client_tr_id, null);
    }

    public void login(String client_tr_id, String client_id, String password, String new_password) throws epp_XMLException, epp_Exception {
        this.setEPPClientID(client_id);
        this.setEPPPassword(password);
        this.login(client_tr_id, new_password);
    }

    public void login(String client_tr_id, String new_password) throws epp_XMLException, epp_Exception {
        String method_name = "login()";
        this.debug(3, method_name, "Entered");
        epp_Command command_data = new epp_Command(null, client_tr_id);
        if (this.sendver_) {
            epp_Extension[] exts = new epp_Extension[]{new RTKVersion()};
            command_data.setExtensions(exts);
        }
        epp_LoginReq login_req = new epp_LoginReq(command_data, this.epp_client_id_, this.epp_password_, new_password, new epp_Options(this.version_, this.lang_), null, null);
        if (this.epp_services_ != null) {
            login_req.setServices(this.epp_services_);
        } else {
            String[] services = new String[]{"urn:ietf:params:xml:ns:contact-1.0", "urn:ietf:params:xml:ns:domain-1.0", "urn:ietf:params:xml:ns:host-1.0"};
            login_req.setServices(services);
        }
        if (this.epp_service_extensions_ != null) {
            login_req.setExtensions(this.epp_service_extensions_);
        }
        login_req.setCmd(command_data);
        EPPLogin login_action = new EPPLogin();
        login_action.setRequestData(login_req);
        try {
            this.processAction(login_action);
        }
        catch (epp_XMLException e) {
            this.isValid = false;
            throw e;
        }
        catch (epp_Exception e) {
            this.isValid = false;
            throw e;
        }
        this.debug(3, method_name, "Leaving");
    }

    public void logout(String client_trid) throws epp_XMLException, epp_Exception {
        String method_name = "logout()";
        this.debug(3, method_name, "Entered");
        EPPLogout logout_action = new EPPLogout();
        epp_LogoutReq logout_request = new epp_LogoutReq();
        logout_request.m_client_trid = client_trid;
        logout_action.setRequestData(logout_request);
        this.processAction(logout_action);
        this.debug(3, method_name, "Leaving");
    }

    public boolean isVersionSentOnLogin() {
        return this.sendver_;
    }

    public void setVersionSentOnLogin(boolean send) {
        this.sendver_ = send;
    }

    public epp_PollRsp poll(String client_tr_id) throws epp_XMLException, epp_Exception {
        return this.poll(client_tr_id, null);
    }

    public epp_PollRsp poll(String client_tr_id, String message_id) throws epp_XMLException, epp_Exception {
        epp_Command command_data;
        String method_name = "poll()";
        this.debug(3, method_name, "Entered");
        epp_PollReq poll_request = new epp_PollReq();
        poll_request.m_cmd = command_data = new epp_Command(null, client_tr_id);
        if (message_id == null) {
            poll_request.m_op = epp_PollOpType.REQ;
        } else {
            poll_request.m_op = epp_PollOpType.ACK;
            poll_request.m_msgID = message_id;
        }
        EPPPoll poll = new EPPPoll();
        poll.setRequestData(poll_request);
        poll = (EPPPoll)this.processAction(poll);
        epp_PollRsp poll_response = poll.getResponseData();
        this.debug(3, method_name, "Leaving");
        return poll_response;
    }
}

