/*
 * Decompiled with CFR 0.152.
 */
package com.tucows.oxrs.epp0604.rtk.xml;

import com.tucows.oxrs.epp0604.rtk.RTKBase;
import com.tucows.oxrs.epp0604.rtk.xml.EPPXMLErrors;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.openrtk.idl.epp0604.epp_AuthInfo;
import org.openrtk.idl.epp0604.epp_AuthInfoType;
import org.openrtk.idl.epp0604.epp_CheckResult;
import org.openrtk.idl.epp0604.epp_Credentials;
import org.openrtk.idl.epp0604.epp_Extension;
import org.openrtk.idl.epp0604.epp_MessageQueue;
import org.openrtk.idl.epp0604.epp_Response;
import org.openrtk.idl.epp0604.epp_Result;
import org.openrtk.idl.epp0604.epp_ResultData;
import org.openrtk.idl.epp0604.epp_ResultValue;
import org.openrtk.idl.epp0604.epp_StatusResultData;
import org.openrtk.idl.epp0604.epp_TransID;
import org.openrtk.idl.epp0604.epp_TransferStatusType;
import org.openrtk.idl.epp0604.epp_XMLException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class EPPXMLBase
extends RTKBase {
    protected static String[] transfer_op_to_string_array_ = new String[]{"approve", "cancel", "query", "reject", "request"};
    protected static Hashtable transfer_status_to_type_hash_;
    public static String[] auth_type_to_string_array_;
    protected static Hashtable auth_type_string_to_type_hash_;
    protected String xml_;

    protected EPPXMLBase() {
        EPPXMLBase.initHashes();
    }

    protected EPPXMLBase(String xml) {
        this.xml_ = xml;
        EPPXMLBase.initHashes();
    }

    public String getXML() {
        return this.xml_;
    }

    public static void initHashes() {
        EPPXMLBase.initTransferStatusToTypeHash();
        EPPXMLBase.initAuthInfoStringToTypeHash();
    }

    public static void initTransferStatusToTypeHash() {
        if (transfer_status_to_type_hash_ == null) {
            transfer_status_to_type_hash_ = new Hashtable();
            transfer_status_to_type_hash_.put("clientapproved", epp_TransferStatusType.CLIENT_APPROVED);
            transfer_status_to_type_hash_.put("clientcancelled", epp_TransferStatusType.CLIENT_CANCELLED);
            transfer_status_to_type_hash_.put("clientrejected", epp_TransferStatusType.CLIENT_REJECTED);
            transfer_status_to_type_hash_.put("pending", epp_TransferStatusType.PENDING);
            transfer_status_to_type_hash_.put("serverapproved", epp_TransferStatusType.SERVER_APPROVED);
            transfer_status_to_type_hash_.put("servercancelled", epp_TransferStatusType.SERVER_CANCELLED);
        }
    }

    public static void initAuthInfoStringToTypeHash() {
        if (auth_type_string_to_type_hash_ == null) {
            auth_type_string_to_type_hash_ = new Hashtable();
            auth_type_string_to_type_hash_.put("pw", epp_AuthInfoType.PW);
        }
    }

    protected epp_Response parseGenericResult(Node response_node) throws epp_XMLException {
        String method_name = "parseGenericResult(Node)";
        this.debug(3, method_name, "Entered");
        epp_Response generic_response = new epp_Response();
        NodeList result_nodes = ((Element)response_node).getElementsByTagName("result");
        ArrayList<epp_Result> results = new ArrayList<epp_Result>();
        if (result_nodes.getLength() > 0) {
            for (int count1 = 0; count1 < result_nodes.getLength(); ++count1) {
                NodeList data_nodes;
                Element an_element = (Element)result_nodes.item(count1);
                epp_Result result = new epp_Result();
                result.m_code = Short.parseShort(an_element.getAttribute("code"));
                Node msg_node = an_element.getElementsByTagName("msg").item(0);
                result.m_lang = ((Element)msg_node).getAttribute("lang");
                result.m_msg = msg_node.getFirstChild().getNodeValue();
                NodeList value_nodes = an_element.getElementsByTagName("value");
                ArrayList<epp_ResultValue> values = new ArrayList<epp_ResultValue>();
                if (value_nodes.getLength() > 0) {
                    for (int count2 = 0; count2 < value_nodes.getLength(); ++count2) {
                        Node value_node = value_nodes.item(count2);
                        epp_ResultValue value = new epp_ResultValue(null, value_node.getFirstChild().getNodeValue(), null, value_node.getFirstChild().getNodeValue());
                        values.add(value);
                    }
                    result.m_values = (epp_ResultValue[])EPPXMLBase.convertListToArray(new epp_ResultValue().getClass(), values);
                }
                if ((data_nodes = an_element.getElementsByTagName("data")) != null && data_nodes.getLength() != 0) {
                    Node data_node = data_nodes.item(0);
                    Node status_node = ((Element)data_node).getElementsByTagName("status").item(0);
                    Node cltrid_node = ((Element)status_node).getElementsByTagName("clTRID").item(0);
                    result.m_data = new epp_ResultData(new epp_StatusResultData());
                    String ack_value = ((Element)cltrid_node).getAttribute("ack");
                    result.m_data.m_status.m_ack = ack_value.equals("1");
                    result.m_data.m_status.m_cltrid = cltrid_node.getFirstChild().getNodeValue();
                } else {
                    result.m_data = null;
                }
                results.add(result);
            }
        } else {
            throw new epp_XMLException("missing result text in response");
        }
        generic_response.m_results = (epp_Result[])EPPXMLBase.convertListToArray(new epp_Result().getClass(), results);
        NodeList extension_nodes = ((Element)response_node).getElementsByTagName("extension");
        if (extension_nodes.getLength() == 0) {
            generic_response.m_extension_strings = null;
        } else {
            Node extension_node = extension_nodes.item(0);
            DocumentImpl udoc = new DocumentImpl();
            udoc.appendChild(udoc.importNode(extension_node, true));
            try {
                String extension_string = this.createXMLFromDoc((Document)udoc);
                RE regexp = new RE("<extension>(.*)</extension>$");
                regexp.match(extension_string);
            }
            catch (IOException ioe) {
                throw new epp_XMLException("IOException in building XML [" + ioe.getMessage() + "]");
            }
            catch (RESyntaxException xcp) {
                throw new epp_XMLException("Bad regexp when trying to parse Extension [" + xcp.getMessage() + "]");
            }
        }
        epp_TransID trans_id = new epp_TransID();
        NodeList trans_id_nodes = ((Element)response_node).getElementsByTagName("trID");
        if (trans_id_nodes.getLength() == 0) {
            throw new epp_XMLException("missing result trans id");
        }
        Node trans_id_node = trans_id_nodes.item(0);
        NodeList inner_nodes = trans_id_node.getChildNodes();
        for (int count = 0; count < inner_nodes.getLength(); ++count) {
            Node a_node = inner_nodes.item(count);
            if (a_node.getNodeName().equals("clTRID")) {
                trans_id.m_client_trid = a_node.getFirstChild().getNodeValue();
            }
            if (!a_node.getNodeName().equals("svTRID")) continue;
            trans_id.m_server_trid = a_node.getFirstChild().getNodeValue();
        }
        generic_response.m_trans_id = trans_id;
        NodeList msg_queue_nodes = ((Element)response_node).getElementsByTagName("msgQ");
        if (msg_queue_nodes.getLength() > 0) {
            epp_MessageQueue msg_queue = new epp_MessageQueue();
            Element msg_queue_element = (Element)msg_queue_nodes.item(0);
            msg_queue.m_count = Integer.parseInt(msg_queue_element.getAttribute("count"));
            msg_queue.m_id = msg_queue_element.getAttribute("id");
            NodeList queue_date_nodes = msg_queue_element.getElementsByTagName("qDate");
            if (queue_date_nodes.getLength() > 0) {
                msg_queue.m_queue_date = queue_date_nodes.item(0).getFirstChild().getNodeValue();
            }
            generic_response.m_message_queue = msg_queue;
        }
        this.debug(3, method_name, "Leaving");
        return generic_response;
    }

    protected Node getNode(NodeList node_list, String node_name) {
        String method_name = "getNode(NodeList,String)";
        this.debug(3, method_name, "Entered");
        Node desired_node = null;
        for (int count = 0; count < node_list.getLength(); ++count) {
            Node a_node = node_list.item(count);
            this.debug(2, method_name, "Node's name [" + a_node.getNodeName() + "]");
            if (!a_node.getNodeName().equals(node_name)) continue;
            this.debug(2, method_name, "Found desired_node node");
            desired_node = a_node;
            break;
        }
        this.debug(3, method_name, "Leaving");
        return desired_node;
    }

    protected Element getElement(NodeList node_list, String node_name) {
        String method_name = "getNode(NodeList,String)";
        this.debug(3, method_name, "Entered");
        this.debug(3, method_name, "Leaving");
        return (Element)this.getNode(node_list, node_name);
    }

    protected Element getDocumentElement() throws IOException, SAXException {
        String method_name = "getDocumentElement()";
        this.debug(3, method_name, "Entered");
        DOMParser parser = new DOMParser();
        EPPXMLErrors errors = new EPPXMLErrors();
        parser.setErrorHandler((ErrorHandler)errors);
        parser.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", true);
        parser.setFeature("http://apache.org/xml/features/continue-after-fatal-error", false);
        parser.setFeature("http://apache.org/xml/features/dom/include-ignorable-whitespace", false);
        if (this.xml_ != null) {
            try {
                RE regexp = new RE(">\\s+<");
                this.xml_ = regexp.subst(this.xml_, "><", 0);
            }
            catch (RESyntaxException xcp) {
                System.out.println("apparently, a bad regex!  The nerve!");
            }
        }
        parser.parse(new InputSource(new ByteArrayInputStream(this.xml_.getBytes())));
        Document document = parser.getDocument();
        if (!document.isSupported("Traversal", "2.0")) {
            throw new RuntimeException("This DOM Document does not support Traversal");
        }
        Element epp_node = document.getDocumentElement();
        this.debug(3, method_name, "Leaving");
        return epp_node;
    }

    protected Element createDocRoot(Document doc) {
        String method_name = "createDocRoot()";
        this.debug(3, method_name, "Entered");
        Element root = doc.createElement("epp");
        root.setAttribute("xmlns", "urn:ietf:params:xml:ns:epp-1.0");
        root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        root.setAttribute("xsi:schemaLocation", "urn:ietf:params:xml:ns:epp-1.0 epp-1.0.xsd");
        this.debug(3, method_name, "Leaving");
        return root;
    }

    protected String createXMLFromDoc(Document doc) throws IOException {
        String method_name = "createXMLFromDoc()";
        this.debug(3, method_name, "Entered");
        OutputFormat format = new OutputFormat(doc);
        StringWriter stringOut = new StringWriter();
        XMLSerializer serial = new XMLSerializer((Writer)stringOut, format);
        serial.asDOMSerializer();
        serial.serialize(doc.getDocumentElement());
        this.debug(3, method_name, "Leaving");
        return stringOut.toString();
    }

    protected Element addXMLElement(Document doc, Element containing_element, String tag_name, String value) {
        Element xml_element = doc.createElement(tag_name);
        if (value != null && value.length() != 0) {
            xml_element.appendChild(doc.createTextNode(value));
        }
        containing_element.appendChild(xml_element);
        return xml_element;
    }

    public static Object convertListToArray(Class the_class, List the_list) {
        Object[] the_array = (Object[])Array.newInstance(the_class, the_list.size());
        int index = 0;
        Iterator it = the_list.iterator();
        while (it.hasNext()) {
            the_array[index] = it.next();
            ++index;
        }
        return the_array;
    }

    public static String[] convertListToStringArray(List the_list) {
        String[] the_array = (String[])Array.newInstance(new String().getClass(), the_list.size());
        int index = 0;
        Iterator it = the_list.iterator();
        while (it.hasNext()) {
            the_array[index] = (String)it.next();
            ++index;
        }
        return the_array;
    }

    protected void stringListToXML(Document doc, Element wrapper, String tag_name, List list) {
        for (String string_value : list) {
            this.addXMLElement(doc, wrapper, tag_name, string_value);
        }
    }

    protected Element prepareCreds(Document doc, epp_Credentials creds) {
        Element creds_element = doc.createElement("creds");
        this.addXMLElement(doc, creds_element, "clID", creds.m_client_id);
        this.addXMLElement(doc, creds_element, "pw", creds.m_password);
        if (creds.m_new_password != null) {
            this.addXMLElement(doc, creds_element, "newPW", creds.m_new_password);
        }
        if (creds.m_options != null) {
            Element options_element = doc.createElement("options");
            if (creds.m_options.m_version != null) {
                this.addXMLElement(doc, options_element, "version", creds.m_options.m_version);
            }
            if (creds.m_options.m_lang != null) {
                this.addXMLElement(doc, options_element, "lang", creds.m_options.m_lang);
            }
            creds_element.appendChild(options_element);
        }
        return creds_element;
    }

    protected Element prepareAuthInfo(Document doc, String tag_name, epp_AuthInfo auth_info) {
        Element auth_info_element = doc.createElement(tag_name);
        auth_info_element.appendChild(doc.createTextNode(auth_info.m_value));
        if (auth_info.m_type == null) {
            auth_info.m_type = epp_AuthInfoType.PW;
        }
        auth_info_element.setAttribute("type", auth_type_to_string_array_[auth_info.m_type.value()]);
        if (auth_info.m_roid != null) {
            auth_info_element.setAttribute("roid", auth_info.m_roid);
        }
        return auth_info_element;
    }

    protected epp_CheckResult[] parseGenericCheckResults(Node chkdata_node) throws epp_XMLException {
        String method_name = "parseGenericCheckResults(Node)";
        this.debug(3, method_name, "Entered");
        if (chkdata_node == null || chkdata_node.getChildNodes().getLength() == 0) {
            throw new epp_XMLException("missing check results");
        }
        NodeList check_result_list = chkdata_node.getChildNodes();
        this.debug(2, method_name, "chkData's node count [" + check_result_list.getLength() + "]");
        ArrayList<epp_CheckResult> check_list = new ArrayList<epp_CheckResult>();
        for (int count = 0; count < check_result_list.getLength(); ++count) {
            Node a_node = check_result_list.item(count);
            if (!a_node.getNodeName().endsWith(":cd")) continue;
            NodeList one_check_list = a_node.getChildNodes();
            if (one_check_list.getLength() == 0) {
                throw new epp_XMLException("missing check result");
            }
            epp_CheckResult chk_result = new epp_CheckResult();
            for (int i = 0; i < one_check_list.getLength(); ++i) {
                Node the_node = one_check_list.item(i);
                if (the_node.getNodeName().endsWith(":name") || the_node.getNodeName().endsWith(":id")) {
                    chk_result.m_value = the_node.getFirstChild().getNodeValue();
                    boolean bl = chk_result.m_avail = ((Element)the_node).getAttribute("avail").equals("1");
                }
                if (!the_node.getNodeName().endsWith(":reason")) continue;
                chk_result.m_reason = the_node.getFirstChild().getNodeValue();
                chk_result.m_lang = ((Element)the_node).getAttribute("lang");
            }
            check_list.add(chk_result);
        }
        this.debug(3, method_name, "Leaving");
        return (epp_CheckResult[])EPPXMLBase.convertListToArray(epp_CheckResult.class, check_list);
    }

    public static Boolean getCheckResultFor(epp_CheckResult[] check_results, String check_value) {
        Boolean wanted_result = EPPXMLBase.getAvailResultFor(check_results, check_value);
        if (wanted_result != null) {
            wanted_result = new Boolean(wanted_result == false);
        }
        return wanted_result;
    }

    public static Boolean getAvailResultFor(epp_CheckResult[] check_results, String check_value) {
        Boolean wanted_result = null;
        if (check_results != null) {
            for (int index = 0; index < check_results.length; ++index) {
                if (!check_results[index].m_value.equalsIgnoreCase(check_value)) continue;
                wanted_result = new Boolean(check_results[index].getAvail());
                break;
            }
        }
        return wanted_result;
    }

    protected Node getExtensionNode(String extension_string) throws IOException, SAXException {
        String method_name = "getExtensionElement()";
        this.debug(3, method_name, "Entered");
        DOMParser parser = new DOMParser();
        EPPXMLErrors errors = new EPPXMLErrors();
        parser.setErrorHandler((ErrorHandler)errors);
        parser.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", true);
        parser.setFeature("http://apache.org/xml/features/continue-after-fatal-error", false);
        parser.setFeature("http://apache.org/xml/features/dom/include-ignorable-whitespace", false);
        if (this.xml_ != null) {
            try {
                RE regexp = new RE("> +<");
                this.xml_ = regexp.subst(this.xml_, "><", 0);
                regexp = new RE(" *<[?].+[?]>");
                this.xml_ = regexp.subst(this.xml_, "", 0);
            }
            catch (RESyntaxException xcp) {
                System.out.println("apparently, a bad regex!  The nerve!");
            }
        }
        parser.parse(new InputSource(new ByteArrayInputStream(extension_string.getBytes())));
        Document document = parser.getDocument();
        if (!document.isSupported("Traversal", "2.0")) {
            throw new RuntimeException("This DOM Document does not support Traversal");
        }
        Element extension_node = document.getDocumentElement();
        this.debug(3, method_name, "Leaving");
        return extension_node;
    }

    protected void prepareExtensionElement(Document doc, Element command, epp_Extension[] extensions) throws epp_XMLException {
        String method_name = "prepareExtensionElement()";
        this.debug(3, method_name, "Entered");
        if (extensions != null) {
            for (int count = 0; count < extensions.length; ++count) {
                epp_Extension extension = extensions[count];
                String extension_string = extension.toXML();
                if (extension_string == null || extension_string.length() == 0) continue;
                try {
                    Element extension_element = doc.createElement("extension");
                    Node extension_node = this.getExtensionNode(extension_string);
                    if (extension_node != null) {
                        extension_node = doc.importNode(this.getExtensionNode(extension_string), true);
                        extension_element.appendChild(extension_node);
                    } else {
                        extension_element.appendChild(doc.createTextNode(extension_string));
                    }
                    command.appendChild(extension_element);
                    continue;
                }
                catch (Exception xcp) {
                    this.debug(1, method_name, xcp);
                    throw new epp_XMLException("error in extension XML [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
                }
            }
        }
        this.debug(3, method_name, "Leaving");
    }

    public static String transferStatusToString(epp_TransferStatusType status_type) {
        return status_type.toString();
    }

    public static epp_TransferStatusType transferStatusFromString(String s) {
        return (epp_TransferStatusType)transfer_status_to_type_hash_.get(s.toLowerCase());
    }

    static {
        auth_type_to_string_array_ = new String[]{"pw"};
    }
}

