/*
 * Decompiled with CFR 0.152.
 */
package com.tucows.oxrs.epp0604.rtk.xml;

import com.tucows.oxrs.epp0604.rtk.xml.EPPDomainBase;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.xerces.dom.DocumentImpl;
import org.openrtk.idl.epp0604.domain.epp_DomainContact;
import org.openrtk.idl.epp0604.domain.epp_DomainCreate;
import org.openrtk.idl.epp0604.domain.epp_DomainCreateReq;
import org.openrtk.idl.epp0604.domain.epp_DomainCreateRsp;
import org.openrtk.idl.epp0604.domain.epp_DomainPeriod;
import org.openrtk.idl.epp0604.epp_Command;
import org.openrtk.idl.epp0604.epp_Exception;
import org.openrtk.idl.epp0604.epp_XMLException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class EPPDomainCreate
extends EPPDomainBase
implements epp_DomainCreate {
    private epp_DomainCreateReq action_request_;
    private epp_DomainCreateRsp action_response_;

    public EPPDomainCreate() {
    }

    public EPPDomainCreate(String xml) throws epp_XMLException, epp_Exception {
        String method_name = "EPPDomainCreate(String)";
        this.debug(2, method_name, "xml is [" + xml + "]");
        this.fromXML(xml);
    }

    @Override
    public void setRequestData(epp_DomainCreateReq value) {
        this.action_request_ = value;
    }

    @Override
    public epp_DomainCreateRsp getResponseData() {
        return this.action_response_;
    }

    @Override
    public String toXML() throws epp_XMLException {
        String request_xml;
        String method_name = "buildRequestXML(EPPTransID)";
        this.debug(3, method_name, "Entered");
        if (this.action_request_ == null || this.action_request_.m_cmd == null || this.action_request_.m_name == null) {
            throw new epp_XMLException("missing request data or domain name");
        }
        DocumentImpl doc = new DocumentImpl();
        Element root = this.createDocRoot((Document)doc);
        Element command = doc.createElement("command");
        Element create = doc.createElement("create");
        epp_Command command_data = this.action_request_.m_cmd;
        if (command_data.m_creds != null) {
            command.appendChild(this.prepareCreds((Document)doc, command_data.m_creds));
        }
        Element domain_create = doc.createElement("domain:create");
        this.setCommonAttributes(domain_create);
        this.addXMLElement((Document)doc, domain_create, "domain:name", this.action_request_.m_name);
        if (this.action_request_.m_period != null) {
            epp_DomainPeriod domain_period = this.action_request_.m_period;
            Element period = this.addXMLElement((Document)doc, domain_create, "domain:period", Short.toString(domain_period.m_value));
            period.setAttribute("unit", domain_period.m_unit.toString());
        }
        if (this.action_request_.m_name_servers != null && this.action_request_.m_name_servers.length > 0) {
            List<String> servers = Arrays.asList(this.action_request_.m_name_servers);
            for (String server_name : servers) {
                this.addXMLElement((Document)doc, domain_create, "domain:ns", server_name);
            }
        }
        if (this.action_request_.m_registrant != null) {
            this.addXMLElement((Document)doc, domain_create, "domain:registrant", this.action_request_.m_registrant);
        }
        if (this.action_request_.m_contacts != null && this.action_request_.m_contacts.length > 0) {
            List<epp_DomainContact> contacts = Arrays.asList(this.action_request_.m_contacts);
            for (epp_DomainContact domain_contact : contacts) {
                Element contact_element = this.addXMLElement((Document)doc, domain_create, "domain:contact", domain_contact.m_id);
                contact_element.setAttribute("type", domain_contact.m_type.toString());
            }
        }
        if (this.action_request_.m_auth_info == null) {
            throw new epp_XMLException("missing auth info");
        }
        domain_create.appendChild(this.prepareAuthInfo((Document)doc, "domain:authInfo", this.action_request_.m_auth_info));
        create.appendChild(domain_create);
        command.appendChild(create);
        this.prepareExtensionElement((Document)doc, command, command_data.m_extensions);
        if (command_data.m_client_trid != null) {
            this.addXMLElement((Document)doc, command, "clTRID", command_data.m_client_trid);
        }
        root.appendChild(command);
        doc.appendChild(root);
        try {
            request_xml = this.createXMLFromDoc((Document)doc);
        }
        catch (IOException xcp) {
            throw new epp_XMLException("IOException in building XML [" + xcp.getMessage() + "]");
        }
        this.debug(3, method_name, "Leaving");
        return request_xml;
    }

    @Override
    public void fromXML(String xml) throws epp_XMLException, epp_Exception {
        String method_name = "fromXML()";
        this.debug(3, method_name, "Entered");
        this.xml_ = xml;
        try {
            Element epp_node = this.getDocumentElement();
            Node response_node = epp_node.getElementsByTagName("response").item(0);
            if (response_node == null) {
                throw new epp_XMLException("unparsable or missing response");
            }
            this.action_response_ = new epp_DomainCreateRsp();
            this.action_response_.m_rsp = this.parseGenericResult(response_node);
            if (this.action_response_.m_rsp.m_results[0].m_code >= 2000) {
                throw new epp_Exception(this.action_response_.m_rsp.m_results);
            }
            Element response_data_element = this.getElement(response_node.getChildNodes(), "resData");
            if (response_data_element == null) {
                throw new epp_XMLException("response is missing the resData element");
            }
            NodeList domain_create_data_list = response_data_element.getElementsByTagName("domain:creData").item(0).getChildNodes();
            this.debug(2, method_name, "domain:creData's node count [" + domain_create_data_list.getLength() + "]");
            if (domain_create_data_list == null || domain_create_data_list.getLength() == 0) {
                throw new epp_XMLException("missing domain create response data");
            }
            for (int count = 0; count < domain_create_data_list.getLength(); ++count) {
                Node a_node = domain_create_data_list.item(count);
                if (a_node.getNodeName().equals("domain:name")) {
                    this.action_response_.m_name = a_node.getFirstChild().getNodeValue();
                }
                if (a_node.getNodeName().equals("domain:crDate")) {
                    this.action_response_.m_creation_date = a_node.getFirstChild().getNodeValue();
                }
                if (!a_node.getNodeName().equals("domain:exDate")) continue;
                this.action_response_.m_expiration_date = a_node.getFirstChild().getNodeValue();
            }
        }
        catch (SAXException xcp) {
            this.debug(1, method_name, xcp);
            throw new epp_XMLException("unable to parse xml [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
        }
        catch (IOException xcp) {
            this.debug(1, method_name, xcp);
            throw new epp_XMLException("unable to parse xml [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
        }
    }
}

