/*
 * Decompiled with CFR 0.152.
 */
package com.tucows.oxrs.epp0604.rtk.transport;

import com.tucows.oxrs.epp0604.rtk.transport.EPPTransportBase;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.StringReader;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.openrtk.idl.epp0604.epp_Exception;
import org.openrtk.idl.epp0604.epp_Result;

public class EPPTransportTCP
extends EPPTransportBase {
    protected Socket socket_to_server_;
    protected BufferedInputStream reader_from_server_;
    protected BufferedOutputStream writer_to_server_;
    protected boolean preset_ = false;
    protected static final int INT_SZ = 4;

    public EPPTransportTCP() {
    }

    public EPPTransportTCP(Socket socket, int timeout) {
        this.socket_to_server_ = socket;
        this.epp_timeout_ = timeout > 0 ? timeout : 20000;
        this.preset_ = true;
    }

    public EPPTransportTCP(String host_name, int host_port, int timeout) {
        super(host_name, host_port, timeout > 0 ? timeout : 20000);
    }

    @Override
    public void connect() throws SocketException, IOException, UnknownHostException {
        String method_name = "connect()";
        this.debug(3, method_name, "Entered");
        if (!this.preset_) {
            this.socket_to_server_ = null;
            this.socket_to_server_ = new Socket(this.epp_host_name_, this.epp_host_port_);
        }
        this.socket_to_server_.setSoTimeout(this.epp_timeout_);
        this.reader_from_server_ = new BufferedInputStream(this.socket_to_server_.getInputStream());
        this.writer_to_server_ = new BufferedOutputStream(this.socket_to_server_.getOutputStream());
        this.debug(2, method_name, "Connected to [" + this.socket_to_server_.getInetAddress() + ":" + this.socket_to_server_.getPort() + "]");
        this.debug(3, method_name, "Leaving");
    }

    @Override
    public String readFromServer() throws epp_Exception {
        String value;
        String method_name = "readFromServer()";
        this.debug(3, method_name, "Entered");
        int len = 0;
        try {
            len = this.readBufferSize(this.reader_from_server_);
        }
        catch (Exception xcp) {
            this.debug(1, method_name, xcp);
            this.debug(3, method_name, "Read: [" + len + "] so far");
            epp_Result[] result = new epp_Result[]{new epp_Result()};
            result[0].m_code = (short)2600;
            result[0].m_msg = "Failed to read from server [" + xcp.getClass().toString() + "] [" + xcp.getMessage() + "]";
            throw new epp_Exception(result);
        }
        if (len <= 0) {
            this.debug(3, method_name, "Invalid length of EPP XML instance." + len);
            return null;
        }
        len -= 4;
        byte[] in_buf = null;
        try {
            in_buf = this.readInputBuffer(this.reader_from_server_, len);
        }
        catch (Exception xcp) {
            this.debug(1, method_name, xcp);
            String s = new String(in_buf);
            this.debug(3, method_name, "Read: [" + s + "] so far");
            epp_Result[] result = new epp_Result[]{new epp_Result()};
            result[0].m_code = (short)2600;
            result[0].m_msg = "Failed to read from server [" + xcp.getClass().toString() + "] [" + xcp.getMessage() + "]";
            throw new epp_Exception(result);
        }
        if (in_buf == null) {
            this.debug(1, method_name, "Failed reading EPP XML instance (in_buf == null).");
        }
        if ((value = new String(in_buf)) == null) {
            try {
                this.disconnect();
            }
            catch (IOException xcp) {
                this.debug(1, method_name, xcp);
                epp_Result[] result = new epp_Result[]{new epp_Result()};
                result[0].m_code = (short)2600;
                result[0].m_msg = "Failed to read from server [" + xcp.getClass().toString() + "] [" + xcp.getMessage() + "]";
                throw new epp_Exception(result);
            }
            epp_Result[] result = new epp_Result[]{new epp_Result()};
            result[0].m_code = (short)2601;
            result[0].m_msg = "Unexpected server disconnect";
            throw new epp_Exception(result);
        }
        return value;
    }

    @Override
    public void writeToServer(String xml_to_server) throws epp_Exception {
        String method_name = "writeToServer(String)";
        this.debug(3, method_name, "Entered");
        try {
            String line;
            BufferedReader reader_outbound_xml = new BufferedReader(new StringReader(xml_to_server));
            StringBuffer buf = new StringBuffer();
            while ((line = reader_outbound_xml.readLine()) != null) {
                if ((line = line.trim()).startsWith("#") || line.length() == 0) continue;
                if (!line.startsWith("<")) {
                    buf.append(' ');
                }
                if (!line.endsWith("?>")) {
                    buf.append(line);
                }
                if (!line.trim().endsWith("</epp>")) continue;
            }
            String final_xml = buf.toString();
            int len = final_xml.length();
            this.writeBufferSize(this.writer_to_server_, len + 4);
            this.writer_to_server_.write(final_xml.getBytes(), 0, len);
            this.writer_to_server_.flush();
        }
        catch (Exception xcp) {
            this.debug(1, method_name, xcp);
            epp_Result[] result = new epp_Result[]{new epp_Result()};
            result[0].m_code = (short)2600;
            result[0].m_msg = "Failed to write to server [" + xcp.getClass().toString() + "] [" + xcp.getMessage() + "]";
            throw new epp_Exception(result);
        }
        this.debug(3, method_name, "Leaving");
    }

    @Override
    public void disconnect() throws IOException {
        String method_name = "disconnect()";
        this.debug(3, method_name, "Entered");
        try {
            if (this.socket_to_server_ != null) {
                this.socket_to_server_.close();
            }
            this.socket_to_server_ = null;
            if (this.reader_from_server_ != null) {
                this.reader_from_server_.close();
            }
            this.reader_from_server_ = null;
            if (this.writer_to_server_ != null) {
                this.writer_to_server_.close();
            }
            this.writer_to_server_ = null;
        }
        catch (IOException xcp) {
            this.debug(1, method_name, xcp);
            throw xcp;
        }
        this.debug(3, method_name, "Leaving");
    }

    protected int readBufferSize(BufferedInputStream in) throws Exception {
        String method_name = "readBufferSize()";
        this.debug(3, method_name, "Entered");
        boolean inbuf_sz = false;
        byte[] in_buf = new byte[4];
        int len = 0;
        for (int bytesRead = 0; bytesRead < 4; bytesRead += len) {
            try {
                len = in.read(in_buf, bytesRead, 4 - bytesRead);
            }
            catch (IOException xcp) {
                if (xcp instanceof InterruptedIOException) {
                    throw xcp;
                }
                this.debug(1, method_name, xcp);
                return -1;
            }
            if (len >= 0) continue;
            this.debug(1, method_name, "EOF reading buffer size.");
            return -1;
        }
        this.debug(3, method_name, "Leaving");
        return (in_buf[0] & 0xFF) << 24 | (in_buf[1] & 0xFF) << 16 | (in_buf[2] & 0xFF) << 8 | in_buf[3] & 0xFF;
    }

    protected byte[] readInputBuffer(BufferedInputStream in, int inbuf_sz) throws Exception {
        String method_name = "readInputBuffer()";
        this.debug(3, method_name, "Entered");
        byte[] in_buf = new byte[inbuf_sz];
        int len = 0;
        for (int bytesRead = 0; bytesRead < inbuf_sz; bytesRead += len) {
            try {
                len = in.read(in_buf, bytesRead, inbuf_sz - bytesRead);
            }
            catch (IOException xcp) {
                if (xcp instanceof InterruptedIOException) {
                    throw xcp;
                }
                this.debug(1, method_name, xcp);
                return null;
            }
            if (len >= 0) continue;
            this.debug(1, method_name, "EOF reading buffer.");
            return null;
        }
        return in_buf;
    }

    protected void writeBufferSize(BufferedOutputStream out, int buf_sz) throws IOException {
        String method_name = "writeBufferSize()";
        this.debug(3, method_name, "Entered");
        byte[] out_buf = new byte[]{(byte)(0xFF & buf_sz >> 24), (byte)(0xFF & buf_sz >> 16), (byte)(0xFF & buf_sz >> 8), (byte)(0xFF & buf_sz)};
        out.write(out_buf, 0, 4);
    }
}

