/*
 * Decompiled with CFR 0.152.
 */
package com.tucows.oxrs.epp0503.rtk.xml;

import com.tucows.oxrs.epp0503.rtk.xml.EPPXMLBase;
import java.io.IOException;
import java.util.Hashtable;
import org.apache.xerces.dom.DocumentImpl;
import org.openrtk.idl.epp0503.epp_Command;
import org.openrtk.idl.epp0503.epp_Exception;
import org.openrtk.idl.epp0503.epp_Status;
import org.openrtk.idl.epp0503.epp_StatusCommandType;
import org.openrtk.idl.epp0503.epp_StatusReq;
import org.openrtk.idl.epp0503.epp_StatusRsp;
import org.openrtk.idl.epp0503.epp_XMLException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class EPPStatus
extends EPPXMLBase
implements epp_Status {
    private epp_StatusReq action_request_;
    private epp_StatusRsp action_response_;
    private static Hashtable status_command_to_string_hash_;

    public EPPStatus() {
        this.initHash();
    }

    public EPPStatus(String xml) throws epp_XMLException, epp_Exception {
        super(xml);
        String method_name = "EPPStatus(String)";
        this.debug(2, method_name, "xml is [" + xml + "]");
        this.initHash();
        this.fromXML(xml);
    }

    private void initHash() {
        if (status_command_to_string_hash_ == null) {
            status_command_to_string_hash_ = new Hashtable();
            status_command_to_string_hash_.put(epp_StatusCommandType.CREATE, "create");
            status_command_to_string_hash_.put(epp_StatusCommandType.DELETE, "delete");
            status_command_to_string_hash_.put(epp_StatusCommandType.RENEW, "renew");
            status_command_to_string_hash_.put(epp_StatusCommandType.TRANSFER, "transfer");
            status_command_to_string_hash_.put(epp_StatusCommandType.UPDATE, "update");
        }
    }

    @Override
    public void setRequestData(epp_StatusReq value) {
        this.action_request_ = value;
    }

    @Override
    public epp_StatusRsp getResponseData() {
        return this.action_response_;
    }

    @Override
    public String toXML() throws epp_XMLException {
        String request_xml;
        String method_name = "buildRequestXML()";
        this.debug(3, method_name, "Entered");
        if (this.action_request_ == null) {
            throw new epp_XMLException("missing request data");
        }
        DocumentImpl doc = new DocumentImpl();
        Element root = this.createDocRoot((Document)doc);
        Element command = doc.createElement("command");
        Element status = doc.createElement("status");
        epp_Command command_data = this.action_request_.m_cmd;
        if (command_data.m_creds != null) {
            command.appendChild(this.prepareCreds((Document)doc, command_data.m_creds));
        }
        if (this.action_request_.m_command == null) {
            throw new epp_XMLException("missing status command type (no default allowed)");
        }
        Element cltrid = this.addXMLElement((Document)doc, status, "clTRID", this.action_request_.m_client_trid);
        status.setAttribute("command", (String)status_command_to_string_hash_.get(this.action_request_.m_command));
        command.appendChild(status);
        this.prepareExtensionElement((Document)doc, command, command_data.m_extension);
        if (command_data.m_client_trid != null) {
            this.addXMLElement((Document)doc, command, "clTRID", command_data.m_client_trid);
        }
        root.appendChild(command);
        doc.appendChild(root);
        try {
            request_xml = this.createXMLFromDoc((Document)doc);
        }
        catch (IOException xcp) {
            throw new epp_XMLException("IOException in building XML [" + xcp.getMessage() + "]");
        }
        this.debug(3, method_name, "Leaving");
        return request_xml;
    }

    @Override
    public void fromXML(String xml) throws epp_XMLException, epp_Exception {
        String method_name = "fromXML()";
        this.debug(3, method_name, "Entered");
        this.xml_ = xml;
        try {
            Element epp_node = this.getDocumentElement();
            Node response_node = epp_node.getElementsByTagName("response").item(0);
            if (response_node == null) {
                throw new epp_XMLException("unparsable or missing response");
            }
            this.action_response_ = new epp_StatusRsp();
            this.action_response_.m_rsp = this.parseGenericResult(response_node);
            if (this.action_response_.m_rsp.m_results[0].m_code >= 2000) {
                throw new epp_Exception(this.action_response_.m_rsp.m_results);
            }
        }
        catch (SAXException xcp) {
            this.debug(1, method_name, xcp);
            throw new epp_XMLException("unable to parse xml [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
        }
        catch (IOException xcp) {
            this.debug(1, method_name, xcp);
            throw new epp_XMLException("unable to parse xml [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
        }
    }
}

