/*
 * Decompiled with CFR 0.152.
 */
package com.tucows.oxrs.epp0503.rtk.xml;

import com.tucows.oxrs.epp0503.rtk.xml.EPPContactBase;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.xerces.dom.DocumentImpl;
import org.openrtk.idl.epp0503.contact.epp_ContactStatus;
import org.openrtk.idl.epp0503.contact.epp_ContactUpdate;
import org.openrtk.idl.epp0503.contact.epp_ContactUpdateAddRemove;
import org.openrtk.idl.epp0503.contact.epp_ContactUpdateChange;
import org.openrtk.idl.epp0503.contact.epp_ContactUpdateReq;
import org.openrtk.idl.epp0503.contact.epp_ContactUpdateRsp;
import org.openrtk.idl.epp0503.epp_Command;
import org.openrtk.idl.epp0503.epp_Exception;
import org.openrtk.idl.epp0503.epp_XMLException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class EPPContactUpdate
extends EPPContactBase
implements epp_ContactUpdate {
    private epp_ContactUpdateReq action_request_;
    private epp_ContactUpdateRsp action_response_;

    public EPPContactUpdate() {
    }

    public EPPContactUpdate(String xml) throws epp_XMLException, epp_Exception {
        String method_name = "EPPContactUpdate(String)";
        this.debug(2, method_name, "xml is [" + xml + "]");
        this.fromXML(xml);
    }

    @Override
    public void setRequestData(epp_ContactUpdateReq value) {
        this.action_request_ = value;
    }

    @Override
    public epp_ContactUpdateRsp getResponseData() {
        return this.action_response_;
    }

    @Override
    public String toXML() throws epp_XMLException {
        String request_xml;
        Element change_element;
        Element remove_element;
        String method_name = "buildRequestXML()";
        this.debug(3, method_name, "Entered");
        if (this.action_request_ == null || this.action_request_.m_cmd == null || this.action_request_.m_id == null) {
            throw new epp_XMLException("missing request data or contact id");
        }
        DocumentImpl doc = new DocumentImpl();
        Element root = this.createDocRoot((Document)doc);
        Element command = doc.createElement("command");
        Element update = doc.createElement("update");
        epp_Command command_data = this.action_request_.m_cmd;
        if (command_data.m_creds != null) {
            command.appendChild(this.prepareCreds((Document)doc, command_data.m_creds));
        }
        Element contact_update = doc.createElement("contact:update");
        this.setCommonAttributes(contact_update);
        this.addXMLElement((Document)doc, contact_update, "contact:id", this.action_request_.m_id);
        Element add_element = this.getAddRemoveElement((Document)doc, this.action_request_.m_add, "contact:add");
        if (add_element != null) {
            contact_update.appendChild(add_element);
        }
        if ((remove_element = this.getAddRemoveElement((Document)doc, this.action_request_.m_remove, "contact:rem")) != null) {
            contact_update.appendChild(remove_element);
        }
        if ((change_element = this.getChangeElement((Document)doc, this.action_request_.m_change, "contact:chg")) != null) {
            contact_update.appendChild(change_element);
        }
        update.appendChild(contact_update);
        command.appendChild(update);
        this.prepareExtensionElement((Document)doc, command, command_data.m_extension);
        if (command_data.m_client_trid != null) {
            this.addXMLElement((Document)doc, command, "clTRID", command_data.m_client_trid);
        }
        root.appendChild(command);
        doc.appendChild(root);
        try {
            request_xml = this.createXMLFromDoc((Document)doc);
        }
        catch (IOException xcp) {
            throw new epp_XMLException("IOException in building XML [" + xcp.getMessage() + "]");
        }
        this.debug(3, method_name, "Leaving");
        return request_xml;
    }

    private Element getAddRemoveElement(Document doc, epp_ContactUpdateAddRemove add_remove_items, String tag_name) throws epp_XMLException {
        String method_name = "getAddRemoveElement(Document, epp_ContactUpdateAddRemove, String)";
        this.debug(3, method_name, "Entered");
        Element add_remove_element = null;
        if (add_remove_items != null && add_remove_items.m_status != null && add_remove_items.m_status.length > 0) {
            if (add_remove_element == null) {
                add_remove_element = doc.createElement(tag_name);
            }
            List<epp_ContactStatus> status_list = Arrays.asList(add_remove_items.m_status);
            for (epp_ContactStatus status : status_list) {
                Element status_element = this.addXMLElement(doc, add_remove_element, "contact:status", status.m_value);
                status_element.setAttribute("s", status.m_type.toString());
                if (status.m_lang == null) continue;
                status_element.setAttribute("lang", status.m_lang);
            }
        }
        this.debug(3, method_name, "Leaving");
        return add_remove_element;
    }

    private Element getChangeElement(Document doc, epp_ContactUpdateChange change, String tag_name) throws epp_XMLException {
        String method_name = "fromXML()";
        this.debug(3, method_name, "Entered");
        Element change_element = null;
        if (change != null) {
            Element voice;
            Element i15d_address;
            change_element = doc.createElement(tag_name);
            Element ascii_address = this.addressToXML(doc, "contact:ascii", change.m_ascii_address);
            if (ascii_address != null) {
                change_element.appendChild(ascii_address);
            }
            if ((i15d_address = this.addressToXML(doc, "contact:i15d", change.m_i15d_address)) != null) {
                change_element.appendChild(i15d_address);
            }
            if (change.m_voice != null) {
                voice = this.addXMLElement(doc, change_element, "contact:voice", change.m_voice.m_value);
                if (change.m_voice.m_extension != null) {
                    voice.setAttribute("x", change.m_voice.m_extension);
                }
            }
            if (change.m_fax != null) {
                voice = this.addXMLElement(doc, change_element, "contact:fax", change.m_fax.m_value);
                if (change.m_fax.m_extension != null) {
                    voice.setAttribute("x", change.m_fax.m_extension);
                }
            }
            if (change.m_email != null) {
                this.addXMLElement(doc, change_element, "contact:email", change.m_email);
            }
            if (change.m_auth_info != null) {
                change_element.appendChild(this.prepareAuthInfo(doc, "contact:authInfo", change.m_auth_info));
            }
        }
        this.debug(3, method_name, "Leaving");
        return change_element;
    }

    @Override
    public void fromXML(String xml) throws epp_XMLException, epp_Exception {
        String method_name = "fromXML()";
        this.debug(3, method_name, "Entered");
        this.xml_ = xml;
        try {
            Element epp_node = this.getDocumentElement();
            Node response_node = epp_node.getElementsByTagName("response").item(0);
            if (response_node == null) {
                throw new epp_XMLException("unparsable or missing response");
            }
            this.action_response_ = new epp_ContactUpdateRsp();
            this.action_response_.m_rsp = this.parseGenericResult(response_node);
            if (this.action_response_.m_rsp.m_results[0].m_code >= 2000) {
                throw new epp_Exception(this.action_response_.m_rsp.m_results);
            }
        }
        catch (SAXException xcp) {
            this.debug(1, method_name, xcp);
            throw new epp_XMLException("unable to parse xml [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
        }
        catch (IOException xcp) {
            this.debug(1, method_name, xcp);
            throw new epp_XMLException("unable to parse xml [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
        }
    }
}

