/*
 * Decompiled with CFR 0.152.
 */
package com.tucows.oxrs.epp0503.rtk.xml;

import com.tucows.oxrs.epp0503.rtk.xml.EPPContactBase;
import java.io.IOException;
import org.apache.xerces.dom.DocumentImpl;
import org.openrtk.idl.epp0503.contact.epp_ContactCreate;
import org.openrtk.idl.epp0503.contact.epp_ContactCreateReq;
import org.openrtk.idl.epp0503.contact.epp_ContactCreateRsp;
import org.openrtk.idl.epp0503.epp_Command;
import org.openrtk.idl.epp0503.epp_Exception;
import org.openrtk.idl.epp0503.epp_XMLException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class EPPContactCreate
extends EPPContactBase
implements epp_ContactCreate {
    private epp_ContactCreateReq action_request_;
    private epp_ContactCreateRsp action_response_;

    public EPPContactCreate() {
    }

    public EPPContactCreate(String xml) throws epp_XMLException, epp_Exception {
        String method_name = "EPPContactCreate(String)";
        this.debug(2, method_name, "xml is [" + xml + "]");
        this.fromXML(xml);
    }

    @Override
    public void setRequestData(epp_ContactCreateReq value) {
        this.action_request_ = value;
    }

    @Override
    public epp_ContactCreateRsp getResponseData() {
        return this.action_response_;
    }

    @Override
    public String toXML() throws epp_XMLException {
        String request_xml;
        Element voice;
        Element i15d_address;
        String method_name = "buildRequestXML(EPPTransID)";
        this.debug(3, method_name, "Entered");
        if (this.action_request_ == null || this.action_request_.m_cmd == null) {
            throw new epp_XMLException("missing request data");
        }
        DocumentImpl doc = new DocumentImpl();
        Element root = this.createDocRoot((Document)doc);
        Element command = doc.createElement("command");
        Element create = doc.createElement("create");
        epp_Command command_data = this.action_request_.m_cmd;
        if (command_data.m_creds != null) {
            command.appendChild(this.prepareCreds((Document)doc, command_data.m_creds));
        }
        Element contact_create = doc.createElement("contact:create");
        this.setCommonAttributes(contact_create);
        if (this.action_request_.m_id == null) {
            throw new epp_XMLException("missing contact id");
        }
        this.addXMLElement((Document)doc, contact_create, "contact:id", this.action_request_.m_id);
        Element ascii_address = this.addressToXML((Document)doc, "contact:ascii", this.action_request_.m_ascii_address);
        if (ascii_address != null) {
            contact_create.appendChild(ascii_address);
        }
        if ((i15d_address = this.addressToXML((Document)doc, "contact:i15d", this.action_request_.m_i15d_address)) != null) {
            contact_create.appendChild(i15d_address);
        }
        if (this.action_request_.m_voice != null) {
            voice = this.addXMLElement((Document)doc, contact_create, "contact:voice", this.action_request_.m_voice.m_value);
            if (this.action_request_.m_voice.m_extension != null) {
                voice.setAttribute("x", this.action_request_.m_voice.m_extension);
            }
        }
        if (this.action_request_.m_fax != null) {
            voice = this.addXMLElement((Document)doc, contact_create, "contact:fax", this.action_request_.m_fax.m_value);
            if (this.action_request_.m_fax.m_extension != null) {
                voice.setAttribute("x", this.action_request_.m_fax.m_extension);
            }
        }
        if (this.action_request_.m_email != null) {
            this.addXMLElement((Document)doc, contact_create, "contact:email", this.action_request_.m_email);
        }
        if (this.action_request_.m_auth_info == null) {
            throw new epp_XMLException("missing auth info");
        }
        contact_create.appendChild(this.prepareAuthInfo((Document)doc, "contact:authInfo", this.action_request_.m_auth_info));
        create.appendChild(contact_create);
        command.appendChild(create);
        this.prepareExtensionElement((Document)doc, command, command_data.m_extension);
        if (command_data.m_client_trid != null) {
            this.addXMLElement((Document)doc, command, "clTRID", command_data.m_client_trid);
        }
        root.appendChild(command);
        doc.appendChild(root);
        try {
            request_xml = this.createXMLFromDoc((Document)doc);
        }
        catch (IOException xcp) {
            throw new epp_XMLException("IOException in building XML [" + xcp.getMessage() + "]");
        }
        this.debug(3, method_name, "Leaving");
        return request_xml;
    }

    @Override
    public void fromXML(String xml) throws epp_XMLException, epp_Exception {
        String method_name = "fromXML()";
        this.debug(3, method_name, "Entered");
        this.xml_ = xml;
        try {
            Element epp_node = this.getDocumentElement();
            Node response_node = epp_node.getElementsByTagName("response").item(0);
            if (response_node == null) {
                throw new epp_XMLException("unparsable or missing response");
            }
            this.action_response_ = new epp_ContactCreateRsp();
            this.action_response_.m_rsp = this.parseGenericResult(response_node);
            if (this.action_response_.m_rsp.m_results[0].m_code >= 2000) {
                throw new epp_Exception(this.action_response_.m_rsp.m_results);
            }
            Element response_data_element = this.getElement(response_node.getChildNodes(), "resData");
            if (response_data_element == null) {
                throw new epp_XMLException("response is missing the resData element");
            }
            NodeList contact_create_data_list = response_data_element.getElementsByTagName("contact:creData").item(0).getChildNodes();
            this.debug(2, method_name, "contact:creData's node count [" + contact_create_data_list.getLength() + "]");
            if (contact_create_data_list == null || contact_create_data_list.getLength() == 0) {
                throw new epp_XMLException("missing contact create response data");
            }
            for (int count = 0; count < contact_create_data_list.getLength(); ++count) {
                Node a_node = contact_create_data_list.item(count);
                if (a_node.getNodeName().equals("contact:id")) {
                    this.action_response_.m_id = a_node.getFirstChild().getNodeValue();
                }
                if (!a_node.getNodeName().equals("contact:crDate")) continue;
                this.action_response_.m_creation_date = a_node.getFirstChild().getNodeValue();
            }
        }
        catch (SAXException xcp) {
            this.debug(1, method_name, xcp);
            throw new epp_XMLException("unable to parse xml [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
        }
        catch (IOException xcp) {
            this.debug(1, method_name, xcp);
            throw new epp_XMLException("unable to parse xml [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
        }
    }
}

