/*
 * Decompiled with CFR 0.152.
 */
package com.tucows.oxrs.epp0503.rtk.transport;

import com.tucows.oxrs.epp0503.rtk.transport.EPPTransportTCP;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.Properties;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;

public class EPPTransportTCPTLS
extends EPPTransportTCP {
    private SSLContext ctx_ = null;
    private KeyStore ks_ = null;
    private KeyManagerFactory kmf_ = null;
    private SecureRandom rnd_ = null;

    public EPPTransportTCPTLS() {
    }

    public EPPTransportTCPTLS(String host_name, int host_port, int timeout) {
        super(host_name, host_port, timeout);
    }

    @Override
    public void connect() throws SocketException, IOException, UnknownHostException {
        String method_name = "connect()";
        this.debug(3, method_name, "Entered");
        if (!this.preset_) {
            this.socket_to_server_ = null;
            this.debug(2, method_name, "Using SSL/TLS");
            Properties system_props = System.getProperties();
            String ssl_props_location = system_props.getProperty("ssl.props.location");
            if (ssl_props_location == null || ssl_props_location.length() == 0) {
                throw new IOException("No ssl props location specified");
            }
            Properties ssl_props = new Properties();
            ssl_props.load(new FileInputStream(ssl_props_location + "/ssl.properties"));
            SSLSocketFactory ssl_factory = null;
            try {
                char[] passphrase1 = ((String)ssl_props.get("ssl.keystore.passphrase")).toCharArray();
                char[] passphrase2 = ((String)ssl_props.get("ssl.signedcert.passphrase")).toCharArray();
                if (this.ctx_ == null) {
                    this.ctx_ = SSLContext.getInstance((String)ssl_props.get("ssl.protocol"));
                }
                if (this.ks_ == null) {
                    this.ks_ = KeyStore.getInstance((String)ssl_props.get("ssl.keystore.format"));
                    this.ks_.load(new FileInputStream(ssl_props_location + "/" + (String)ssl_props.get("ssl.keystore.file")), passphrase1);
                }
                if (this.kmf_ == null) {
                    this.kmf_ = KeyManagerFactory.getInstance((String)ssl_props.get("ssl.keymanagerfactory.format"));
                    this.kmf_.init(this.ks_, passphrase2);
                }
                try {
                    byte[] seed = new byte[1024];
                    FileInputStream is = new FileInputStream("/dev/urandom");
                    is.read(seed);
                    is.close();
                    this.rnd_ = SecureRandom.getInstance("SHA1PRNG");
                    this.rnd_.setSeed(seed);
                    this.debug(2, method_name, "SecureRandom seed set.");
                }
                catch (Exception xcp) {
                    this.debug(2, method_name, "Error initializing SecureRandom [" + xcp.getMessage() + "], using default initialization.");
                    this.rnd_ = null;
                }
                this.ctx_.init(this.kmf_.getKeyManagers(), null, this.rnd_);
                ssl_factory = this.ctx_.getSocketFactory();
            }
            catch (Exception xcp) {
                throw new IOException(xcp.getMessage());
            }
            this.socket_to_server_ = ssl_factory.createSocket(this.epp_host_name_, this.epp_host_port_);
        }
        this.socket_to_server_.setSoTimeout(this.epp_timeout_);
        this.reader_from_server_ = new BufferedReader(new InputStreamReader(this.socket_to_server_.getInputStream()));
        this.writer_to_server_ = new PrintWriter((Writer)new OutputStreamWriter(this.socket_to_server_.getOutputStream()), true);
        this.debug(2, method_name, "Connected to [" + this.socket_to_server_.getInetAddress() + ":" + this.socket_to_server_.getPort() + "]");
        this.debug(3, method_name, "Leaving");
    }
}

