/*
 * Decompiled with CFR 0.152.
 */
package com.tucows.oxrs.epp0503.rtk.example;

import com.tucows.oxrs.epp0503.rtk.EPPClient;
import com.tucows.oxrs.epp0503.rtk.RTKBase;
import com.tucows.oxrs.epp0503.rtk.xml.EPPContactCreate;
import com.tucows.oxrs.epp0503.rtk.xml.EPPDomainCheck;
import com.tucows.oxrs.epp0503.rtk.xml.EPPDomainCreate;
import com.tucows.oxrs.epp0503.rtk.xml.EPPDomainDelete;
import com.tucows.oxrs.epp0503.rtk.xml.EPPDomainInfo;
import com.tucows.oxrs.epp0503.rtk.xml.EPPDomainRenew;
import com.tucows.oxrs.epp0503.rtk.xml.EPPDomainTransfer;
import com.tucows.oxrs.epp0503.rtk.xml.EPPDomainUpdate;
import com.tucows.oxrs.epp0503.rtk.xml.EPPPoll;
import com.tucows.oxrs.epp0503.rtk.xml.EPPXMLBase;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.Random;
import java.util.Vector;
import org.openrtk.idl.epp0503.contact.epp_ContactAddress;
import org.openrtk.idl.epp0503.contact.epp_ContactCreateReq;
import org.openrtk.idl.epp0503.contact.epp_ContactCreateRsp;
import org.openrtk.idl.epp0503.contact.epp_ContactNameAddress;
import org.openrtk.idl.epp0503.domain.epp_DomainCheckReq;
import org.openrtk.idl.epp0503.domain.epp_DomainCheckRsp;
import org.openrtk.idl.epp0503.domain.epp_DomainContact;
import org.openrtk.idl.epp0503.domain.epp_DomainContactType;
import org.openrtk.idl.epp0503.domain.epp_DomainCreateReq;
import org.openrtk.idl.epp0503.domain.epp_DomainCreateRsp;
import org.openrtk.idl.epp0503.domain.epp_DomainDeleteReq;
import org.openrtk.idl.epp0503.domain.epp_DomainDeleteRsp;
import org.openrtk.idl.epp0503.domain.epp_DomainInfoReq;
import org.openrtk.idl.epp0503.domain.epp_DomainInfoRsp;
import org.openrtk.idl.epp0503.domain.epp_DomainPeriod;
import org.openrtk.idl.epp0503.domain.epp_DomainPeriodUnitType;
import org.openrtk.idl.epp0503.domain.epp_DomainRenewReq;
import org.openrtk.idl.epp0503.domain.epp_DomainRenewRsp;
import org.openrtk.idl.epp0503.domain.epp_DomainStatus;
import org.openrtk.idl.epp0503.domain.epp_DomainStatusType;
import org.openrtk.idl.epp0503.domain.epp_DomainTransferReq;
import org.openrtk.idl.epp0503.domain.epp_DomainTransferRsp;
import org.openrtk.idl.epp0503.domain.epp_DomainUpdateAddRemove;
import org.openrtk.idl.epp0503.domain.epp_DomainUpdateChange;
import org.openrtk.idl.epp0503.domain.epp_DomainUpdateReq;
import org.openrtk.idl.epp0503.domain.epp_DomainUpdateRsp;
import org.openrtk.idl.epp0503.epp_AuthInfo;
import org.openrtk.idl.epp0503.epp_AuthInfoType;
import org.openrtk.idl.epp0503.epp_CheckResult;
import org.openrtk.idl.epp0503.epp_Command;
import org.openrtk.idl.epp0503.epp_Exception;
import org.openrtk.idl.epp0503.epp_Greeting;
import org.openrtk.idl.epp0503.epp_PollOpType;
import org.openrtk.idl.epp0503.epp_PollReq;
import org.openrtk.idl.epp0503.epp_PollRsp;
import org.openrtk.idl.epp0503.epp_Response;
import org.openrtk.idl.epp0503.epp_Result;
import org.openrtk.idl.epp0503.epp_TransferOpType;
import org.openrtk.idl.epp0503.epp_TransferRequest;
import org.openrtk.idl.epp0503.epp_XMLException;

public class DomainExample {
    private static String USAGE = "Usage: com.tucows.oxrs.epp0503.rtk.example.DomainExample epp_host_name epp_host_port epp_client_id epp_password epp_domain_name";

    public static void main(String[] args) {
        System.out.println("Start of the Domain example");
        epp_Command command_data = null;
        epp_AuthInfo domain_auth_info = null;
        Date domain_exp_date = null;
        try {
            epp_Result[] results;
            epp_Result[] results2;
            epp_Response response;
            epp_Result[] results3;
            epp_Response response2;
            epp_Result[] results4;
            if (args.length < 5) {
                System.err.println(USAGE);
                System.exit(1);
            }
            RTKBase.setDebugLevel();
            String epp_host_name = args[0];
            String epp_host_port_string = args[1];
            String epp_client_id = args[2];
            String epp_password = args[3];
            String epp_domain_name = args[4];
            int epp_host_port = Integer.parseInt(epp_host_port_string);
            EPPClient epp_client = new EPPClient(epp_host_name, epp_host_port, epp_client_id, epp_password);
            epp_client.setLang("en");
            System.out.println("Connecting to the EPP Server and getting the greeting");
            epp_Greeting greeting = epp_client.connectAndGetGreeting();
            System.out.println("greeting's server: [" + greeting.m_server_id + "]");
            System.out.println("greeting's server-date: [" + greeting.m_server_date + "]");
            System.out.println("greeting's service menu: [" + greeting.getSvcMenu() + "]");
            System.out.println();
            String client_trid = DomainExample.getClientTrid(epp_client_id);
            System.out.println("Logging into the EPP Server");
            epp_client.login(client_trid);
            try {
                System.out.println("Creating the Poll command");
                epp_PollReq poll_request = new epp_PollReq();
                command_data = new epp_Command();
                command_data.m_client_trid = DomainExample.getClientTrid(epp_client_id);
                poll_request.m_cmd = command_data;
                poll_request.m_op = epp_PollOpType.REQ;
                EPPPoll poll = new EPPPoll();
                poll.setRequestData(poll_request);
                poll = (EPPPoll)epp_client.processAction(poll);
                epp_PollRsp poll_response = poll.getResponseData();
                epp_Response response3 = poll_response.m_rsp;
                epp_Result[] results5 = response3.m_results;
                System.out.println("Poll results: [" + results5[0].m_code + "] [" + results5[0].m_msg + "]");
            }
            catch (epp_XMLException xcp) {
                System.err.println("epp_XMLException! [" + xcp.m_error_message + "]");
            }
            catch (epp_Exception xcp) {
                System.err.println("epp_Exception!");
                results4 = xcp.m_details;
                System.err.println("\tcode: [" + results4[0].m_code + "] lang: [" + results4[0].m_lang + "] msg: [" + results4[0].m_msg + "]");
                if (results4[0].m_values != null && results4[0].m_values.length > 0) {
                    System.err.println("\tvalue: [" + results4[0].m_values[0] + "]");
                }
            }
            catch (Exception xcp) {
                System.err.println("EPP Poll failed! [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
                xcp.printStackTrace();
            }
            try {
                System.out.println("Creating the Domain Check command");
                epp_DomainCheckReq domain_check_request = new epp_DomainCheckReq();
                command_data = new epp_Command();
                command_data.m_client_trid = DomainExample.getClientTrid(epp_client_id);
                domain_check_request.m_cmd = command_data;
                ArrayList<String> domain_list = new ArrayList<String>();
                domain_list.add(epp_client_id + "1.info");
                domain_list.add(epp_client_id + "2.info");
                domain_list.add(epp_domain_name);
                domain_check_request.m_names = EPPXMLBase.convertListToStringArray(domain_list);
                EPPDomainCheck domain_check = new EPPDomainCheck();
                domain_check.setRequestData(domain_check_request);
                domain_check = (EPPDomainCheck)epp_client.processAction(domain_check);
                epp_DomainCheckRsp domain_check_response = domain_check.getResponseData();
                response2 = domain_check_response.m_rsp;
                results3 = response2.m_results;
                System.out.println("DomainCheck results: [" + results3[0].m_code + "] [" + results3[0].m_msg + "]");
                epp_CheckResult[] check_results = domain_check_response.m_results;
                System.out.println("DomainCheck results: domain [" + epp_client_id + "1.info] available? [" + EPPXMLBase.getAvailResultFor(check_results, epp_client_id + "1.info") + "]");
                System.out.println("DomainCheck results: domain [" + epp_client_id + "2.info] available? [" + EPPXMLBase.getAvailResultFor(check_results, epp_client_id + "2.info") + "]");
                System.out.println("DomainCheck results: domain [" + epp_domain_name + "] available? [" + EPPXMLBase.getAvailResultFor(check_results, epp_domain_name) + "]");
            }
            catch (epp_XMLException xcp) {
                System.err.println("epp_XMLException! [" + xcp.m_error_message + "]");
            }
            catch (epp_Exception xcp) {
                System.err.println("epp_Exception!");
                results4 = xcp.m_details;
                System.err.println("\tcode: [" + results4[0].m_code + "] lang: [" + results4[0].m_lang + "] msg: [" + results4[0].m_msg + "]");
                if (results4[0].m_values != null && results4[0].m_values.length > 0) {
                    System.err.println("\tvalue: [" + results4[0].m_values[0] + "]");
                }
            }
            catch (Exception xcp) {
                System.err.println("Domain Check failed! [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
                xcp.printStackTrace();
            }
            System.out.println("Creating the Contact Create command");
            epp_ContactCreateReq contact_create_request = new epp_ContactCreateReq();
            try {
                command_data = new epp_Command();
                command_data.m_client_trid = DomainExample.getClientTrid(epp_client_id);
                contact_create_request.m_cmd = command_data;
                Random rng = new Random();
                String randnum = "" + rng.nextInt() % 999999;
                while ((epp_client_id + randnum).length() > 16) {
                    randnum = randnum.substring(0, randnum.length() - 1);
                }
                contact_create_request.m_id = epp_client_id + randnum;
                epp_ContactNameAddress name_address = new epp_ContactNameAddress();
                name_address.m_name = "John Doe";
                name_address.m_address = new epp_ContactAddress();
                name_address.m_address.m_street1 = "100 Centre St";
                name_address.m_address.m_city = "Townsville";
                name_address.m_address.m_state_province = "County Derry";
                name_address.m_address.m_postal_code = "Z1Z1Z1";
                name_address.m_address.m_country_code = "CA";
                contact_create_request.m_ascii_address = name_address;
                contact_create_request.m_email = "jdoe@company.info";
                epp_AuthInfo contact_auth_info = new epp_AuthInfo();
                contact_auth_info.m_value = "changeme";
                contact_auth_info.m_type = epp_AuthInfoType.PW;
                contact_create_request.m_auth_info = contact_auth_info;
                EPPContactCreate contact_create = new EPPContactCreate();
                contact_create.setRequestData(contact_create_request);
                contact_create = (EPPContactCreate)epp_client.processAction(contact_create);
                epp_ContactCreateRsp contact_create_response = contact_create.getResponseData();
                response = contact_create_response.m_rsp;
                results2 = response.m_results;
                System.out.println("ContactCreate results: [" + results2[0].m_code + "] [" + results2[0].m_msg + "]");
                System.out.println("ContactCreate results: contact id [" + contact_create_response.m_id + "]");
            }
            catch (epp_XMLException xcp) {
                System.err.println("epp_XMLException! [" + xcp.m_error_message + "]");
            }
            catch (epp_Exception xcp) {
                System.err.println("epp_Exception!");
                results = xcp.m_details;
                System.err.println("\tresult: [" + results[0] + "]");
            }
            catch (Exception xcp) {
                System.err.println("Contact Create failed! [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
                xcp.printStackTrace();
            }
            try {
                System.out.println("Creating the Domain Create command");
                epp_DomainCreateReq domain_create_request = new epp_DomainCreateReq();
                command_data = new epp_Command();
                command_data.m_client_trid = DomainExample.getClientTrid(epp_client_id);
                domain_create_request.m_cmd = command_data;
                domain_create_request.m_name = epp_domain_name;
                domain_create_request.m_period = new epp_DomainPeriod();
                domain_create_request.m_period.m_unit = epp_DomainPeriodUnitType.YEAR;
                domain_create_request.m_period.m_value = (short)2;
                ArrayList<String> name_server_list = new ArrayList<String>();
                name_server_list.add("ns1.domaindirect.com");
                name_server_list.add("ns2.domaindirect.com");
                domain_create_request.m_name_servers = EPPXMLBase.convertListToStringArray(name_server_list);
                BufferedReader buffed_reader = new BufferedReader(new InputStreamReader(System.in));
                domain_auth_info = new epp_AuthInfo();
                System.out.print("Dear registrant, please enter a passphrase for your new domain(min 6, max 16): ");
                while (domain_auth_info.m_value == null || domain_auth_info.m_value.length() == 0) {
                    domain_auth_info.m_value = buffed_reader.readLine();
                }
                domain_auth_info.m_type = epp_AuthInfoType.PW;
                domain_create_request.m_auth_info = domain_auth_info;
                Vector<epp_DomainContact> contacts = new Vector<epp_DomainContact>();
                contacts.add(new epp_DomainContact(epp_DomainContactType.TECH, "ABC-contact"));
                contacts.add(new epp_DomainContact(epp_DomainContactType.ADMIN, "ABC-contact"));
                contacts.add(new epp_DomainContact(epp_DomainContactType.BILLING, "ABC-contact"));
                domain_create_request.m_contacts = contacts.toArray(new epp_DomainContact[1]);
                domain_create_request.m_registrant = contact_create_request.m_id;
                EPPDomainCreate domain_create = new EPPDomainCreate();
                domain_create.setRequestData(domain_create_request);
                domain_create = (EPPDomainCreate)epp_client.processAction(domain_create);
                epp_DomainCreateRsp domain_create_response = domain_create.getResponseData();
                response = domain_create_response.m_rsp;
                results2 = response.m_results;
                System.out.println("DomainCreate results: [" + results2[0].m_code + "] [" + results2[0].m_msg + "]");
                System.out.println("DomainCreate results: domain name [" + domain_create_response.m_name + "] exp date [" + domain_create_response.m_expiration_date + "]");
            }
            catch (epp_XMLException xcp) {
                System.err.println("epp_XMLException! [" + xcp.m_error_message + "]");
            }
            catch (epp_Exception xcp) {
                System.err.println("epp_Exception!");
                results = xcp.m_details;
                System.err.println("\tresult: [" + results[0] + "]");
            }
            catch (Exception xcp) {
                System.err.println("Domain Create failed! [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
                xcp.printStackTrace();
            }
            try {
                System.out.println("Creating the Domain Info command");
                epp_DomainInfoReq domain_info_request = new epp_DomainInfoReq();
                command_data = new epp_Command();
                command_data.m_client_trid = DomainExample.getClientTrid(epp_client_id);
                domain_info_request.m_cmd = command_data;
                domain_info_request.m_name = epp_domain_name;
                EPPDomainInfo domain_info = new EPPDomainInfo();
                domain_info.setRequestData(domain_info_request);
                domain_info = (EPPDomainInfo)epp_client.processAction(domain_info);
                epp_DomainInfoRsp domain_info_response = domain_info.getResponseData();
                response2 = domain_info_response.m_rsp;
                results3 = response2.m_results;
                domain_auth_info = domain_info_response.m_auth_info;
                System.out.println("DomainInfo results: [" + results3[0].m_code + "] [" + results3[0].m_msg + "]");
                System.out.println("DomainInfo results: clID [" + domain_info_response.m_client_id + "] crID [" + domain_info_response.m_created_by + "]");
                System.out.println("DomainInfo results: crDate [" + domain_info_response.m_created_date + "] upDate [" + domain_info_response.m_updated_date + "]");
                System.out.println("DomainInfo results: exDate [" + domain_info_response.m_expiration_date + "]");
                domain_exp_date = RTKBase.UTC_FMT.parse(domain_info_response.m_expiration_date);
                if (domain_auth_info != null) {
                    System.out.println("Domain's authID [" + domain_auth_info.m_value + "]");
                }
            }
            catch (epp_XMLException xcp) {
                System.err.println("epp_XMLException! [" + xcp.m_error_message + "]");
            }
            catch (epp_Exception xcp) {
                System.err.println("epp_Exception!");
                results = xcp.m_details;
                System.err.println("\tresult: [" + results[0] + "]");
            }
            catch (Exception xcp) {
                System.err.println("Domain Info failed! [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
                xcp.printStackTrace();
            }
            try {
                System.out.println("Creating the Domain Update command");
                epp_DomainUpdateReq domain_update_request = new epp_DomainUpdateReq();
                command_data = new epp_Command();
                command_data.m_client_trid = DomainExample.getClientTrid(epp_client_id);
                domain_update_request.m_cmd = command_data;
                domain_update_request.m_name = epp_domain_name;
                epp_DomainUpdateAddRemove add = new epp_DomainUpdateAddRemove();
                ArrayList<String> name_server_list = new ArrayList<String>();
                name_server_list.add("ns1.domain.info");
                name_server_list.add("ns2.domain.info");
                add.m_name_servers = EPPXMLBase.convertListToStringArray(name_server_list);
                add.m_status = new epp_DomainStatus[1];
                add.m_status[0] = new epp_DomainStatus();
                add.m_status[0].m_type = epp_DomainStatusType.CLIENT_TRANSFER_PROHIBITED;
                add.m_status[0].m_lang = "fr";
                add.m_status[0].m_value = "Le client n'as pas envoy\ufffd de l'argent";
                domain_update_request.m_add = add;
                epp_DomainUpdateAddRemove remove = new epp_DomainUpdateAddRemove();
                name_server_list = new ArrayList();
                name_server_list.add("ns1.domaindirect.com");
                name_server_list.add("ns2.domaindirect.com");
                remove.m_name_servers = EPPXMLBase.convertListToStringArray(name_server_list);
                domain_update_request.m_remove = remove;
                domain_update_request.m_change = new epp_DomainUpdateChange();
                BufferedReader buffed_reader = new BufferedReader(new InputStreamReader(System.in));
                epp_AuthInfo domain_auth_info_new = new epp_AuthInfo();
                System.out.println("---Now, give you an opportunity to change the passphrase for your domain---");
                System.out.print("Input the new passphrase or just press 'Enter' to ignore (min 6, max 16): ");
                domain_auth_info_new.m_value = buffed_reader.readLine();
                if (domain_auth_info_new.m_value != null) {
                    domain_update_request.m_change.m_auth_info = domain_auth_info_new;
                    domain_auth_info = domain_auth_info_new;
                }
                EPPDomainUpdate domain_update = new EPPDomainUpdate();
                domain_update.setRequestData(domain_update_request);
                domain_update = (EPPDomainUpdate)epp_client.processAction(domain_update);
                epp_DomainUpdateRsp domain_update_response = domain_update.getResponseData();
                epp_Response response4 = domain_update_response.m_rsp;
                epp_Result[] results6 = response4.m_results;
                System.out.println("DomainUpdate results: [" + results6[0].m_code + "] [" + results6[0].m_msg + "]");
            }
            catch (epp_XMLException xcp) {
                System.err.println("epp_XMLException! [" + xcp.m_error_message + "]");
            }
            catch (epp_Exception xcp) {
                System.err.println("epp_Exception!");
                results = xcp.m_details;
                System.err.println("\tresult: [" + results[0] + "]");
            }
            catch (Exception xcp) {
                System.err.println("Domain Update failed! [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
                xcp.printStackTrace();
            }
            try {
                System.out.println("Creating the Domain Renew command");
                epp_DomainRenewReq domain_renew_request = new epp_DomainRenewReq();
                command_data = new epp_Command();
                command_data.m_client_trid = DomainExample.getClientTrid(epp_client_id);
                domain_renew_request.m_cmd = command_data;
                domain_renew_request.m_name = epp_domain_name;
                domain_renew_request.m_period = new epp_DomainPeriod();
                domain_renew_request.m_period.m_unit = epp_DomainPeriodUnitType.YEAR;
                domain_renew_request.m_period.m_value = (short)2;
                domain_renew_request.m_current_expiration_date = RTKBase.DATE_FMT.format(domain_exp_date);
                EPPDomainRenew domain_renew = new EPPDomainRenew();
                domain_renew.setRequestData(domain_renew_request);
                domain_renew = (EPPDomainRenew)epp_client.processAction(domain_renew);
                epp_DomainRenewRsp domain_renew_response = domain_renew.getResponseData();
                response2 = domain_renew_response.m_rsp;
                results3 = response2.m_results;
                System.out.println("DomainRenew results: [" + results3[0].m_code + "] [" + results3[0].m_msg + "]");
                System.out.println("DomainRenew results: new exDate [" + domain_renew_response.m_expiration_date + "]");
            }
            catch (epp_XMLException xcp) {
                System.err.println("epp_XMLException! [" + xcp.m_error_message + "]");
            }
            catch (epp_Exception xcp) {
                System.err.println("epp_Exception!");
                results = xcp.m_details;
                System.err.println("\tresult: [" + results[0] + "]");
            }
            catch (Exception xcp) {
                System.err.println("Domain Renew failed! [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
                xcp.printStackTrace();
            }
            try {
                System.out.println("Creating the Domain Transfer command");
                epp_DomainTransferReq domain_transfer_request = new epp_DomainTransferReq();
                command_data = new epp_Command();
                command_data.m_client_trid = DomainExample.getClientTrid(epp_client_id);
                domain_transfer_request.m_cmd = command_data;
                epp_TransferRequest transfer_request = new epp_TransferRequest();
                transfer_request.m_op = epp_TransferOpType.QUERY;
                transfer_request.m_auth_info = domain_auth_info;
                domain_transfer_request.m_trans = transfer_request;
                domain_transfer_request.m_name = epp_domain_name;
                EPPDomainTransfer domain_transfer = new EPPDomainTransfer();
                domain_transfer.setRequestData(domain_transfer_request);
                domain_transfer = (EPPDomainTransfer)epp_client.processAction(domain_transfer);
                epp_DomainTransferRsp domain_transfer_response = domain_transfer.getResponseData();
                epp_Response response5 = domain_transfer_response.m_rsp;
                epp_Result[] results7 = response5.m_results;
                System.out.println("DomainTransfer results: [" + results7[0].m_code + "] [" + results7[0].m_msg + "]");
                System.out.println("DomainTransfer Results: transfer status [" + domain_transfer_response.getTrnData().getTransferStatus() + "]");
            }
            catch (epp_XMLException xcp) {
                System.err.println("epp_XMLException! [" + xcp.m_error_message + "]");
            }
            catch (epp_Exception xcp) {
                System.err.println("epp_Exception!");
                results = xcp.m_details;
                System.err.println("\tresult: [" + results[0] + "]");
            }
            catch (Exception xcp) {
                System.err.println("Domain Transfer (Query) failed! [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
                xcp.printStackTrace();
            }
            try {
                System.out.println("Creating the Domain Delete command");
                epp_DomainDeleteReq domain_delete_request = new epp_DomainDeleteReq();
                command_data = new epp_Command();
                command_data.m_client_trid = DomainExample.getClientTrid(epp_client_id);
                domain_delete_request.m_cmd = command_data;
                domain_delete_request.m_name = epp_domain_name;
                EPPDomainDelete domain_delete = new EPPDomainDelete();
                domain_delete.setRequestData(domain_delete_request);
                domain_delete = (EPPDomainDelete)epp_client.processAction(domain_delete);
                epp_DomainDeleteRsp domain_delete_response = domain_delete.getResponseData();
                response2 = domain_delete_response.m_rsp;
                results3 = response2.m_results;
                System.out.println("DomainDelete results: [" + results3[0].m_code + "] [" + results3[0].m_msg + "]");
            }
            catch (epp_XMLException xcp) {
                System.err.println("epp_XMLException! [" + xcp.m_error_message + "]");
            }
            catch (epp_Exception xcp) {
                System.err.println("epp_Exception!");
                results = xcp.m_details;
                System.err.println("\tresult: [" + results[0] + "]");
            }
            catch (Exception xcp) {
                System.err.println("Domain Delete failed! [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
                xcp.printStackTrace();
            }
            System.out.println("Logging out from the EPP Server");
            epp_client.logout(DomainExample.getClientTrid(epp_client_id));
            System.out.println("Disconnecting from the EPP Server");
            epp_client.disconnect();
        }
        catch (epp_XMLException xcp) {
            System.err.println("epp_XMLException! [" + xcp.m_error_message + "]");
        }
        catch (epp_Exception xcp) {
            System.err.println("epp_Exception!");
            epp_Result[] results = xcp.m_details;
            System.err.println("\tresult: [" + results[0] + "]");
        }
        catch (Exception xcp) {
            System.err.println("Exception! [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
            xcp.printStackTrace();
        }
    }

    protected static String getClientTrid(String epp_client_id) {
        return "ABC:" + epp_client_id + ":" + System.currentTimeMillis();
    }
}

