/*
 * Decompiled with CFR 0.152.
 */
package com.tucows.oxrs.epp0402.rtk.xml;

import com.tucows.oxrs.epp0402.rtk.xml.EPPXMLBase;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.xerces.dom.DocumentImpl;
import org.openrtk.idl.epp0402.epp_Command;
import org.openrtk.idl.epp0402.epp_Exception;
import org.openrtk.idl.epp0402.epp_Login;
import org.openrtk.idl.epp0402.epp_LoginReq;
import org.openrtk.idl.epp0402.epp_LoginRsp;
import org.openrtk.idl.epp0402.epp_Service;
import org.openrtk.idl.epp0402.epp_XMLException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EPPLogin
extends EPPXMLBase
implements epp_Login {
    private epp_LoginReq action_request_;
    private epp_LoginRsp action_response_;

    public EPPLogin() {
    }

    public EPPLogin(String xml) throws epp_XMLException, epp_Exception {
        String method_name = "EPPLogin(String)";
        this.debug(2, method_name, "xml is [" + xml + "]");
        this.fromXML(xml);
    }

    @Override
    public void setRequestData(epp_LoginReq value) {
        this.action_request_ = value;
    }

    @Override
    public epp_LoginRsp getResponseData() {
        return this.action_response_;
    }

    @Override
    public String toXML() throws epp_Exception, epp_XMLException {
        String request_xml;
        String method_name = "toXML(EPPLoginReq)";
        this.debug(3, method_name, "Entered");
        if (this.action_request_ == null || this.action_request_.m_cmd == null || this.action_request_.m_cmd.m_creds == null) {
            throw new epp_XMLException("missing login request or creds data");
        }
        if (this.action_request_.m_services == null) {
            throw new epp_XMLException("missing services in login");
        }
        DocumentImpl doc = new DocumentImpl();
        Element root = this.createDocRoot((Document)doc);
        Element command = doc.createElement("command");
        Element login = doc.createElement("login");
        epp_Command command_data = this.action_request_.m_cmd;
        Element creds = this.prepareCreds((Document)doc, command_data.m_creds);
        command.appendChild(creds);
        List<epp_Service> services = Arrays.asList(this.action_request_.m_services);
        Element services_element = doc.createElement("svcs");
        for (epp_Service service : services) {
            Element service_element = doc.createElement(service.m_name + ":svc");
            service_element.setAttribute("xmlns:" + service.m_name, service.m_xmlns);
            service_element.setAttribute("xsi:schemaLocation", service.m_schema_location);
            services_element.appendChild(service_element);
        }
        if (this.action_request_.m_unspec_services != null) {
            List<epp_Service> unspec_services = Arrays.asList(this.action_request_.m_unspec_services);
            Element unspec_services_element = doc.createElement("unspec");
            for (epp_Service service : unspec_services) {
                Element service_element = doc.createElement(service.m_name + ":svc");
                service_element.setAttribute("xmlns:" + service.m_name, service.m_xmlns);
                service_element.setAttribute("xsi:schemaLocation", service.m_schema_location);
                unspec_services_element.appendChild(service_element);
            }
            services_element.appendChild(unspec_services_element);
        }
        login.appendChild(services_element);
        command.appendChild(login);
        command.appendChild(this.prepareUnspecElement((Document)doc, command_data.m_unspec));
        if (command_data.m_client_trid != null) {
            this.addXMLElement((Document)doc, command, "clTRID", command_data.m_client_trid);
        }
        root.appendChild(command);
        doc.appendChild(root);
        try {
            request_xml = this.createXMLFromDoc((Document)doc);
        }
        catch (IOException xcp) {
            throw new epp_XMLException("IOException in building XML [" + xcp.getMessage() + "]");
        }
        this.debug(3, method_name, "Leaving");
        return request_xml;
    }

    @Override
    public void fromXML(String xml) throws epp_XMLException, epp_Exception {
        String method_name = "fromXML()";
        this.debug(3, method_name, "Entered");
        this.xml_ = xml;
        try {
            Element epp_node = this.getDocumentElement();
            Node response_node = epp_node.getElementsByTagName("response").item(0);
            if (response_node == null) {
                throw new epp_XMLException("unparsable or missing response");
            }
            this.action_response_ = new epp_LoginRsp();
            this.action_response_.m_rsp = this.parseGenericResult(response_node);
            if (this.action_response_.m_rsp.m_results[0].m_code >= 2000) {
                throw new epp_Exception(this.action_response_.m_rsp.m_results);
            }
        }
        catch (epp_Exception xcp) {
            this.debug(1, method_name, (Exception)((Object)xcp));
            throw xcp;
        }
        catch (Exception xcp) {
            this.debug(1, method_name, xcp);
            throw new epp_XMLException("unable to parse xml [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
        }
    }
}

