/*
 * Decompiled with CFR 0.152.
 */
package com.tucows.oxrs.epp0402.rtk.xml;

import com.tucows.oxrs.epp0402.rtk.xml.EPPHostBase;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.xerces.dom.DocumentImpl;
import org.openrtk.idl.epp0402.epp_Command;
import org.openrtk.idl.epp0402.epp_Exception;
import org.openrtk.idl.epp0402.epp_XMLException;
import org.openrtk.idl.epp0402.host.epp_HostAddress;
import org.openrtk.idl.epp0402.host.epp_HostAddressType;
import org.openrtk.idl.epp0402.host.epp_HostInfo;
import org.openrtk.idl.epp0402.host.epp_HostInfoReq;
import org.openrtk.idl.epp0402.host.epp_HostInfoRsp;
import org.openrtk.idl.epp0402.host.epp_HostStatus;
import org.openrtk.idl.epp0402.host.epp_HostStatusType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class EPPHostInfo
extends EPPHostBase
implements epp_HostInfo {
    private epp_HostInfoReq action_request_;
    private epp_HostInfoRsp action_response_;

    public EPPHostInfo() {
    }

    public EPPHostInfo(String xml) throws epp_XMLException, epp_Exception {
        String method_name = "EPPHostInfo(String)";
        this.debug(2, method_name, "xml is [" + xml + "]");
        this.fromXML(xml);
    }

    @Override
    public void setRequestData(epp_HostInfoReq value) {
        this.action_request_ = value;
    }

    @Override
    public epp_HostInfoRsp getResponseData() {
        return this.action_response_;
    }

    @Override
    public String toXML() throws epp_XMLException {
        String request_xml;
        String method_name = "buildRequestXML()";
        this.debug(3, method_name, "Entered");
        if (this.action_request_ == null || this.action_request_.m_cmd == null || this.action_request_.m_name == null) {
            throw new epp_XMLException("missing request data or host name");
        }
        DocumentImpl doc = new DocumentImpl();
        Element root = this.createDocRoot((Document)doc);
        Element command = doc.createElement("command");
        Element info = doc.createElement("info");
        epp_Command command_data = this.action_request_.m_cmd;
        if (command_data.m_creds != null) {
            command.appendChild(this.prepareCreds((Document)doc, command_data.m_creds));
        }
        Element host_info = doc.createElement("host:info");
        this.setCommonAttributes(host_info);
        this.addXMLElement((Document)doc, host_info, "host:name", this.action_request_.m_name);
        info.appendChild(host_info);
        command.appendChild(info);
        command.appendChild(this.prepareUnspecElement((Document)doc, command_data.m_unspec));
        if (command_data.m_client_trid != null) {
            this.addXMLElement((Document)doc, command, "clTRID", command_data.m_client_trid);
        }
        root.appendChild(command);
        doc.appendChild(root);
        try {
            request_xml = this.createXMLFromDoc((Document)doc);
        }
        catch (IOException xcp) {
            throw new epp_XMLException("IOException in building XML [" + xcp.getMessage() + "]");
        }
        this.debug(3, method_name, "Leaving");
        return request_xml;
    }

    @Override
    public void fromXML(String xml) throws epp_XMLException, epp_Exception {
        String method_name = "fromXML()";
        this.debug(3, method_name, "Entered");
        this.xml_ = xml;
        try {
            Element epp_node = this.getDocumentElement();
            Node response_node = epp_node.getElementsByTagName("response").item(0);
            if (response_node == null) {
                throw new epp_XMLException("unparsable or missing response");
            }
            this.action_response_ = new epp_HostInfoRsp();
            this.action_response_.m_rsp = this.parseGenericResult(response_node);
            if (this.action_response_.m_rsp.m_results[0].m_code >= 2000) {
                throw new epp_Exception(this.action_response_.m_rsp.m_results);
            }
            Element response_data_element = this.getElement(response_node.getChildNodes(), "resData");
            NodeList host_info_result_list = response_data_element.getElementsByTagName("host:infData").item(0).getChildNodes();
            this.debug(2, method_name, "host:infData's node count [" + host_info_result_list.getLength() + "]");
            if (host_info_result_list.getLength() == 0) {
                throw new epp_XMLException("missing info results");
            }
            ArrayList<epp_HostAddress> addresses = new ArrayList<epp_HostAddress>();
            ArrayList<epp_HostStatus> statuses = new ArrayList<epp_HostStatus>();
            for (int count = 0; count < host_info_result_list.getLength(); ++count) {
                Node a_node = host_info_result_list.item(count);
                if (a_node.getNodeName().equals("host:name")) {
                    this.action_response_.m_name = a_node.getFirstChild().getNodeValue();
                }
                if (a_node.getNodeName().equals("host:roid")) {
                    this.action_response_.m_roid = a_node.getFirstChild().getNodeValue();
                }
                if (a_node.getNodeName().equals("host:addr")) {
                    epp_HostAddress address = new epp_HostAddress();
                    address.m_ip = a_node.getFirstChild().getNodeValue();
                    address.m_type = !host_ip_to_type_hash_.containsKey(((Element)a_node).getAttribute("ip")) ? epp_HostAddressType.IPV4 : (epp_HostAddressType)host_ip_to_type_hash_.get(((Element)a_node).getAttribute("ip"));
                    addresses.add(address);
                }
                if (a_node.getNodeName().equals("host:status")) {
                    String lang;
                    epp_HostStatus status = new epp_HostStatus();
                    Node status_value_node = a_node.getFirstChild();
                    if (status_value_node != null) {
                        status.m_value = status_value_node.getNodeValue();
                    }
                    if ((lang = ((Element)a_node).getAttribute("lang")) != null && lang.length() > 0) {
                        status.m_lang = lang;
                    }
                    if (!host_status_hash_.containsKey(((Element)a_node).getAttribute("s"))) {
                        status.m_value = "invalid host status from server";
                        status.m_lang = "en";
                        status.m_type = null;
                    } else {
                        status.m_type = (epp_HostStatusType)host_status_hash_.get(((Element)a_node).getAttribute("s"));
                    }
                    statuses.add(status);
                }
                if (a_node.getNodeName().equals("host:clID")) {
                    this.action_response_.m_client_id = a_node.getFirstChild().getNodeValue();
                }
                if (a_node.getNodeName().equals("host:crID")) {
                    this.action_response_.m_created_by = a_node.getFirstChild().getNodeValue();
                }
                if (a_node.getNodeName().equals("host:crDate")) {
                    this.action_response_.m_created_date = a_node.getFirstChild().getNodeValue();
                }
                if (a_node.getNodeName().equals("host:upID")) {
                    this.action_response_.m_updated_by = a_node.getFirstChild().getNodeValue();
                }
                if (a_node.getNodeName().equals("host:upDate")) {
                    this.action_response_.m_updated_date = a_node.getFirstChild().getNodeValue();
                }
                if (!a_node.getNodeName().equals("host:trDate")) continue;
                this.action_response_.m_transfer_date = a_node.getFirstChild().getNodeValue();
            }
            if (addresses.size() > 0) {
                this.action_response_.m_addresses = (epp_HostAddress[])EPPHostInfo.convertListToArray(new epp_HostAddress().getClass(), addresses);
            }
            if (statuses.size() > 0) {
                this.action_response_.m_status = (epp_HostStatus[])EPPHostInfo.convertListToArray(new epp_HostStatus().getClass(), statuses);
            }
        }
        catch (SAXException xcp) {
            this.debug(1, method_name, xcp);
            throw new epp_XMLException("unable to parse xml [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
        }
        catch (IOException xcp) {
            this.debug(1, method_name, xcp);
            throw new epp_XMLException("unable to parse xml [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
        }
    }
}

