/*
 * Decompiled with CFR 0.152.
 */
package com.tucows.oxrs.epp0402.rtk.xml;

import com.tucows.oxrs.epp0402.rtk.xml.EPPXMLBase;
import java.util.Hashtable;
import org.openrtk.idl.epp0402.host.epp_HostAddressType;
import org.openrtk.idl.epp0402.host.epp_HostStatusType;
import org.w3c.dom.Element;

public abstract class EPPHostBase
extends EPPXMLBase {
    protected static Hashtable host_status_hash_;
    protected static Hashtable host_ip_to_type_hash_;

    protected EPPHostBase() {
        EPPHostBase.initHashes();
    }

    protected EPPHostBase(String xml) {
        super(xml);
        EPPHostBase.initHashes();
    }

    public static void initHashes() {
        EPPHostBase.initHostIpToTypeHash();
        EPPHostBase.initHostStatusHash();
    }

    protected static void initHostIpToTypeHash() {
        if (host_ip_to_type_hash_ == null) {
            host_ip_to_type_hash_ = new Hashtable();
            host_ip_to_type_hash_.put("v4", epp_HostAddressType.IPV4);
            host_ip_to_type_hash_.put("v6", epp_HostAddressType.IPV6);
        }
    }

    protected static void initHostStatusHash() {
        if (host_status_hash_ == null) {
            host_status_hash_ = new Hashtable();
            host_status_hash_.put("clientDeleteProhibited", epp_HostStatusType.CLIENT_DELETE_PROHIBITED);
            host_status_hash_.put("clientUpdateProhibited", epp_HostStatusType.CLIENT_UPDATE_PROHIBITED);
            host_status_hash_.put("linked", epp_HostStatusType.LINKED);
            host_status_hash_.put("ok", epp_HostStatusType.OK);
            host_status_hash_.put("pendingDelete", epp_HostStatusType.PENDING_DELETE);
            host_status_hash_.put("pendingTransfer", epp_HostStatusType.PENDING_TRANSFER);
            host_status_hash_.put("serverDeleteProhibited", epp_HostStatusType.SERVER_DELETE_PROHIBITED);
            host_status_hash_.put("serverUpdateProhibited", epp_HostStatusType.SERVER_UPDATE_PROHIBITED);
        }
    }

    protected void setCommonAttributes(Element command) {
        command.setAttribute("xmlns:host", "urn:iana:xml:ns:host-1.0");
        command.setAttribute("xsi:schemaLocation", "urn:iana:xml:ns:host-1.0 host-1.0.xsd");
    }

    public static String hostStatusToString(epp_HostStatusType status_type) {
        return status_type.toString();
    }

    public static String hostAddressTypeToString(epp_HostAddressType address_type) {
        return address_type.toString();
    }

    public static epp_HostStatusType hostStatusFromString(String s) {
        EPPHostBase.initHostStatusHash();
        return (epp_HostStatusType)host_status_hash_.get(s);
    }
}

