/*
 * Decompiled with CFR 0.152.
 */
package com.tucows.oxrs.epp0402.rtk.xml;

import com.tucows.oxrs.epp0402.rtk.xml.EPPDomainBase;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.xerces.dom.DocumentImpl;
import org.openrtk.idl.epp0402.domain.epp_DomainContact;
import org.openrtk.idl.epp0402.domain.epp_DomainStatus;
import org.openrtk.idl.epp0402.domain.epp_DomainUpdate;
import org.openrtk.idl.epp0402.domain.epp_DomainUpdateAddRemove;
import org.openrtk.idl.epp0402.domain.epp_DomainUpdateReq;
import org.openrtk.idl.epp0402.domain.epp_DomainUpdateRsp;
import org.openrtk.idl.epp0402.epp_Command;
import org.openrtk.idl.epp0402.epp_Exception;
import org.openrtk.idl.epp0402.epp_XMLException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class EPPDomainUpdate
extends EPPDomainBase
implements epp_DomainUpdate {
    private epp_DomainUpdateReq action_request_;
    private epp_DomainUpdateRsp action_response_;

    public EPPDomainUpdate() {
    }

    public EPPDomainUpdate(String xml) throws epp_XMLException, epp_Exception {
        String method_name = "EPPDomainUpdate(String)";
        this.debug(2, method_name, "xml is [" + xml + "]");
        this.fromXML(xml);
    }

    @Override
    public void setRequestData(epp_DomainUpdateReq value) {
        this.action_request_ = value;
    }

    @Override
    public epp_DomainUpdateRsp getResponseData() {
        return this.action_response_;
    }

    @Override
    public String toXML() throws epp_XMLException {
        String request_xml;
        Element remove_element;
        String method_name = "buildRequestXML()";
        this.debug(3, method_name, "Entered");
        if (this.action_request_ == null || this.action_request_.m_cmd == null || this.action_request_.m_name == null) {
            throw new epp_XMLException("missing request data or domain name");
        }
        DocumentImpl doc = new DocumentImpl();
        Element root = this.createDocRoot((Document)doc);
        Element command = doc.createElement("command");
        Element update = doc.createElement("update");
        epp_Command command_data = this.action_request_.m_cmd;
        if (command_data.m_creds != null) {
            command.appendChild(this.prepareCreds((Document)doc, command_data.m_creds));
        }
        Element domain_update = doc.createElement("domain:update");
        this.setCommonAttributes(domain_update);
        this.addXMLElement((Document)doc, domain_update, "domain:name", this.action_request_.m_name);
        Element add_element = this.getAddRemoveElement((Document)doc, this.action_request_.m_add, "domain:add");
        if (add_element != null) {
            domain_update.appendChild(add_element);
        }
        if ((remove_element = this.getAddRemoveElement((Document)doc, this.action_request_.m_remove, "domain:rem")) != null) {
            domain_update.appendChild(remove_element);
        }
        if (this.action_request_.m_change != null) {
            Element change_element = doc.createElement("domain:chg");
            if (this.action_request_.m_change.m_registrant != null) {
                this.addXMLElement((Document)doc, change_element, "domain:registrant", this.action_request_.m_change.m_registrant);
            }
            if (this.action_request_.m_change.m_auth_info != null) {
                change_element.appendChild(this.prepareAuthInfo((Document)doc, "domain:authInfo", this.action_request_.m_change.m_auth_info));
            }
            domain_update.appendChild(change_element);
        }
        update.appendChild(domain_update);
        command.appendChild(update);
        command.appendChild(this.prepareUnspecElement((Document)doc, command_data.m_unspec));
        if (command_data.m_client_trid != null) {
            this.addXMLElement((Document)doc, command, "clTRID", command_data.m_client_trid);
        }
        root.appendChild(command);
        doc.appendChild(root);
        try {
            request_xml = this.createXMLFromDoc((Document)doc);
        }
        catch (IOException xcp) {
            throw new epp_XMLException("IOException in building XML [" + xcp.getMessage() + "]");
        }
        this.debug(3, method_name, "Leaving");
        return request_xml;
    }

    private Element getAddRemoveElement(Document doc, epp_DomainUpdateAddRemove add_remove_items, String tag_name) throws epp_XMLException {
        String method_name = "getAddRemoveElement(Document, epp_DomainUpdateAddRemove, String)";
        this.debug(3, method_name, "Entered");
        Element add_remove_element = null;
        if (add_remove_items != null) {
            if (add_remove_items.m_name_servers != null && add_remove_items.m_name_servers.length > 0) {
                add_remove_element = doc.createElement(tag_name);
                List<String> server_list = Arrays.asList(add_remove_items.m_name_servers);
                for (String server_name : server_list) {
                    this.addXMLElement(doc, add_remove_element, "domain:ns", server_name);
                }
            }
            if (add_remove_items.m_contacts != null && add_remove_items.m_contacts.length > 0) {
                if (add_remove_element == null) {
                    add_remove_element = doc.createElement(tag_name);
                }
                List<epp_DomainContact> contact_list = Arrays.asList(add_remove_items.m_contacts);
                for (epp_DomainContact domain_contact : contact_list) {
                    Element contact_element = this.addXMLElement(doc, add_remove_element, "domain:contact", domain_contact.m_id);
                    contact_element.setAttribute("type", domain_contact.m_type.toString());
                }
            }
            if (add_remove_items.m_status != null && add_remove_items.m_status.length > 0) {
                if (add_remove_element == null) {
                    add_remove_element = doc.createElement(tag_name);
                }
                List<epp_DomainStatus> status_list = Arrays.asList(add_remove_items.m_status);
                for (epp_DomainStatus status : status_list) {
                    Element status_element = this.addXMLElement(doc, add_remove_element, "domain:status", status.m_value);
                    status_element.setAttribute("s", status.m_type.toString());
                    if (status.m_lang == null) continue;
                    status_element.setAttribute("lang", status.m_lang);
                }
            }
        }
        this.debug(3, method_name, "Leaving");
        return add_remove_element;
    }

    @Override
    public void fromXML(String xml) throws epp_XMLException, epp_Exception {
        String method_name = "fromXML()";
        this.debug(3, method_name, "Entered");
        this.xml_ = xml;
        try {
            Element epp_node = this.getDocumentElement();
            Node response_node = epp_node.getElementsByTagName("response").item(0);
            if (response_node == null) {
                throw new epp_XMLException("unparsable or missing response");
            }
            this.action_response_ = new epp_DomainUpdateRsp();
            this.action_response_.m_rsp = this.parseGenericResult(response_node);
            if (this.action_response_.m_rsp.m_results[0].m_code >= 2000) {
                throw new epp_Exception(this.action_response_.m_rsp.m_results);
            }
        }
        catch (SAXException xcp) {
            this.debug(1, method_name, xcp);
            throw new epp_XMLException("unable to parse xml [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
        }
        catch (IOException xcp) {
            this.debug(1, method_name, xcp);
            throw new epp_XMLException("unable to parse xml [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
        }
    }
}

