/*
 * Decompiled with CFR 0.152.
 */
package com.tucows.oxrs.epp0402.rtk.xml;

import com.tucows.oxrs.epp0402.rtk.xml.EPPContactBase;
import java.io.IOException;
import org.apache.xerces.dom.DocumentImpl;
import org.openrtk.idl.epp0402.contact.epp_ContactTransfer;
import org.openrtk.idl.epp0402.contact.epp_ContactTransferReq;
import org.openrtk.idl.epp0402.contact.epp_ContactTransferRsp;
import org.openrtk.idl.epp0402.epp_Command;
import org.openrtk.idl.epp0402.epp_Exception;
import org.openrtk.idl.epp0402.epp_TransferOpType;
import org.openrtk.idl.epp0402.epp_TransferRequest;
import org.openrtk.idl.epp0402.epp_XMLException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class EPPContactTransfer
extends EPPContactBase
implements epp_ContactTransfer {
    private epp_ContactTransferReq action_request_;
    private epp_ContactTransferRsp action_response_;

    public EPPContactTransfer() {
    }

    public EPPContactTransfer(String xml) throws epp_XMLException, epp_Exception {
        String method_name = "EPPContactTransfer(String)";
        this.debug(2, method_name, "xml is [" + xml + "]");
        this.fromXML(xml);
    }

    @Override
    public void setRequestData(epp_ContactTransferReq value) {
        this.action_request_ = value;
    }

    @Override
    public epp_ContactTransferRsp getResponseData() {
        return this.action_response_;
    }

    @Override
    public String toXML() throws epp_XMLException {
        String request_xml;
        String method_name = "toXML()";
        this.debug(3, method_name, "Entered");
        if (this.action_request_ == null || this.action_request_.m_cmd == null || this.action_request_.m_trans == null || this.action_request_.m_id == null) {
            throw new epp_XMLException("missing request data or contact id");
        }
        epp_Command command_data = this.action_request_.m_cmd;
        epp_TransferRequest transfer_request_data = this.action_request_.m_trans;
        if (transfer_request_data.m_op == null) {
            this.debug(2, method_name, "transfer op is null, so assuming query");
            transfer_request_data.m_op = epp_TransferOpType.QUERY;
        }
        DocumentImpl doc = new DocumentImpl();
        Element root = this.createDocRoot((Document)doc);
        Element command = doc.createElement("command");
        if (command_data.m_creds != null) {
            command.appendChild(this.prepareCreds((Document)doc, command_data.m_creds));
        }
        Element transfer = doc.createElement("transfer");
        transfer.setAttribute("op", transfer_request_data.m_op.toString());
        Element contact_transfer = doc.createElement("contact:transfer");
        this.setCommonAttributes(contact_transfer);
        this.addXMLElement((Document)doc, contact_transfer, "contact:id", this.action_request_.m_id);
        transfer.appendChild(contact_transfer);
        if (transfer_request_data.m_auth_info != null) {
            contact_transfer.appendChild(this.prepareAuthInfo((Document)doc, "contact:authInfo", transfer_request_data.m_auth_info));
        } else if (transfer_request_data.m_op == epp_TransferOpType.REQUEST) {
            throw new epp_XMLException("missing request auth id");
        }
        command.appendChild(transfer);
        command.appendChild(this.prepareUnspecElement((Document)doc, command_data.m_unspec));
        if (command_data.m_client_trid != null) {
            this.addXMLElement((Document)doc, command, "clTRID", command_data.m_client_trid);
        }
        root.appendChild(command);
        doc.appendChild(root);
        try {
            request_xml = this.createXMLFromDoc((Document)doc);
        }
        catch (IOException xcp) {
            throw new epp_XMLException("IOException in building XML [" + xcp.getMessage() + "]");
        }
        this.debug(3, method_name, "Leaving");
        return request_xml;
    }

    @Override
    public void fromXML(String xml) throws epp_XMLException, epp_Exception {
        String method_name = "fromXML()";
        this.debug(3, method_name, "Entered");
        this.xml_ = xml;
        try {
            Element epp_node = this.getDocumentElement();
            Node response_node = epp_node.getElementsByTagName("response").item(0);
            if (response_node == null) {
                throw new epp_XMLException("unparsable or missing response");
            }
            this.action_response_ = new epp_ContactTransferRsp();
            this.action_response_.m_rsp = this.parseGenericResult(response_node);
            if (this.action_response_.m_rsp.m_results[0].m_code >= 2000) {
                throw new epp_Exception(this.action_response_.m_rsp.m_results);
            }
            Element response_data_element = this.getElement(response_node.getChildNodes(), "resData");
            NodeList contact_transfer_data_list = response_data_element.getElementsByTagName("contact:trnData").item(0).getChildNodes();
            this.debug(2, method_name, "contact:trnData's node count [" + contact_transfer_data_list.getLength() + "]");
            if (contact_transfer_data_list.getLength() == 0) {
                throw new epp_XMLException("missing contact transfer data");
            }
            this.action_response_.m_trn_data = EPPContactTransfer.getTrnData(contact_transfer_data_list);
        }
        catch (SAXException xcp) {
            this.debug(1, method_name, xcp);
            throw new epp_XMLException("unable to parse xml [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
        }
        catch (IOException xcp) {
            this.debug(1, method_name, xcp);
            throw new epp_XMLException("unable to parse xml [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
        }
    }
}

