/*
 * Decompiled with CFR 0.152.
 */
package com.tucows.oxrs.epp0402.rtk.xml;

import com.tucows.oxrs.epp0402.rtk.xml.EPPXMLBase;
import java.util.Hashtable;
import org.openrtk.idl.epp0402.contact.epp_ContactAddress;
import org.openrtk.idl.epp0402.contact.epp_ContactNameAddress;
import org.openrtk.idl.epp0402.contact.epp_ContactStatusType;
import org.openrtk.idl.epp0402.contact.epp_ContactTrnData;
import org.openrtk.idl.epp0402.epp_TransferStatusType;
import org.openrtk.idl.epp0402.epp_XMLException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class EPPContactBase
extends EPPXMLBase {
    protected static Hashtable contact_status_hash_;

    protected EPPContactBase() {
        EPPContactBase.initHashes();
    }

    protected EPPContactBase(String xml) {
        super(xml);
        EPPContactBase.initHashes();
    }

    public static void initHashes() {
        EPPContactBase.initContactStatusHash();
    }

    public static void initContactStatusHash() {
        if (contact_status_hash_ == null) {
            contact_status_hash_ = new Hashtable();
            contact_status_hash_.put("clientDeleteProhibited", epp_ContactStatusType.CLIENT_DELETE_PROHIBITED);
            contact_status_hash_.put("serverDeleteProhibited", epp_ContactStatusType.SERVER_DELETE_PROHIBITED);
            contact_status_hash_.put("clientTransferProhibited", epp_ContactStatusType.CLIENT_TRANSFER_PROHIBITED);
            contact_status_hash_.put("serverTransferProhibited", epp_ContactStatusType.SERVER_TRANSFER_PROHIBITED);
            contact_status_hash_.put("clientUpdateProhibited", epp_ContactStatusType.CLIENT_UPDATE_PROHIBITED);
            contact_status_hash_.put("serverUpdateProhibited", epp_ContactStatusType.SERVER_UPDATE_PROHIBITED);
            contact_status_hash_.put("linked", epp_ContactStatusType.LINKED);
            contact_status_hash_.put("ok", epp_ContactStatusType.OK);
            contact_status_hash_.put("pendingDelete", epp_ContactStatusType.PENDING_DELETE);
            contact_status_hash_.put("pendingTransfer", epp_ContactStatusType.PENDING_TRANSFER);
        }
    }

    protected void setCommonAttributes(Element command) {
        command.setAttribute("xmlns:contact", "urn:iana:xml:ns:contact-1.0");
        command.setAttribute("xsi:schemaLocation", "urn:iana:xml:ns:contact-1.0 contact-1.0.xsd");
    }

    protected Element addressToXML(Document doc, String tag_name, epp_ContactNameAddress name_address) throws epp_XMLException {
        String method_name = "addressToXML(Document, String, epp_ContactNameAddress)";
        this.debug(3, method_name, "Entered");
        Element name_address_element = null;
        if (name_address != null) {
            name_address_element = doc.createElement(tag_name);
            if (name_address.m_name != null) {
                this.addXMLElement(doc, name_address_element, "contact:name", name_address.m_name);
            }
            if (name_address.m_org != null) {
                this.addXMLElement(doc, name_address_element, "contact:org", name_address.m_org);
            }
            if (name_address.m_address != null) {
                epp_ContactAddress address = name_address.m_address;
                Element address_element = doc.createElement("contact:addr");
                if (address.m_street1 != null) {
                    this.addXMLElement(doc, address_element, "contact:street", address.m_street1);
                }
                if (address.m_street2 != null) {
                    this.addXMLElement(doc, address_element, "contact:street", address.m_street2);
                }
                if (address.m_street3 != null) {
                    this.addXMLElement(doc, address_element, "contact:street", address.m_street3);
                }
                if (address.m_city != null) {
                    this.addXMLElement(doc, address_element, "contact:city", address.m_city);
                }
                if (address.m_state_province != null) {
                    this.addXMLElement(doc, address_element, "contact:sp", address.m_state_province);
                }
                if (address.m_postal_code != null) {
                    this.addXMLElement(doc, address_element, "contact:pc", address.m_postal_code);
                }
                if (address.m_country_code != null) {
                    this.addXMLElement(doc, address_element, "contact:cc", address.m_country_code);
                }
                if (address_element.getChildNodes().getLength() > 0) {
                    name_address_element.appendChild(address_element);
                }
            }
        }
        this.debug(3, method_name, "Leaving");
        return name_address_element;
    }

    public static String contactStatusToString(epp_ContactStatusType status_type) {
        return status_type.toString();
    }

    public static epp_ContactStatusType contactStatusFromString(String s) {
        EPPContactBase.initContactStatusHash();
        return (epp_ContactStatusType)contact_status_hash_.get(s);
    }

    public static epp_ContactTrnData getTrnData(NodeList transfer_data_list) throws epp_XMLException {
        epp_ContactTrnData trn_data = new epp_ContactTrnData();
        for (int count = 0; count < transfer_data_list.getLength(); ++count) {
            Node a_node = transfer_data_list.item(count);
            if (a_node.getNodeName().equals("contact:id")) {
                trn_data.m_id = a_node.getFirstChild().getNodeValue();
            }
            if (a_node.getNodeName().equals("contact:reID")) {
                trn_data.m_request_client_id = a_node.getFirstChild().getNodeValue();
            }
            if (a_node.getNodeName().equals("contact:acID")) {
                trn_data.m_action_client_id = a_node.getFirstChild().getNodeValue();
            }
            if (a_node.getNodeName().equals("contact:trStatus")) {
                String status_value = a_node.getFirstChild().getNodeValue();
                if (!transfer_status_to_type_hash_.containsKey(status_value)) {
                    throw new epp_XMLException("unknown returned transfer status [" + status_value + "]");
                }
                trn_data.m_transfer_status = (epp_TransferStatusType)transfer_status_to_type_hash_.get(status_value);
            }
            if (a_node.getNodeName().equals("contact:reDate")) {
                trn_data.m_request_date = a_node.getFirstChild().getNodeValue();
            }
            if (!a_node.getNodeName().equals("contact:acDate")) continue;
            trn_data.m_action_date = a_node.getFirstChild().getNodeValue();
        }
        return trn_data;
    }
}

